/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.Quantity;
import org.apache.sis.coverage.RegionOfInterest;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ResampledGridCoverage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridCoverageProcessor
implements Cloneable {
    private static final WeakHashSet<ImageProcessor> PROCESSORS = new WeakHashSet(ImageProcessor.class);
    protected final ImageProcessor imageProcessor;

    static ImageProcessor unique(ImageProcessor imageProcessor) {
        return (ImageProcessor)PROCESSORS.unique((Object)imageProcessor);
    }

    public GridCoverageProcessor() {
        this.imageProcessor = new ImageProcessor();
    }

    public GridCoverageProcessor(ImageProcessor imageProcessor) {
        ArgumentChecks.ensureNonNull((String)"processor", (Object)imageProcessor);
        this.imageProcessor = imageProcessor.clone();
    }

    public Interpolation getInterpolation() {
        return this.imageProcessor.getInterpolation();
    }

    public void setInterpolation(Interpolation interpolation) {
        this.imageProcessor.setInterpolation(interpolation);
    }

    public Quantity<?>[] getPositionalAccuracyHints() {
        return this.imageProcessor.getPositionalAccuracyHints();
    }

    public void setPositionalAccuracyHints(Quantity<?> ... quantityArray) {
        this.imageProcessor.setPositionalAccuracyHints(quantityArray);
    }

    public Number[] getFillValues() {
        return this.imageProcessor.getFillValues();
    }

    public void setFillValues(Number ... numberArray) {
        this.imageProcessor.setFillValues(numberArray);
    }

    public GridCoverage mask(GridCoverage gridCoverage, RegionOfInterest regionOfInterest, boolean bl) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"source", (Object)gridCoverage);
        ArgumentChecks.ensureNonNull((String)"mask", (Object)regionOfInterest);
        Shape shape = regionOfInterest.toShape2D(gridCoverage.getGridGeometry());
        RenderedImage renderedImage = gridCoverage.render(null);
        renderedImage = this.imageProcessor.mask(renderedImage, shape, bl);
        return new GridCoverage2D(gridCoverage, renderedImage);
    }

    public GridCoverage resample(GridCoverage gridCoverage, GridGeometry gridGeometry) throws TransformException {
        GridCoverage gridCoverage2;
        boolean bl;
        ArgumentChecks.ensureNonNull((String)"source", (Object)gridCoverage);
        ArgumentChecks.ensureNonNull((String)"target", (Object)gridGeometry);
        boolean bl2 = bl = gridCoverage == gridCoverage.forConvertedValues(true);
        while (true) {
            if (ResampledGridCoverage.equivalent(gridCoverage.getGridGeometry(), gridGeometry)) {
                return gridCoverage;
            }
            if (gridCoverage instanceof ResampledGridCoverage) {
                gridCoverage = ((ResampledGridCoverage)gridCoverage).source;
                continue;
            }
            if (!(gridCoverage instanceof ConvertedGridCoverage)) break;
            gridCoverage = ((ConvertedGridCoverage)gridCoverage).source;
        }
        if (!Interpolation.NEAREST.equals(this.imageProcessor.getInterpolation())) {
            gridCoverage = gridCoverage.forConvertedValues(true);
        }
        try {
            gridCoverage2 = ResampledGridCoverage.create(gridCoverage, gridGeometry, this.imageProcessor);
        }
        catch (IllegalGridGeometryException illegalGridGeometryException) {
            Throwable throwable = illegalGridGeometryException.getCause();
            if (throwable instanceof TransformException) {
                throw (TransformException)throwable;
            }
            throw illegalGridGeometryException;
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
        }
        return gridCoverage2.forConvertedValues(bl);
    }

    static void recoverableException(String string, Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.raster"), GridCoverageProcessor.class, (String)string, (Throwable)exception);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridCoverageProcessor gridCoverageProcessor = (GridCoverageProcessor)object;
            return this.imageProcessor.equals(gridCoverageProcessor.imageProcessor);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.imageProcessor);
    }

    public GridCoverageProcessor clone() {
        try {
            GridCoverageProcessor gridCoverageProcessor = (GridCoverageProcessor)super.clone();
            FinalFieldSetter.set(GridCoverageProcessor.class, (String)"imageProcessor", (Object)gridCoverageProcessor, (Object)this.imageProcessor.clone());
            return gridCoverageProcessor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw FinalFieldSetter.cloneFailure((ReflectiveOperationException)reflectiveOperationException);
        }
    }
}

