/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorFunction;
import com.github.sommeri.less4j.core.compiler.expressions.ColorParameterUtils;
import com.github.sommeri.less4j.core.compiler.expressions.CssNameClashMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.HSLAValue;
import com.github.sommeri.less4j.core.compiler.expressions.UnknownFunction;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Saturate
extends CssNameClashMultiParameterFunction {
    private ColorParameterUtils paramUtils = new ColorParameterUtils();

    Saturate() {
    }

    @Override
    public Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression firstParam = splitParameters.get(0);
        if (firstParam.getType() != ASTCssNodeType.COLOR_EXPRESSION) {
            UnknownFunction unknownFunction = new UnknownFunction();
            return unknownFunction.evaluate(splitParameters, problemsHandler, call, evaluatedParameter);
        }
        ColorExpression color = (ColorExpression)firstParam;
        NumberExpression amount = (NumberExpression)splitParameters.get(1);
        HSLAValue hsla = AbstractColorFunction.toHSLA(color);
        boolean isAbsolute = this.paramUtils.isAbsolute(splitParameters, 2);
        if (isAbsolute) {
            this.applyAbsolute(amount, hsla);
        } else {
            this.applyRelative(amount, hsla);
        }
        return AbstractColorFunction.hsla(hsla, call.getUnderlyingStructure());
    }

    protected void applyAbsolute(NumberExpression amount, HSLAValue hsla) {
        hsla.s += amount.getValueAsDouble() / 100.0;
        hsla.s = AbstractColorFunction.clamp(hsla.s);
    }

    protected void applyRelative(NumberExpression amount, HSLAValue hsla) {
        hsla.s += hsla.s * amount.getValueAsDouble() / 100.0;
        hsla.s = AbstractColorFunction.clamp(hsla.s);
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 3;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COLOR_EXPRESSION);
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
            case 2: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, this.paramUtils.modeTypeAcceptableTypes());
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "saturate";
    }
}

