/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.function.UnaryOperator;
import org.apache.sis.referencing.operation.transform.WraparoundTransform;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.MathTransform;

final class WraparoundInEnvelope
extends WraparoundTransform {
    private static final long serialVersionUID = 4017870982753327584L;
    private double limit;
    private double minCycles;
    private double maxCycles;
    private boolean minChanged;
    private boolean maxChanged;

    private WraparoundInEnvelope(WraparoundTransform wraparoundTransform) {
        super(wraparoundTransform);
        this.maxCycles = this.limit = Math.rint(this.sourceMedian / this.period);
        this.minCycles = this.limit;
    }

    @Override
    protected final double shift(double d) {
        double d2 = Math.rint(d / this.period);
        if (d < this.sourceMedian) {
            if (d2 < this.limit) {
                if (d2 < this.minCycles) {
                    this.minCycles = d2;
                    this.minChanged = true;
                }
                d2 = this.limit;
            }
        } else if (d2 > this.limit) {
            if (d2 > this.maxCycles) {
                this.maxCycles = d2;
                this.maxChanged = true;
            }
            d2 = this.limit;
        }
        return d - d2 * this.period;
    }

    private boolean translate() {
        if (this.minChanged) {
            this.minChanged = false;
            this.limit = this.minCycles;
            return true;
        }
        if (this.maxChanged) {
            this.maxChanged = false;
            this.limit = this.maxCycles;
            return true;
        }
        return false;
    }

    static final class Controller
    implements UnaryOperator<WraparoundTransform> {
        final MathTransform transform;
        private WraparoundInEnvelope[] wraparounds;

        Controller(MathTransform mathTransform) {
            this.transform = WraparoundTransform.replace(mathTransform, this);
        }

        @Override
        public WraparoundTransform apply(WraparoundTransform wraparoundTransform) {
            if (!Double.isFinite(wraparoundTransform.sourceMedian)) {
                return wraparoundTransform;
            }
            WraparoundInEnvelope wraparoundInEnvelope = new WraparoundInEnvelope(wraparoundTransform);
            this.wraparounds = this.wraparounds == null ? new WraparoundInEnvelope[]{wraparoundInEnvelope} : (WraparoundInEnvelope[])ArraysExt.append((Object[])this.wraparounds, (Object)wraparoundInEnvelope);
            return wraparoundInEnvelope;
        }

        final boolean translate() {
            boolean bl = false;
            if (this.wraparounds != null) {
                for (WraparoundInEnvelope wraparoundInEnvelope : this.wraparounds) {
                    bl |= wraparoundInEnvelope.translate();
                }
            }
            return bl;
        }
    }
}

