/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.storage;

import io.meeds.poll.dao.PollDAO;
import io.meeds.poll.dao.PollOptionDAO;
import io.meeds.poll.dao.PollVoteDAO;
import io.meeds.poll.entity.PollEntity;
import io.meeds.poll.entity.PollOptionEntity;
import io.meeds.poll.entity.PollVoteEntity;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.utils.EntityMapper;
import java.util.List;
import java.util.stream.Collectors;

public class PollStorage {
    private PollDAO pollDAO;
    private PollOptionDAO pollOptionDAO;
    private PollVoteDAO pollVoteDAO;

    public PollStorage(PollDAO pollDAO, PollOptionDAO pollOptionDAO, PollVoteDAO pollVoteDAO) {
        this.pollDAO = pollDAO;
        this.pollOptionDAO = pollOptionDAO;
        this.pollVoteDAO = pollVoteDAO;
    }

    public Poll createPoll(Poll poll, List<PollOption> pollOptions) {
        PollEntity pollEntity = EntityMapper.toPollEntity(poll);
        pollEntity = (PollEntity)this.pollDAO.create(pollEntity);
        for (PollOption pollOption : pollOptions) {
            PollOptionEntity pollOptionEntity = EntityMapper.toPollOptionEntity(pollOption, pollEntity.getId());
            this.pollOptionDAO.create(pollOptionEntity);
        }
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public Poll getPollById(long pollId) {
        PollEntity pollEntity = (PollEntity)this.pollDAO.find(Long.valueOf(pollId));
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public List<PollOption> getPollOptionsByPollId(long pollId) {
        List<PollOptionEntity> pollOptionEntities = this.pollOptionDAO.findPollOptionsByPollId(pollId);
        return pollOptionEntities.stream().map(EntityMapper::fromPollOptionEntity).collect(Collectors.toList());
    }

    public Poll updatePoll(Poll poll) {
        PollEntity pollEntity = EntityMapper.toPollEntity(poll);
        pollEntity = (PollEntity)this.pollDAO.update(pollEntity);
        return EntityMapper.fromPollEntity(pollEntity);
    }

    public PollVote createPollVote(PollVote pollVote) {
        PollVoteEntity pollVoteEntity = EntityMapper.toPollVoteEntity(pollVote);
        pollVoteEntity = (PollVoteEntity)this.pollVoteDAO.create(pollVoteEntity);
        return EntityMapper.fromPollVoteEntity(pollVoteEntity);
    }

    public int countPollOptionTotalVotes(long pollOptionId) {
        return this.pollVoteDAO.countPollOptionTotalVotes(pollOptionId);
    }

    public int countPollOptionTotalVotesByUser(long pollOptionId, long userId) {
        return this.pollVoteDAO.countPollOptionTotalVotesByUser(pollOptionId, userId);
    }

    public PollOption getPollOptionById(long pollOptionId) {
        PollOptionEntity pollOptionEntity = (PollOptionEntity)this.pollOptionDAO.find(Long.valueOf(pollOptionId));
        return EntityMapper.fromPollOptionEntity(pollOptionEntity);
    }

    public int countPollOptionsByPollId(long pollId) {
        return this.pollOptionDAO.countPollOptionsByPollId(pollId);
    }

    public int countPollTotalVotes(long pollId) {
        return this.pollVoteDAO.countPollTotalVotes(pollId);
    }

    public boolean didVote(long currentUserIdentityId, Long pollId) {
        return this.pollVoteDAO.countUserVotesInPoll(pollId, currentUserIdentityId) > 0L;
    }
}

