/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common;

import com.ibm.icu.text.Transliterator;
import org.apache.commons.lang.StringUtils;

public class Utils {
    private static final Transliterator ACCENTS_CONVERTER = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    private static final String SIZE_SPLIT_CHAR = "x";

    private Utils() {
    }

    public static String processUnifiedSearchCondition(String input) {
        String[] tab;
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        if (input.indexOf("~") < 0 || input.indexOf("\\~") > 0) {
            return input.trim();
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(" ")) {
            if (s.isEmpty()) continue;
            if (s.indexOf("~") > -1) {
                String searchTerm = s.substring(0, s.lastIndexOf("~"));
                builder.append(searchTerm).append(" ");
                continue;
            }
            builder.append(s).append(" ");
        }
        return builder.toString().trim();
    }

    public static String removeSpecialCharacterInSpaceFilter(String input) {
        String result = input.replaceAll("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\?\\*%0-9\\']", " ");
        result = result.replaceAll("\\s+", " ");
        return result.trim();
    }

    public static String cleanString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("String argument must not be null.");
        }
        str = ACCENTS_CONVERTER.transliterate(str);
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (Character.getType(c) == 4 || !Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static int[] parseDimension(String size) {
        int[] dimension = new int[2];
        if (size.contains(SIZE_SPLIT_CHAR) && !size.startsWith(SIZE_SPLIT_CHAR)) {
            dimension[0] = Integer.parseInt(size.split(SIZE_SPLIT_CHAR)[0]);
        }
        if (size.contains(SIZE_SPLIT_CHAR) && !size.endsWith(SIZE_SPLIT_CHAR)) {
            dimension[1] = Integer.parseInt(size.split(SIZE_SPLIT_CHAR)[1]);
        }
        return dimension;
    }
}

