/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.Access;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.MethodDescriptor;

public abstract class IClass {
    private static final boolean DEBUG = false;
    public static final IClass VOID = new PrimitiveIClass("V");
    public static final IClass BYTE = new PrimitiveIClass("B");
    public static final IClass CHAR = new PrimitiveIClass("C");
    public static final IClass DOUBLE = new PrimitiveIClass("D");
    public static final IClass FLOAT = new PrimitiveIClass("F");
    public static final IClass INT = new PrimitiveIClass("I");
    public static final IClass LONG = new PrimitiveIClass("J");
    public static final IClass SHORT = new PrimitiveIClass("S");
    public static final IClass BOOLEAN = new PrimitiveIClass("Z");
    private IConstructor[] declaredIConstructors = null;
    protected IMethod[] declaredIMethods = null;
    Map declaredIMethodCache = null;
    private IMethod[] iMethodCache = null;
    public static final IMethod[] NO_IMETHODS = new IMethod[0];
    private Map declaredIFieldsCache = null;
    private IClass[] declaredIClasses = null;
    private boolean declaringIClassIsCached = false;
    private IClass declaringIClass = null;
    private boolean outerIClassIsCached = false;
    private IClass outerIClass = null;
    private boolean superclassIsCached = false;
    private IClass superclass = null;
    private IClass[] interfaces = null;
    private String descriptor = null;
    private boolean componentTypeIsCached = false;
    private IClass componentType = null;
    private static final Set PRIMITIVE_WIDENING_CONVERSIONS = new HashSet();
    private IClass arrayIClass = null;
    private final Map memberTypeCache = new HashMap();
    private static final IClass[] ZERO_ICLASSES;

    public final IConstructor[] getDeclaredIConstructors() {
        if (this.declaredIConstructors == null) {
            this.declaredIConstructors = this.getDeclaredIConstructors2();
        }
        return this.declaredIConstructors;
    }

    protected abstract IConstructor[] getDeclaredIConstructors2();

    public final IMethod[] getDeclaredIMethods() {
        if (this.declaredIMethods == null) {
            this.declaredIMethods = this.getDeclaredIMethods2();
        }
        return this.declaredIMethods;
    }

    protected abstract IMethod[] getDeclaredIMethods2();

    public final IMethod[] getDeclaredIMethods(String methodName) {
        IMethod[] methods;
        if (this.declaredIMethodCache == null) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            IMethod[] dims = this.getDeclaredIMethods();
            for (int i = 0; i < dims.length; ++i) {
                IMethod dim = dims[i];
                String mn = dim.getName();
                Object o = m.get(mn);
                if (o == null) {
                    m.put(mn, dim);
                    continue;
                }
                if (o instanceof IMethod) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(o);
                    l.add(dim);
                    m.put(mn, l);
                    continue;
                }
                ((List)o).add(dim);
            }
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object v = me.getValue();
                if (v instanceof IMethod) {
                    me.setValue(new IMethod[]{(IMethod)v});
                    continue;
                }
                List l = (List)v;
                me.setValue(l.toArray(new IMethod[l.size()]));
            }
            this.declaredIMethodCache = m;
        }
        return (methods = (IMethod[])this.declaredIMethodCache.get(methodName)) == null ? NO_IMETHODS : methods;
    }

    public final IMethod[] getIMethods() throws CompileException {
        if (this.iMethodCache == null) {
            ArrayList iMethods = new ArrayList();
            this.getIMethods(iMethods);
            this.iMethodCache = iMethods.toArray(new IMethod[iMethods.size()]);
        }
        return this.iMethodCache;
    }

    private void getIMethods(List result) throws CompileException {
        IMethod[] ms = this.getDeclaredIMethods();
        for (int i = 0; i < ms.length; ++i) {
            IMethod candidate = ms[i];
            String candidateDescriptor = candidate.getDescriptor();
            String candidateName = candidate.getName();
            boolean found = false;
            for (int j = 0; j < result.size(); ++j) {
                IMethod oldMethod = (IMethod)result.get(j);
                if (!candidateName.equals(oldMethod.getName()) || !candidateDescriptor.equals(oldMethod.getDescriptor())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(candidate);
        }
        IClass sc = this.getSuperclass();
        if (sc != null) {
            sc.getIMethods(result);
        }
        IClass[] iis = this.getInterfaces();
        for (int i = 0; i < iis.length; ++i) {
            iis[i].getIMethods(result);
        }
    }

    public final boolean hasIMethod(String methodName, IClass[] parameterTypes) throws CompileException {
        return this.findIMethod(methodName, parameterTypes) != null;
    }

    public final IMethod findIMethod(String methodName, IClass[] parameterTypes) throws CompileException {
        IMethod[] ims = this.getDeclaredIMethods(methodName);
        for (int i = 0; i < ims.length; ++i) {
            Object[] pts = ims[i].getParameterTypes();
            if (!Arrays.equals(pts, parameterTypes)) continue;
            return ims[i];
        }
        return null;
    }

    public final IField[] getDeclaredIFields() {
        Collection allFields = this.getDeclaredIFieldsCache().values();
        return allFields.toArray(new IField[allFields.size()]);
    }

    private Map getDeclaredIFieldsCache() {
        if (this.declaredIFieldsCache == null) {
            IField[] fields = this.getDeclaredIFields2();
            HashMap<String, IField> m = new HashMap<String, IField>();
            for (int i = 0; i < fields.length; ++i) {
                m.put(fields[i].getName(), fields[i]);
            }
            this.declaredIFieldsCache = m;
        }
        return this.declaredIFieldsCache;
    }

    public final IField getDeclaredIField(String name) {
        return (IField)this.getDeclaredIFieldsCache().get(name);
    }

    protected void clearIFieldCaches() {
        this.declaredIFieldsCache = null;
    }

    protected abstract IField[] getDeclaredIFields2();

    public IField[] getSyntheticIFields() {
        return new IField[0];
    }

    public final IClass[] getDeclaredIClasses() throws CompileException {
        if (this.declaredIClasses == null) {
            this.declaredIClasses = this.getDeclaredIClasses2();
        }
        return this.declaredIClasses;
    }

    protected abstract IClass[] getDeclaredIClasses2() throws CompileException;

    public final IClass getDeclaringIClass() throws CompileException {
        if (!this.declaringIClassIsCached) {
            this.declaringIClass = this.getDeclaringIClass2();
            this.declaringIClassIsCached = true;
        }
        return this.declaringIClass;
    }

    protected abstract IClass getDeclaringIClass2() throws CompileException;

    public final IClass getOuterIClass() throws CompileException {
        if (!this.outerIClassIsCached) {
            this.outerIClass = this.getOuterIClass2();
            this.outerIClassIsCached = true;
        }
        return this.outerIClass;
    }

    protected abstract IClass getOuterIClass2() throws CompileException;

    public final IClass getSuperclass() throws CompileException {
        if (!this.superclassIsCached) {
            this.superclass = this.getSuperclass2();
            this.superclassIsCached = true;
            if (this.superclass != null && this.superclass.isSubclassOf(this)) {
                throw new CompileException("Class circularity detected for \"" + Descriptor.toClassName(this.getDescriptor()) + "\"", null);
            }
        }
        return this.superclass;
    }

    protected abstract IClass getSuperclass2() throws CompileException;

    public abstract Access getAccess();

    public abstract boolean isFinal();

    public final IClass[] getInterfaces() throws CompileException {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces2();
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaces[i].implementsInterface(this)) continue;
                throw new CompileException("Interface circularity detected for \"" + Descriptor.toClassName(this.getDescriptor()) + "\"", null);
            }
        }
        return this.interfaces;
    }

    protected abstract IClass[] getInterfaces2() throws CompileException;

    public abstract boolean isAbstract();

    public final String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.getDescriptor2();
        }
        return this.descriptor;
    }

    protected abstract String getDescriptor2();

    public static String[] getDescriptors(IClass[] iClasses) {
        String[] descriptors = new String[iClasses.length];
        for (int i = 0; i < iClasses.length; ++i) {
            descriptors[i] = iClasses[i].getDescriptor();
        }
        return descriptors;
    }

    public abstract boolean isInterface();

    public abstract boolean isArray();

    public abstract boolean isPrimitive();

    public abstract boolean isPrimitiveNumeric();

    public final IClass getComponentType() {
        if (!this.componentTypeIsCached) {
            this.componentType = this.getComponentType2();
            this.componentTypeIsCached = true;
        }
        return this.componentType;
    }

    protected abstract IClass getComponentType2();

    public String toString() {
        return Descriptor.toClassName(this.getDescriptor());
    }

    public boolean isAssignableFrom(IClass that) throws CompileException {
        if (this == that) {
            return true;
        }
        String ds = that.getDescriptor() + this.getDescriptor();
        if (ds.length() == 2 && PRIMITIVE_WIDENING_CONVERSIONS.contains(ds)) {
            return true;
        }
        if (that.isSubclassOf(this)) {
            return true;
        }
        if (that.implementsInterface(this)) {
            return true;
        }
        if (that == VOID && !this.isPrimitive()) {
            return true;
        }
        if (that.isInterface() && this.getDescriptor().equals("Ljava/lang/Object;")) {
            return true;
        }
        if (that.isArray()) {
            if (this.getDescriptor().equals("Ljava/lang/Object;")) {
                return true;
            }
            if (this.getDescriptor().equals("Ljava/lang/Cloneable;")) {
                return true;
            }
            if (this.getDescriptor().equals("Ljava/io/Serializable;")) {
                return true;
            }
            if (this.isArray()) {
                IClass thisCT = this.getComponentType();
                IClass thatCT = that.getComponentType();
                if (!thisCT.isPrimitive() && thisCT.isAssignableFrom(thatCT)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSubclassOf(IClass that) throws CompileException {
        for (IClass sc = this.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            if (sc != that) continue;
            return true;
        }
        return false;
    }

    public boolean implementsInterface(IClass that) throws CompileException {
        for (IClass c = this; c != null; c = c.getSuperclass()) {
            IClass[] tis = c.getInterfaces();
            for (int i = 0; i < tis.length; ++i) {
                IClass ti = tis[i];
                if (ti != that && !ti.implementsInterface(that)) continue;
                return true;
            }
        }
        return false;
    }

    public IClass getArrayIClass(int n, IClass objectType) {
        IClass result = this;
        for (int i = 0; i < n; ++i) {
            result = result.getArrayIClass(objectType);
        }
        return result;
    }

    public synchronized IClass getArrayIClass(IClass objectType) {
        if (this.arrayIClass == null) {
            this.arrayIClass = this.getArrayIClass2(objectType);
        }
        return this.arrayIClass;
    }

    private IClass getArrayIClass2(final IClass objectType) {
        final IClass componentType = this;
        return new IClass(){

            public IConstructor[] getDeclaredIConstructors2() {
                return new IConstructor[0];
            }

            public IMethod[] getDeclaredIMethods2() {
                return new IMethod[]{new IMethod(){

                    public String getName() {
                        return "clone";
                    }

                    public IClass getReturnType() {
                        return objectType;
                    }

                    public boolean isAbstract() {
                        return false;
                    }

                    public boolean isStatic() {
                        return false;
                    }

                    public Access getAccess() {
                        return Access.PUBLIC;
                    }

                    public IClass[] getParameterTypes() {
                        return new IClass[0];
                    }

                    public IClass[] getThrownExceptions() {
                        return new IClass[0];
                    }
                }};
            }

            public IField[] getDeclaredIFields2() {
                return new IField[0];
            }

            public IClass[] getDeclaredIClasses2() {
                return new IClass[0];
            }

            public IClass getDeclaringIClass2() {
                return null;
            }

            public IClass getOuterIClass2() {
                return null;
            }

            public IClass getSuperclass2() {
                return objectType;
            }

            public IClass[] getInterfaces2() {
                return new IClass[0];
            }

            public String getDescriptor2() {
                return '[' + componentType.getDescriptor();
            }

            public Access getAccess() {
                return componentType.getAccess();
            }

            public boolean isFinal() {
                return true;
            }

            public boolean isInterface() {
                return false;
            }

            public boolean isAbstract() {
                return false;
            }

            public boolean isArray() {
                return true;
            }

            public boolean isPrimitive() {
                return false;
            }

            public boolean isPrimitiveNumeric() {
                return false;
            }

            public IClass getComponentType2() {
                return componentType;
            }

            public String toString() {
                return componentType.toString() + "[]";
            }
        };
    }

    IClass[] findMemberType(String optionalName) throws CompileException {
        IClass[] res = (IClass[])this.memberTypeCache.get(optionalName);
        if (res == null) {
            HashSet s = new HashSet();
            this.findMemberType(optionalName, s);
            res = s.isEmpty() ? ZERO_ICLASSES : s.toArray(new IClass[s.size()]);
            this.memberTypeCache.put(optionalName, res);
        }
        return res;
    }

    private void findMemberType(String optionalName, Collection result) throws CompileException {
        int i;
        IClass[] memberTypes = this.getDeclaredIClasses();
        if (optionalName == null) {
            result.addAll(Arrays.asList(memberTypes));
        } else {
            String memberDescriptor = Descriptor.fromClassName(Descriptor.toClassName(this.getDescriptor()) + '$' + optionalName);
            for (i = 0; i < memberTypes.length; ++i) {
                IClass mt = memberTypes[i];
                if (!mt.getDescriptor().equals(memberDescriptor)) continue;
                result.add(mt);
                return;
            }
        }
        IClass superclass = this.getSuperclass();
        if (superclass != null) {
            superclass.findMemberType(optionalName, result);
        }
        IClass[] ifs = this.getInterfaces();
        for (i = 0; i < ifs.length; ++i) {
            ifs[i].findMemberType(optionalName, result);
        }
        IClass declaringIClass = this.getDeclaringIClass();
        IClass outerIClass = this.getOuterIClass();
        if (declaringIClass != null) {
            declaringIClass.findMemberType(optionalName, result);
        }
        if (outerIClass != null && outerIClass != declaringIClass) {
            outerIClass.findMemberType(optionalName, result);
        }
    }

    static {
        String[] pwcs = new String[]{"BS", "BI", "SI", "CI", "BJ", "SJ", "CJ", "IJ", "BF", "SF", "CF", "IF", "JF", "BD", "SD", "CD", "ID", "JD", "FD"};
        for (int i = 0; i < pwcs.length; ++i) {
            PRIMITIVE_WIDENING_CONVERSIONS.add(pwcs[i]);
        }
        ZERO_ICLASSES = new IClass[0];
    }

    public abstract class IField
    implements IMember {
        public abstract Access getAccess();

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public abstract boolean isStatic();

        public abstract IClass getType() throws CompileException;

        public abstract String getName();

        public String getDescriptor() throws CompileException {
            return this.getType().getDescriptor();
        }

        public abstract Object getConstantValue() throws CompileException;

        public String toString() {
            return this.getDeclaringIClass().toString() + "." + this.getName();
        }
    }

    public abstract class IMethod
    extends IInvocable {
        public abstract boolean isStatic();

        public abstract boolean isAbstract();

        public abstract IClass getReturnType() throws CompileException;

        public abstract String getName();

        public String getDescriptor() throws CompileException {
            return new MethodDescriptor(IClass.getDescriptors(this.getParameterTypes()), this.getReturnType().getDescriptor()).toString();
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getAccess().toString()).append(' ');
            if (this.isStatic()) {
                sb.append("static ");
            }
            if (this.isAbstract()) {
                sb.append("abstract ");
            }
            try {
                sb.append(this.getReturnType().toString());
            }
            catch (CompileException ex) {
                sb.append("<invalid type>");
            }
            sb.append(' ');
            sb.append(this.getDeclaringIClass().toString());
            sb.append('.');
            sb.append(this.getName());
            sb.append('(');
            try {
                IClass[] parameterTypes = this.getParameterTypes();
                for (i = 0; i < parameterTypes.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(parameterTypes[i].toString());
                }
            }
            catch (CompileException ex) {
                sb.append("<invalid type>");
            }
            sb.append(')');
            try {
                IClass[] tes = this.getThrownExceptions();
                if (tes.length > 0) {
                    sb.append(" throws ").append(tes[0]);
                    for (i = 1; i < tes.length; ++i) {
                        sb.append(", ").append(tes[i]);
                    }
                }
            }
            catch (CompileException ex) {
                sb.append("<invalid thrown exception type>");
            }
            return sb.toString();
        }
    }

    public abstract class IConstructor
    extends IInvocable {
        public abstract IClass[] getParameterTypes() throws CompileException;

        public String getDescriptor() throws CompileException {
            IClass[] parameterTypes = this.getParameterTypes();
            IClass outerIClass = IClass.this.getOuterIClass();
            if (outerIClass != null) {
                IClass[] tmp = new IClass[parameterTypes.length + 1];
                tmp[0] = outerIClass;
                System.arraycopy(parameterTypes, 0, tmp, 1, parameterTypes.length);
                parameterTypes = tmp;
            }
            return new MethodDescriptor(IClass.getDescriptors(parameterTypes), "V").toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.getDeclaringIClass().toString());
            sb.append('(');
            try {
                IClass[] parameterTypes = this.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(parameterTypes[i].toString());
                }
            }
            catch (CompileException ex) {
                sb.append("<invalid type>");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public abstract class IInvocable
    implements IMember {
        public abstract Access getAccess();

        public IClass getDeclaringIClass() {
            return IClass.this;
        }

        public abstract IClass[] getParameterTypes() throws CompileException;

        public abstract String getDescriptor() throws CompileException;

        public abstract IClass[] getThrownExceptions() throws CompileException;

        public boolean isMoreSpecificThan(IInvocable that) throws CompileException {
            Object[] thisParameterTypes = this.getParameterTypes();
            Object[] thatParameterTypes = that.getParameterTypes();
            for (int i = 0; i < thisParameterTypes.length; ++i) {
                if (thatParameterTypes[i].isAssignableFrom((IClass)thisParameterTypes[i])) continue;
                return false;
            }
            return !Arrays.equals(thisParameterTypes, thatParameterTypes);
        }

        public boolean isLessSpecificThan(IInvocable that) throws CompileException {
            return that.isMoreSpecificThan(this);
        }

        public abstract String toString();
    }

    public static interface IMember {
        public Access getAccess();

        public IClass getDeclaringIClass();
    }

    private static class PrimitiveIClass
    extends IClass {
        private final String fieldDescriptor;

        public PrimitiveIClass(String fieldDescriptor) {
            this.fieldDescriptor = fieldDescriptor;
        }

        protected IClass getComponentType2() {
            return null;
        }

        protected IClass[] getDeclaredIClasses2() {
            return new IClass[0];
        }

        protected IConstructor[] getDeclaredIConstructors2() {
            return new IConstructor[0];
        }

        protected IField[] getDeclaredIFields2() {
            return new IField[0];
        }

        protected IMethod[] getDeclaredIMethods2() {
            return new IMethod[0];
        }

        protected IClass getDeclaringIClass2() {
            return null;
        }

        protected String getDescriptor2() {
            return this.fieldDescriptor;
        }

        protected IClass[] getInterfaces2() {
            return new IClass[0];
        }

        protected IClass getOuterIClass2() {
            return null;
        }

        protected IClass getSuperclass2() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public boolean isFinal() {
            return true;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isPrimitive() {
            return true;
        }

        public boolean isPrimitiveNumeric() {
            return Descriptor.isPrimitiveNumeric(this.fieldDescriptor);
        }

        public Access getAccess() {
            return Access.PUBLIC;
        }
    }
}

