/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public abstract class AbstractMetadataItemListener<S, D>
extends Listener<S, D> {
    private static final Log LOG = ExoLogger.getLogger(AbstractMetadataItemListener.class);
    private CachedActivityStorage cachedActivityStorage;
    private CachedSpaceStorage cachedSpaceStorage;
    private MetadataService metadataService;
    private IndexingService indexingService;

    protected AbstractMetadataItemListener(MetadataService metadataService, ActivityStorage activityStorage, SpaceStorage spaceStorage, IndexingService indexingService) {
        this.indexingService = indexingService;
        this.metadataService = metadataService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
        if (spaceStorage instanceof CachedSpaceStorage) {
            this.cachedSpaceStorage = (CachedSpaceStorage)spaceStorage;
        }
    }

    protected void handleMetadataModification(MetadataItem metadataItem) {
        if (metadataItem != null) {
            String objectType = metadataItem.getObjectType();
            String objectId = metadataItem.getObjectId();
            if (this.cachedActivityStorage != null) {
                Space space;
                if (this.isActivityEvent(objectType)) {
                    ExoSocialActivity activity = this.cachedActivityStorage.getActivity(objectId);
                    if (activity != null && activity.hasSpecificMetadataObject()) {
                        MetadataObject metadataObject = activity.getMetadataObject();
                        this.moveMetadataItemToTargetObject(metadataItem, metadataObject);
                    }
                } else if (metadataItem.getSpaceId() >= 0L && this.cachedSpaceStorage != null && (space = this.cachedSpaceStorage.getSpaceById(String.valueOf(metadataItem.getSpaceId()))) != null) {
                    this.cachedActivityStorage.clearOwnerStreamCache(space.getPrettyName());
                }
            }
            this.handleMetadataModification(objectType, metadataItem.getObjectId());
        }
    }

    protected void handleMetadataModification(String objectType, String objectId) {
        if (this.isActivityEvent(objectType)) {
            this.clearActivityCache(objectId);
            this.reindexActivity(objectId);
        } else if (this.isSpaceEvent(objectType)) {
            this.clearSpaceCache(objectId);
            this.reindexSpace(objectId);
        }
    }

    protected boolean isActivityEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"activity");
    }

    protected boolean isSpaceEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"space");
    }

    private void moveMetadataItemToTargetObject(MetadataItem metadataItem, MetadataObject targetMetadataObject) {
        try {
            this.metadataService.deleteMetadataItem(metadataItem.getId(), false);
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to delete newly created item", (Throwable)e);
        }
        MetadataKey metadataKey = metadataItem.getMetadata().key();
        Map properties = metadataItem.getProperties();
        try {
            long creatorId = metadataItem.getCreatorId();
            this.metadataService.createMetadataItem(targetMetadataObject, metadataKey, properties, creatorId);
        }
        catch (Exception e) {
            LOG.warn("Unable to move Metadata item from {} to {}", new Object[]{metadataItem.getObject(), targetMetadataObject, e});
        }
    }

    private void reindexActivity(String activityId) {
        this.indexingService.reindex("activity", activityId);
    }

    private void clearActivityCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }

    private void reindexSpace(String spaceId) {
        this.indexingService.reindex("space", spaceId);
    }

    private void clearSpaceCache(String spaceId) {
        if (this.cachedSpaceStorage != null) {
            this.cachedSpaceStorage.clearSpaceCached(spaceId);
        }
    }
}

