/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.User;
import org.exoplatform.task.rest.model.TaskEntity;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.DateUtil;
import org.exoplatform.task.util.ResourceUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.UserUtil;
import org.exoplatform.web.controller.router.Router;

public final class TaskUtil {
    public static final String URL_TASK_DETAIL = "/taskDetail/";
    private static final Log LOG = ExoLogger.getExoLogger((String)TaskUtil.class.getName());
    public static final String TITLE = "title";
    public static final String PRIORITY = "priority";
    public static final String DUEDATE = "dueDate";
    public static final String CREATED_TIME = "createdTime";
    public static final String NONE = "none";
    public static final String STATUS = "status";
    public static final String ASSIGNEE = "assignee";
    public static final String PROJECT = "project";
    public static final String LABEL = "label";
    public static final String COMPLETED = "completed";
    public static final String RANK = "rank";
    public static final String MEMBERSHIP = "membership";
    public static final String CREATED_BY = "createdBy";
    public static final String COWORKER = "coworker";
    public static final String TASK_OBJECT_TYPE = "task";
    public static final ListAccess<Task> EMPTY_TASK_LIST = new ListAccess<Task>(){

        public Task[] load(int index, int length) throws Exception, IllegalArgumentException {
            return new Task[0];
        }

        public int getSize() throws Exception {
            return 0;
        }
    };

    private TaskUtil() {
    }

    public static Map<String, String> getDefOrders(ResourceBundle bundle) {
        return TaskUtil.resolve(Arrays.asList(TITLE, PRIORITY, DUEDATE, CREATED_TIME), bundle);
    }

    public static Map<String, String> getDefGroupBys(long currentProject, ResourceBundle bundle) {
        if (currentProject == -1L) {
            return TaskUtil.resolve(Arrays.asList(NONE, ASSIGNEE, LABEL, DUEDATE), bundle);
        }
        return TaskUtil.resolve(Arrays.asList(NONE, ASSIGNEE, LABEL, DUEDATE, STATUS), bundle);
    }

    public static Map<String, String> resolve(List<String> keys, ResourceBundle bundle) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        for (String k : keys) {
            String label;
            if (k.isEmpty()) {
                k = NONE;
            }
            try {
                label = bundle.getString("label." + k);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while resolving label 'label." + k + "' with locale " + bundle.getLocale()), (Throwable)e);
                label = k;
            }
            labels.put(k, label);
        }
        return labels;
    }

    public static TaskQuery buildTaskQuery(TaskQuery query, String keyword, List<Long> searchLabelIds, Status status, DUE dueDate, Priority priority, List<String> searchAssignee, Boolean showCompleted, TimeZone timezone) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            query.setKeyword(keyword);
        }
        if (searchLabelIds != null && !searchLabelIds.isEmpty()) {
            query.setLabelIds(searchLabelIds);
        }
        if (status != null) {
            query.setStatus(status);
        }
        if (dueDate != null) {
            Date[] due = TaskUtil.convertDueDate(dueDate.name(), timezone);
            query.setDueDateFrom(due[0]);
            query.setDueDateTo(due[1]);
        }
        if (priority != null) {
            query.setPriority(priority);
        }
        if (searchAssignee != null && !searchAssignee.isEmpty()) {
            query.setAssignee(searchAssignee);
        }
        if (showCompleted != null && !showCompleted.booleanValue()) {
            query.setCompleted(showCompleted);
        }
        return query;
    }

    public static TaskQuery buildTaskQuery(TaskQuery query, String keyword, List<Long> searchLabelIds, Status status, DUE dueDate, Priority priority, List<String> searchAssignee, List<String> searchCoworker, List<String> searchWatcher, Boolean showCompleted, TimeZone timezone) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            query.setKeyword(keyword);
        }
        if (searchLabelIds != null && !searchLabelIds.isEmpty()) {
            query.setLabelIds(searchLabelIds);
        }
        if (status != null) {
            query.setStatus(status);
        }
        if (dueDate != null) {
            Date[] due = TaskUtil.convertDueDate(dueDate.name(), timezone);
            query.setDueDateFrom(due[0]);
            query.setDueDateTo(due[1]);
        }
        if (priority != null) {
            query.setPriority(priority);
        }
        if (searchAssignee != null && !searchAssignee.isEmpty()) {
            query.setAssignee(searchAssignee);
        }
        if (searchCoworker != null && !searchCoworker.isEmpty()) {
            query.setCoworker(searchCoworker);
        }
        if (searchWatcher != null && !searchWatcher.isEmpty()) {
            query.setWatchers(searchWatcher);
        }
        if (showCompleted != null && !showCompleted.booleanValue()) {
            query.setCompleted(showCompleted);
        }
        return query;
    }

    public static TaskQuery buildTaskQuery(TaskQuery query, String keyword, List<Long> searchLabelIds, StatusDto status, DUE dueDate, Priority priority, List<String> searchAssignee, Boolean showCompleted, TimeZone timezone) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            query.setKeyword(keyword);
        }
        if (searchLabelIds != null && !searchLabelIds.isEmpty()) {
            query.setLabelIds(searchLabelIds);
        }
        if (status != null) {
            query.setStatus(status);
        }
        if (dueDate != null) {
            Date[] due = TaskUtil.convertDueDate(dueDate.name(), timezone);
            query.setDueDateFrom(due[0]);
            query.setDueDateTo(due[1]);
        }
        if (priority != null) {
            query.setPriority(priority);
        }
        if (searchAssignee != null && !searchAssignee.isEmpty()) {
            query.setAssignee(searchAssignee);
        }
        if (showCompleted != null && !showCompleted.booleanValue()) {
            query.setCompleted(showCompleted);
        }
        return query;
    }

    public static Date[] convertDueDate(String dueDate, TimeZone timezone) {
        Date[] due = new Date[]{null, null};
        if (dueDate != null && !dueDate.isEmpty()) {
            Calendar today = Calendar.getInstance(timezone);
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            switch (DUE.valueOf(dueDate.toUpperCase())) {
                case OVERDUE: {
                    today.add(5, 0);
                    due[1] = today.getTime();
                    break;
                }
                case TODAY: {
                    due[0] = today.getTime();
                    today.add(5, 1);
                    due[1] = new Date(today.getTimeInMillis() - 1L);
                    break;
                }
                case TOMORROW: {
                    today.add(5, 1);
                    due[0] = today.getTime();
                    today.add(5, 1);
                    due[1] = new Date(today.getTimeInMillis() - 1L);
                    break;
                }
                case UPCOMING: {
                    today.add(5, 2);
                    due[0] = today.getTime();
                }
            }
        }
        return due;
    }

    public static Map<GroupKey, List<TaskEntity>> groupTasks(List<TaskEntity> tasks, String groupBy, Identity userId, TimeZone userTimezone, LabelService labelService, UserService userService) throws EntityNotFoundException {
        TreeMap<GroupKey, LinkedList<TaskEntity>> maps = new TreeMap<GroupKey, LinkedList<TaskEntity>>();
        for (TaskEntity task : tasks) {
            for (GroupKey key : TaskUtil.getGroupName(task, groupBy, userId, userTimezone, labelService, userService)) {
                LinkedList<TaskEntity> list = maps.entrySet().stream().filter(group -> ((GroupKey)group.getKey()).getName().equals(key.getName())).map(Map.Entry::getValue).findFirst().orElse(null);
                if (list == null) {
                    list = new LinkedList<TaskEntity>();
                    maps.put(key, list);
                }
                list.add(task);
            }
        }
        Comparator<GroupKey> byKey = Comparator.comparing(GroupKey::getName);
        return maps.entrySet().stream().sorted(Map.Entry.comparingByKey(byKey)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static String buildTaskURL(TaskDto task, SiteKey siteKey, ExoContainer container, Router router) {
        if (task == null) {
            return "#";
        }
        StringBuilder urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL(siteKey, container, router));
        if (urlBuilder.length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append(URL_TASK_DETAIL).append(task.getId()).toString();
    }

    private static GroupKey[] getGroupName(TaskEntity task, String groupBy, Identity userId, TimeZone userTimezone, LabelService labelService, UserService userService) throws EntityNotFoundException {
        if (PROJECT.equalsIgnoreCase(groupBy)) {
            StatusDto s = task.getStatus();
            if (s == null) {
                return new GroupKey[]{new GroupKey("No project", null, Integer.MAX_VALUE)};
            }
            return new GroupKey[]{new GroupKey(s.getProject().getName(), s.getProject(), (int)s.getProject().getId())};
        }
        if (STATUS.equalsIgnoreCase(groupBy)) {
            StatusDto s = task.getStatus();
            if (s == null) {
                return new GroupKey[]{new GroupKey("To do", null, Integer.MIN_VALUE)};
            }
        } else {
            if (ASSIGNEE.equalsIgnoreCase(groupBy)) {
                GroupKey[] groupKeyArray;
                User user = null;
                user = task.getAssignee() != null ? task.getAssignee() : userService.loadUser(null);
                if (user.getUsername() != "guest" && user.getUsername() != null) {
                    GroupKey[] groupKeyArray2 = new GroupKey[1];
                    groupKeyArray = groupKeyArray2;
                    groupKeyArray2[0] = new GroupKey(user.getUsername(), user, user.getUsername().hashCode());
                } else {
                    GroupKey[] groupKeyArray3 = new GroupKey[1];
                    groupKeyArray = groupKeyArray3;
                    groupKeyArray3[0] = new GroupKey("Unassigned", null, Integer.MAX_VALUE);
                }
                return groupKeyArray;
            }
            if (DUEDATE.equalsIgnoreCase(groupBy)) {
                Date dueDate = task.getDueDate();
                Calendar calendar = null;
                if (dueDate != null) {
                    calendar = Calendar.getInstance(userTimezone);
                    calendar.setTime(dueDate);
                    if (DateUtil.isOverdue(calendar)) {
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        calendar.add(5, -1);
                    } else if (!DateUtil.isToday(calendar) && !DateUtil.isTomorrow(calendar)) {
                        calendar.setTimeInMillis(System.currentTimeMillis());
                        calendar.add(5, 7);
                    }
                    calendar.set(10, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    dueDate = calendar.getTime();
                }
                return new GroupKey[]{new GroupKey(DateUtil.getDueDateLabel(calendar), dueDate, calendar == null ? Integer.MAX_VALUE : (int)calendar.getTimeInMillis())};
            }
            if (LABEL.equalsIgnoreCase(groupBy) && task.getStatus() != null && task.getStatus().getProject() != null) {
                List<LabelDto> labels = labelService.findLabelsByTask(task.getTask(), task.getStatus().getProject().getId(), userId, 0, -1);
                if (labels.isEmpty()) {
                    return new GroupKey[]{new GroupKey("No Label", null, Integer.MAX_VALUE)};
                }
                GroupKey[] keys = new GroupKey[labels.size()];
                for (int i = 0; i < keys.length; ++i) {
                    LabelDto label = labels.get(i);
                    keys[i] = new GroupKey(label.getName(), label, (int)label.getId());
                }
                return keys;
            }
            if (COMPLETED.equalsIgnoreCase(groupBy)) {
                if (!task.isCompleted()) {
                    return new GroupKey[]{new GroupKey("Uncompleted", null, Integer.MAX_VALUE)};
                }
                return new GroupKey[]{new GroupKey("Completed", null, Integer.MIN_VALUE)};
            }
        }
        return new GroupKey[0];
    }

    public static boolean canDeleteComment(Identity identity, Comment comment) {
        if (comment == null || identity == null) {
            return false;
        }
        if (identity.getUserId().equals(comment.getAuthor())) {
            return true;
        }
        Task task = comment.getTask();
        if (task.getStatus() != null) {
            Project pj = task.getStatus().getProject();
            return pj.canEdit(identity);
        }
        return false;
    }

    public static boolean canDeleteComment(Identity identity, CommentDto comment) {
        if (comment == null || identity == null) {
            return false;
        }
        if (identity.getUserId().equals(comment.getAuthor())) {
            return true;
        }
        TaskDto task = comment.getTask();
        if (task.getStatus() != null) {
            ProjectDto pj = task.getStatus().getProject();
            return pj.canEdit(identity);
        }
        return false;
    }

    public static TaskDto saveTaskField(TaskDto task, Identity userId, String param, String[] values, TimeZone timezone, TaskService taskService, LabelService labelService, StatusService statusService) throws EntityNotFoundException, ParameterEntityException {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        task.setCoworker(TaskUtil.getCoworker(taskService, task.getId()));
        task.setWatcher(TaskUtil.getWatcher(taskService, task));
        if ("workPlan".equalsIgnoreCase(param)) {
            if (values == null) {
                task.setStartDate(null);
                task.setEndDate(null);
            } else {
                if (values.length != 2) {
                    LOG.error((Object)"workPlan updating lack of params");
                }
                try {
                    SimpleDateFormat wpf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    wpf.setTimeZone(timezone);
                    Date startDate = wpf.parse(values[0]);
                    Date endDate = wpf.parse(values[1]);
                    task.setStartDate(startDate);
                    task.setEndDate(endDate);
                }
                catch (ParseException ex) {
                    LOG.info((Object)("Can parse date time value: " + values[0] + " or " + values[1] + " for Task with ID: " + task.getId()));
                    throw new ParameterEntityException(task.getId(), Task.class, param, values[0] + " or " + values[1], "cannot be parse to date", ex);
                }
            }
        } else {
            String value;
            String string = value = values != null && values.length > 0 ? values[0] : null;
            if (TITLE.equalsIgnoreCase(param)) {
                task.setTitle(value);
            } else if (DUEDATE.equalsIgnoreCase(param)) {
                if (value == null || value.trim().isEmpty()) {
                    task.setDueDate(null);
                } else {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    df.setTimeZone(timezone);
                    try {
                        Date date = df.parse(value);
                        task.setDueDate(date);
                    }
                    catch (ParseException ex) {
                        LOG.info((Object)("Can parse date time value: " + value + " for Task with ID: " + task.getId()));
                        throw new ParameterEntityException(task.getId(), Task.class, param, value, "cannot be parse to date", ex);
                    }
                }
            } else if (STATUS.equalsIgnoreCase(param)) {
                try {
                    Long statusId = Long.parseLong(value.toUpperCase());
                    StatusDto status = statusService.getStatus(statusId);
                    if (status == null) {
                        LOG.info((Object)("Status does not exist with ID: " + value));
                        throw new EntityNotFoundException(task.getId(), (Class<?>)Status.class);
                    }
                    task.setStatus(status);
                }
                catch (NumberFormatException ex) {
                    LOG.info((Object)("Status is unacceptable: " + value + " for Task with ID: " + task.getId()));
                    throw new ParameterEntityException(task.getId(), Task.class, param, value, "is unacceptable", ex);
                }
            } else if ("description".equalsIgnoreCase(param)) {
                value = StringUtil.encodeInjectedHtmlTag(value);
                task.setDescription(value);
            } else if (COMPLETED.equalsIgnoreCase(param)) {
                task.setCompleted(Boolean.parseBoolean(value));
            } else if (ASSIGNEE.equalsIgnoreCase(param)) {
                task.setAssignee(value);
            } else if (COWORKER.equalsIgnoreCase(param)) {
                HashSet<String> coworker = new HashSet<String>();
                if (values != null) {
                    for (String string2 : values) {
                        if (string2 == null || string2.isEmpty()) continue;
                        coworker.add(string2);
                    }
                }
                task.setCoworker(coworker);
            } else if ("watcher".equalsIgnoreCase(param)) {
                HashSet<String> watcher = new HashSet<String>();
                if (values != null) {
                    for (String string3 : values) {
                        if (string3 == null || string3.isEmpty()) continue;
                        watcher.add(string3);
                    }
                }
                task.setWatcher(watcher);
            } else if (PRIORITY.equalsIgnoreCase(param)) {
                Priority priority = Priority.valueOf(value);
                task.setPriority(priority);
            } else if (PROJECT.equalsIgnoreCase(param)) {
                try {
                    Long projectId = Long.parseLong(value);
                    if (projectId > 0L) {
                        StatusDto st = statusService.getDefaultStatus(projectId);
                        if (st == null) {
                            throw new ParameterEntityException(task.getId(), Task.class, param, value, "Status for project is not found", null);
                        }
                        task.setStatus(st);
                    }
                    task.setStatus(null);
                }
                catch (NumberFormatException ex) {
                    throw new ParameterEntityException(task.getId(), Task.class, param, value, "ProjectID must be long", ex);
                }
            } else if ("labels".equalsIgnoreCase(param)) {
                ArrayList<Long> ids = new ArrayList<Long>(values.length);
                ArrayList<String> labelsToCreate = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    try {
                        if (values[i] == null || values[i].isEmpty()) continue;
                        Long id = Long.parseLong(values[i]);
                        LabelDto labelDto = labelService.getLabel(id);
                        if (labelDto != null) {
                            ids.add(Long.parseLong(values[i]));
                            continue;
                        }
                        labelsToCreate.add(values[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        labelsToCreate.add(values[i]);
                    }
                }
                HashSet<Long> persisted = new HashSet<Long>();
                if (task.getStatus() != null && task.getStatus().getProject() != null) {
                    List<LabelDto> labels = labelService.findLabelsByTask(task, task.getStatus().getProject().getId(), userId, 0, -1);
                    for (LabelDto label : labels) {
                        if (!ids.contains(label.getId())) {
                            labelService.removeTaskFromLabel(task, label.getId());
                            continue;
                        }
                        persisted.add(label.getId());
                    }
                }
                for (String string4 : labelsToCreate) {
                    LabelDto l = new LabelDto();
                    l.setName(string4);
                    l.setUsername(userId.getUserId());
                    l = labelService.createLabel(l);
                    ids.add(l.getId());
                }
                for (Long l : ids) {
                    if (persisted.contains(l)) continue;
                    labelService.addTaskToLabel(task, l);
                }
            } else {
                LOG.info((Object)("Field name: " + param + " is not supported for entity Task"));
                throw new ParameterEntityException(task.getId(), Task.class, param, value, "is not supported for the entity Task", null);
            }
        }
        return taskService.updateTask(task);
    }

    public static boolean hasEditPermission(TaskService taskService, TaskDto task) {
        ProjectDto project;
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        if (task.getAssignee() != null && task.getAssignee().equals(identity.getUserId()) || TaskUtil.getCoworker(taskService, task.getId()).contains(userId) || task.getCreatedBy() != null && task.getCreatedBy().equals(userId)) {
            return true;
        }
        if (task.getStatus() != null && (project = task.getStatus().getProject()).canView(identity)) {
            return true;
        }
        return UserUtil.isPlatformAdmin(identity);
    }

    public static boolean hasEditPermission(TaskService taskService, Task task) {
        Project project;
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        if (task.getAssignee() != null && task.getAssignee().equals(identity.getUserId()) || TaskUtil.getCoworker(taskService, task.getId()).contains(userId) || task.getCreatedBy() != null && task.getCreatedBy().equals(userId)) {
            return true;
        }
        if (task.getStatus() != null && (project = task.getStatus().getProject()).canView(identity)) {
            return true;
        }
        return UserUtil.isPlatformAdmin(identity);
    }

    public static boolean hasViewPermission(TaskService taskService, TaskDto task) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        return TaskUtil.hasMentionedUser(taskService, task, userId) || TaskUtil.hasEditPermission(taskService, task);
    }

    private static boolean hasMentionedUser(TaskService taskService, TaskDto task, String userId) {
        Set<String> mentionedUsers = taskService.getMentionedUsers(task.getId());
        return mentionedUsers.contains(userId);
    }

    public static boolean hasViewOnlyPermission(TaskService taskService, TaskDto task) {
        return TaskUtil.hasViewPermission(taskService, task) && !TaskUtil.hasEditPermission(taskService, task);
    }

    public static boolean hasDeletePermission(TaskDto task) {
        ProjectDto project;
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        if (task.getCreatedBy() != null && task.getCreatedBy().equals(userId)) {
            return true;
        }
        if (task.getStatus() != null && (project = task.getStatus().getProject()).canEdit(identity)) {
            return true;
        }
        return UserUtil.isPlatformAdmin(identity);
    }

    public static String getResourceBundleLabel(Locale locale, String label) {
        ResourceBundleService resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        return resourceBundleService.getResourceBundle(resourceBundleService.getSharedResourceBundleNames(), locale).getString(label);
    }

    public static String getUserLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        String lang = Locale.getDefault().getLanguage();
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.toString();
        }
        return lang;
    }

    public static Set<String> getCoworker(TaskService taskService, long taskId) {
        return taskService.getCoworker(taskId);
    }

    public static Set<String> getWatcher(TaskService taskService, TaskDto task) {
        return taskService.getWatchersOfTask(task);
    }

    public static boolean isEligibleWatcher(Task task, String username) {
        return !task.getCoworker().contains(username) && !username.equals(task.getAssignee()) && !username.equals(task.getCreatedBy());
    }

    public static enum DUE {
        OVERDUE,
        TODAY,
        TOMORROW,
        UPCOMING;

    }
}

