/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiPreferences;
import org.exoplatform.wiki.model.WikiPreferencesSyntax;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.SpaceBean;
import org.exoplatform.wiki.service.listener.AttachmentWikiListener;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;

public class WikiServiceImpl
implements WikiService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageAttachmentCache";
    private static final Log LOG = ExoLogger.getLogger(WikiServiceImpl.class);
    private static final String DEFAULT_SYNTAX = "defaultSyntax";
    private static final String DEFAULT_WIKI_NAME = "wiki";
    private static final Log log = ExoLogger.getLogger(WikiServiceImpl.class);
    private final OrganizationService orgService;
    private final UserACL userACL;
    private final DataStorage dataStorage;
    private PropertiesParam preferencesParams;
    private final List<ComponentPlugin> plugins_ = new ArrayList<ComponentPlugin>();
    private String wikiWebappUri;
    private final ExoCache<Integer, MarkupData> renderingCache;
    private final ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private final Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();

    public WikiServiceImpl(UserACL userACL, DataStorage dataStorage, CacheService cacheService, OrganizationService orgService) {
        this.userACL = userACL;
        this.dataStorage = dataStorage;
        this.orgService = orgService;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        this.wikiWebappUri = System.getProperty("wiki.permalink.appuri");
        if (StringUtils.isEmpty((String)this.wikiWebappUri)) {
            this.wikiWebappUri = DEFAULT_WIKI_NAME;
        }
    }

    public ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public void addComponentPlugin(ComponentPlugin plugin) {
        if (plugin != null) {
            this.plugins_.add(plugin);
        }
    }

    @Override
    public List<PageWikiListener> getPageListeners() {
        ArrayList<PageWikiListener> pageListeners = new ArrayList<PageWikiListener>();
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof PageWikiListener)) continue;
            pageListeners.add((PageWikiListener)c);
        }
        return pageListeners;
    }

    @Override
    public List<AttachmentWikiListener> getAttachmentListeners() {
        ArrayList<AttachmentWikiListener> attachmentListeners = new ArrayList<AttachmentWikiListener>();
        for (ComponentPlugin c : this.plugins_) {
            if (!(c instanceof AttachmentWikiListener)) continue;
            attachmentListeners.add((AttachmentWikiListener)c);
        }
        return attachmentListeners;
    }

    @Override
    public String getWikiWebappUri() {
        return this.wikiWebappUri;
    }

    @Override
    public String getDefaultWikiSyntaxId() {
        if (this.preferencesParams != null) {
            return this.preferencesParams.getProperty(DEFAULT_SYNTAX);
        }
        return "xhtml/1.0";
    }

    @Override
    public Wiki getWikiByTypeAndOwner(String wikiType, String owner) throws WikiException {
        return this.dataStorage.getWikiByTypeAndOwner(wikiType, owner);
    }

    @Override
    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        return this.dataStorage.getWikisByType(wikiType);
    }

    @Override
    public Wiki getOrCreateUserWiki(String username) throws WikiException {
        return this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, username);
    }

    @Override
    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws WikiException {
        return this.dataStorage.getWikiPermission(wikiType, wikiOwner);
    }

    @Override
    public void updateWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws WikiException {
        this.dataStorage.updateWikiPermission(wikiType, wikiOwner, permissionEntries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PermissionEntry> getWikiDefaultPermissions(String wikiType, String wikiOwner) throws WikiException {
        Permission[] allPermissions = new Permission[]{new Permission(PermissionType.ADMINPAGE, true), new Permission(PermissionType.ADMINSPACE, true)};
        ArrayList<PermissionEntry> permissions = new ArrayList<PermissionEntry>();
        if (PortalConfig.PORTAL_TYPE.equals(wikiType)) {
            for (Map.Entry<String, IDType> entry : Utils.getACLForAdmins().entrySet()) {
                PermissionEntry permissionEntry = new PermissionEntry(entry.getKey(), "", entry.getValue(), allPermissions);
                permissions.add(permissionEntry);
            }
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
            try {
                UserPortalConfig userPortalConfig;
                if (userPortalConfigService == null || (userPortalConfig = userPortalConfigService.getUserPortalConfig(wikiOwner, null)) == null) return permissions;
                PortalConfig portalConfig = userPortalConfig.getPortalConfig();
                PermissionEntry portalPermissionEntry = new PermissionEntry(portalConfig.getEditPermission(), "", IDType.MEMBERSHIP, allPermissions);
                permissions.add(portalPermissionEntry);
                return permissions;
            }
            catch (Exception e) {
                throw new WikiException("Cannot get user portal config for wiki " + wikiType + ":" + wikiOwner + " - Cause : " + e.getMessage(), e);
            }
        } else if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
            PermissionEntry groupPermissionEntry = new PermissionEntry(this.userACL.getMakableMT() + ":" + wikiOwner, "", IDType.MEMBERSHIP, allPermissions);
            permissions.add(groupPermissionEntry);
            return permissions;
        } else {
            if (!PortalConfig.USER_TYPE.equals(wikiType)) return permissions;
            PermissionEntry ownerPermissionEntry = new PermissionEntry(wikiOwner, "", IDType.USER, allPermissions);
            permissions.add(ownerPermissionEntry);
        }
        return permissions;
    }

    @Override
    public Wiki getWikiById(String wikiId) throws WikiException {
        Wiki wiki;
        if (wikiId.startsWith("/spaces/")) {
            wiki = this.getWikiByTypeAndOwner(PortalConfig.GROUP_TYPE, wikiId);
        } else if (wikiId.startsWith("/user/")) {
            wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            wiki = this.getWikiByTypeAndOwner(PortalConfig.USER_TYPE, wikiId);
        } else {
            if (wikiId.startsWith("/")) {
                wikiId = wikiId.substring(wikiId.lastIndexOf(47) + 1);
            }
            wiki = this.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, wikiId);
        }
        return wiki;
    }

    @Override
    public String getWikiNameById(String wikiId) throws WikiException {
        Wiki wiki = this.getWikiById(wikiId);
        if (WikiType.PORTAL.equals(wiki.getType())) {
            String displayName = wiki.getId();
            int slashIndex = displayName.lastIndexOf(47);
            if (slashIndex > -1) {
                displayName = displayName.substring(slashIndex + 1);
            }
            return displayName;
        }
        if (WikiType.USER.equals(wiki.getType())) {
            String currentUser = Utils.getCurrentUser();
            if (wiki.getOwner().equals(currentUser)) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                return res.getString("UISpaceSwitcher.title.my-space");
            }
            return wiki.getOwner();
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        return wikiService.getSpaceNameByGroupId(wiki.getOwner());
    }

    @Override
    public Wiki createWiki(String wikiType, String owner) throws WikiException {
        Wiki wiki = this.getWikiByTypeAndOwner(wikiType, owner);
        if (wiki != null) {
            throw new WikiException("Wiki with type '" + wikiType + "' and owner = '" + owner + "' already exists");
        }
        wiki = new Wiki(wikiType, owner);
        wiki.setPermissions(this.getWikiDefaultPermissions(wikiType, owner));
        WikiPreferences wikiPreferences = new WikiPreferences();
        WikiPreferencesSyntax wikiPreferencesSyntax = new WikiPreferencesSyntax();
        wikiPreferencesSyntax.setDefaultSyntax(this.getDefaultWikiSyntaxId());
        wikiPreferences.setWikiPreferencesSyntax(wikiPreferencesSyntax);
        wiki.setPreferences(wikiPreferences);
        Wiki createdWiki = this.dataStorage.createWiki(wiki);
        StringBuilder sb = new StringBuilder("<h1> Welcome to ");
        String wikiLabel = owner;
        if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
            sb.append("Space ");
            wikiLabel = this.getSpaceNameByGroupId(owner);
        } else if (wikiType.equals(PortalConfig.USER_TYPE)) {
            wikiLabel = this.getUserDisplayName(wiki.getOwner());
        }
        sb.append(wikiLabel).append(" Notes Home </h1>");
        createdWiki.getWikiHome().setContent(sb.toString());
        this.dataStorage.updatePage(createdWiki.getWikiHome());
        return createdWiki;
    }

    private String getUserDisplayName(String username) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username, UserStatus.ANY);
            StringBuilder nameBuilder = new StringBuilder(user.getFirstName());
            nameBuilder.append(" ").append(user.getLastName());
            return nameBuilder.toString();
        }
        catch (Exception e) {
            return username;
        }
    }

    protected void invalidateAttachmentCache(Page page) {
        WikiPageParams wikiPageParams = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(wikiPageParams);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(wikiPageParams);
        for (WikiPageParams linkedWikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", linkedWikiPageParams.getType(), linkedWikiPageParams.getOwner(), linkedWikiPageParams.getPageName()));
            }
        }
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page) throws WikiException {
        return this.dataStorage.getAttachmentsOfPage(page);
    }

    @Override
    public List<Attachment> getAttachmentsOfPage(Page page, boolean loadContent) throws WikiException {
        return this.dataStorage.getAttachmentsOfPage(page, loadContent);
    }

    @Override
    public int getNbOfAttachmentsOfPage(Page page) throws WikiException {
        int nbOfAttachments = 0;
        WikiPageParams wikiPageParams = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        MarkupKey key = new MarkupKey(wikiPageParams, false);
        Integer cacheKey = new Integer(key.hashCode());
        AttachmentCountData cachedNbOfAttachments = (AttachmentCountData)this.attachmentCountCache.get((Serializable)cacheKey);
        if (cachedNbOfAttachments != null) {
            nbOfAttachments = cachedNbOfAttachments.build();
        } else {
            try {
                List<Attachment> attachments = this.dataStorage.getAttachmentsOfPage(page, false);
                nbOfAttachments = attachments == null ? 0 : attachments.size();
                this.attachmentCountCache.put((Serializable)cacheKey, (Object)new AttachmentCountData(nbOfAttachments));
            }
            catch (WikiException e) {
                log.error((Object)("Cannot get number of attachments of " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            }
        }
        return nbOfAttachments;
    }

    @Override
    public Attachment getAttachmentOfPageByName(String attachmentName, Page page) throws WikiException {
        return this.getAttachmentOfPageByName(attachmentName, page, false);
    }

    @Override
    public Attachment getAttachmentOfPageByName(String attachmentName, Page page, boolean loadContent) throws WikiException {
        Attachment attachment = null;
        List<Attachment> attachments = this.dataStorage.getAttachmentsOfPage(page, loadContent);
        for (Attachment att : attachments) {
            if (!att.getName().equals(attachmentName)) continue;
            attachment = att;
            break;
        }
        return attachment;
    }

    @Override
    public void addAttachmentToPage(Attachment attachment, Page page) throws WikiException {
        this.dataStorage.addAttachmentToPage(attachment, page);
        this.invalidateAttachmentCache(page);
        this.addAttachment(attachment, page);
    }

    @Override
    public void deleteAttachmentOfPage(String attachmentId, Page page) throws WikiException {
        this.deleteAttachment(attachmentId, page);
        this.dataStorage.deleteAttachmentOfPage(attachmentId, page);
        this.invalidateAttachmentCache(page);
    }

    @Override
    public List<SpaceBean> searchSpaces(String keyword) throws WikiException {
        ArrayList<SpaceBean> spaceBeans = new ArrayList<SpaceBean>();
        String currentUser = Utils.getCurrentUser();
        try {
            if (StringUtils.isEmpty((String)keyword)) {
                keyword = "*";
            }
            keyword = keyword.trim();
            SpaceFilter spaceFilter = new SpaceFilter(keyword);
            spaceFilter.setRemoteId(currentUser);
            spaceFilter.setAppId("Wiki");
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            ListAccess spaces = spaceService.getAccessibleSpacesByFilter(currentUser, spaceFilter);
            for (Space space : (Space[])spaces.load(0, spaces.getSize())) {
                String groupId = space.getGroupId();
                String spaceName = space.getDisplayName();
                String avatarUrl = space.getAvatarUrl();
                if (StringUtils.isBlank((String)avatarUrl)) {
                    avatarUrl = this.getDefaultSpaceAvatarUrl();
                }
                spaceBeans.add(new SpaceBean(groupId, spaceName, PortalConfig.GROUP_TYPE, avatarUrl));
            }
        }
        catch (ClassNotFoundException e) {
            List<Wiki> wikis = this.getWikisByType(WikiType.GROUP.toString());
            if (keyword != null) {
                keyword = keyword.trim();
            }
            if (keyword != null) {
                for (Wiki wiki : wikis) {
                    if (!wiki.getId().contains(keyword)) continue;
                    spaceBeans.add(new SpaceBean(wiki.getOwner(), wiki.getId(), PortalConfig.GROUP_TYPE, ""));
                }
            }
        }
        catch (Exception e) {
            throw new WikiException("Error while searching in wikis for user " + currentUser + " - Cause : " + e.getMessage(), e);
        }
        return spaceBeans;
    }

    private String getDefaultSpaceAvatarUrl() {
        return "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
    }

    @Override
    public boolean hasAdminSpacePermission(String wikiType, String owner) throws WikiException {
        Identity user;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            user = conversationState.getIdentity();
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminSpacePermission(wikiType, owner, user);
    }

    @Override
    public String getSpaceNameByGroupId(String groupId) {
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(groupId);
        if (space == null) {
            LOG.warn((Object)("Can't find space with group id " + groupId));
            return groupId.substring(groupId.lastIndexOf(47) + 1);
        }
        return space.getDisplayName();
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void addAttachment(Attachment attachment, Page page) throws WikiException {
        List<AttachmentWikiListener> listeners = this.getAttachmentListeners();
        for (AttachmentWikiListener l : listeners) {
            try {
                l.addAttachment(attachment, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on attachment with name = [%s] failed", new Object[]{l, attachment.getName()}), (Throwable)e);
            }
        }
    }

    public void deleteAttachment(String attachmentId, Page page) throws WikiException {
        List<AttachmentWikiListener> listeners = this.getAttachmentListeners();
        for (AttachmentWikiListener l : listeners) {
            try {
                l.deleteAttachment(attachmentId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on attachment with name = [%s] failed", new Object[]{l, attachmentId}), (Throwable)e);
            }
        }
    }

    @Override
    public WikiPageParams getWikiPageParams(BreadcrumbData data) {
        if (data != null) {
            return new WikiPageParams(data.getWikiType(), data.getWikiOwner(), data.getId());
        }
        return null;
    }

    @Override
    public boolean hasAdminPagePermission(String wikiType, String owner) throws WikiException {
        Identity user;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            user = conversationState.getIdentity();
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminPagePermission(wikiType, owner, user);
    }

    @Override
    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        Identity user;
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (page != null && !this.dataStorage.hasPermissionOnPage(page, PermissionType.VIEWPAGE, user = ConversationState.getCurrent().getIdentity())) {
            page = null;
        }
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public boolean hasPermissionOnWiki(Wiki wiki, PermissionType permissionType, Identity user) throws WikiException {
        return this.dataStorage.hasPermissionOnWiki(wiki, permissionType, user);
    }

    private void checkToRemoveDomainInUrl(Page page) {
        block4: {
            if (page == null) {
                return;
            }
            String url = page.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    page.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }
}

