/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@ExoEntity
@Entity(name="RealizationEntity")
@Table(name="GAMIFICATION_ACTIONS_HISTORY")
@NamedQueries(value={@NamedQuery(name="RealizationEntity.findAllRealizations", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.earnerType = :earnerType AND g.status = :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.findRealizationsByEarnerIdSortedByDate", query="SELECT g FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.status = :status ORDER BY g.createdDate DESC"), @NamedQuery(name="RealizationEntity.findAllRealizationsByDateByDomain", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.createdDate >= :date  AND g.domainEntity.id = :domainId AND g.earnerType = :earnerType  AND g.status = :status GROUP BY  g.earnerId     ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.getScoreByIdentityId", query=" SELECT SUM(g.actionScore) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.status = :status"), @NamedQuery(name="RealizationEntity.findAllRealizationsByDomain", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.domainEntity.id = :domainId AND g.earnerType = :earnerType AND g.status = :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.findRealizationsByDate", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g  WHERE g.createdDate >= :date  AND g.earnerType = :earnerType AND g.status = :status GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.findRealizationsByDateByDomain", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.createdDate >= :date     AND g.domainEntity.id = :domainId     AND g.earnerType = :earnerType     GROUP BY  g.earnerId     ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.findStatsByUser", query="SELECT new io.meeds.gamification.model.PiechartLeaderboard(g.domainEntity.title,SUM(g.actionScore)) FROM RealizationEntity g WHERE g.earnerId = :earnerId     GROUP BY  g.domainEntity.title"), @NamedQuery(name="RealizationEntity.findStatsByUserByDates", query="SELECT new io.meeds.gamification.model.PiechartLeaderboard(g.domainEntity.title,SUM(g.actionScore)) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY  g.domainEntity.title ORDER BY SUM(g.actionScore) DESC"), @NamedQuery(name="RealizationEntity.findDomainScoreByUserId", query="SELECT new io.meeds.gamification.model.ProfileReputation(g.domainEntity.id,SUM(g.actionScore)) FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.domainEntity IS NOT NULL GROUP BY  g.domainEntity.id"), @NamedQuery(name="RealizationEntity.findUserReputationScoreBetweenDate", query="SELECT SUM(g.actionScore) as total FROM RealizationEntity g  WHERE g.earnerId = :earnerId AND g.status = :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate"), @NamedQuery(name="RealizationEntity.findUsersReputationScoreBetweenDate", query="SELECT g.earnerId,SUM(g.actionScore) as total FROM RealizationEntity g  WHERE g.earnerId IN :earnersId AND g.status = :status AND g.createdDate >= :fromDate AND g.createdDate < :toDate GROUP BY g.earnerId"), @NamedQuery(name="RealizationEntity.findUserReputationScoreByMonth", query="SELECT SUM(g.actionScore) as total FROM RealizationEntity g WHERE g.earnerId = :earnerId AND g.createdDate >= :currentMonth"), @NamedQuery(name="RealizationEntity.findUserReputationScoreByDomainBetweenDate", query="SELECT SUM(g.actionScore) as total FROM RealizationEntity g WHERE g.earnerId = :earnerId     AND g.domainEntity.id = :domainId     AND g.createdDate >= :fromDate AND g.createdDate < :toDate"), @NamedQuery(name="RealizationEntity.findAllLeaderboardBetweenDate", query="SELECT new io.meeds.gamification.model.StandardLeaderboard(g.earnerId, SUM(g.actionScore) as total) FROM RealizationEntity g WHERE g.createdDate >= :fromDate AND g.createdDate < :toDate AND g.earnerType = :earnerType GROUP BY  g.earnerId ORDER BY total DESC"), @NamedQuery(name="RealizationEntity.computeTotalScore", query="SELECT SUM(a.actionScore) FROM RealizationEntity a WHERE a.earnerId = :earnerId"), @NamedQuery(name="RealizationEntity.getAllPointsByDomain", query="SELECT g FROM RealizationEntity g WHERE g.domainEntity.id = :domainId "), @NamedQuery(name="RealizationEntity.countRealizationsByRuleId", query="SELECT COUNT(a) FROM RealizationEntity a where a.ruleEntity.id = :ruleId"), @NamedQuery(name="RealizationEntity.countRealizationsByRuleIdAndEarnerType", query="SELECT COUNT(a) FROM RealizationEntity a where a.ruleEntity.id = :ruleId AND a.earnerType = :earnerType"), @NamedQuery(name="RealizationEntity.countRealizationsByRuleIdAndEarnerIdSinceDate", query="SELECT COUNT(a) FROM RealizationEntity a WHERE a.ruleEntity.id = :ruleId AND a.earnerId = :earnerId AND a.status = :status AND a.createdDate >= :date"), @NamedQuery(name="RealizationEntity.countRealizationsByRuleIdAndEarnerId", query="SELECT COUNT(a) FROM RealizationEntity a WHERE a.ruleEntity.id = :ruleId AND a.earnerId = :earnerId AND a.status = :status"), @NamedQuery(name="RealizationEntity.findRealizationsByRuleId", query="SELECT a FROM RealizationEntity a where a.ruleEntity.id = :ruleId order by a.id desc"), @NamedQuery(name="RealizationEntity.findRealizationsByRuleIdAndEarnerType", query="SELECT a FROM RealizationEntity a where a.ruleEntity.id = :ruleId AND a.earnerType = :earnerType order by a.id desc"), @NamedQuery(name="RealizationEntity.findRealizationsByRuleIdAndDate", query="SELECT a FROM RealizationEntity a where a.ruleEntity.id = :ruleId AND a.createdDate >= :fromDate AND a.createdDate < :toDate order by a.id desc"), @NamedQuery(name="RealizationEntity.findRealizationsByRuleIdAndDateAndEarnerType", query="SELECT a FROM RealizationEntity a where a.ruleEntity.id = :ruleId AND a.createdDate >= :fromDate AND a.createdDate < :toDate AND a.earnerType = :earnerType order by a.id desc"), @NamedQuery(name="RealizationEntity.findReadlizationsByRuleIdAndEarnerIdAndReceiverAndObjectId", query="SELECT g FROM RealizationEntity g WHERE g.ruleEntity.id = :ruleId AND g.earnerId = :earnerId AND g.receiver = :receiverId AND g.objectId = :objectId AND g.objectType = :objectType ORDER BY g.id DESC"), @NamedQuery(name="RealizationEntity.getRealizationsByObjectIdAndObjectType", query="SELECT g FROM RealizationEntity g WHERE g.objectId = :objectId AND g.objectType = :objectType")})
public class RealizationEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 2554394120711454093L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_SCORE_HISTORY_ID", sequenceName="SEQ_GAMIFICATION_SCORE_HISTORY_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_SCORE_HISTORY_ID")
    @Column(name="ID")
    protected Long id;
    @Column(name="EARNER_ID", nullable=false)
    private String earnerId;
    @Column(name="EARNER_TYPE", nullable=false)
    private IdentityType earnerType;
    @Column(name="GLOBAL_SCORE", nullable=false)
    protected long globalScore;
    @Column(name="ACTION_TITLE", nullable=false)
    private String actionTitle;
    @Column(name="DOMAIN", nullable=false)
    private String domain;
    @Column(name="CONTEXT", nullable=true)
    private String context;
    @Column(name="ACTION_SCORE", nullable=false)
    private long actionScore;
    @Column(name="RECEIVER", nullable=false)
    private String receiver;
    @Column(name="OBJECT_ID")
    private String objectId;
    @Column(name="OBJECT_TYPE")
    private String objectType;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private ProgramEntity domainEntity;
    @ManyToOne
    @JoinColumn(name="RULE_ID")
    private RuleEntity ruleEntity;
    @Column(name="ACTIVITY_ID")
    private Long activityId;
    @Column(name="COMMENT")
    private String comment;
    @Column(name="CREATOR_ID")
    private Long creator;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    private RealizationStatus status;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    private EntityType type;

    public Long getId() {
        return this.id;
    }

    public String getEarnerId() {
        return this.earnerId;
    }

    public IdentityType getEarnerType() {
        return this.earnerType;
    }

    public long getGlobalScore() {
        return this.globalScore;
    }

    public String getActionTitle() {
        return this.actionTitle;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getContext() {
        return this.context;
    }

    public long getActionScore() {
        return this.actionScore;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public ProgramEntity getDomainEntity() {
        return this.domainEntity;
    }

    public RuleEntity getRuleEntity() {
        return this.ruleEntity;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public String getComment() {
        return this.comment;
    }

    public Long getCreator() {
        return this.creator;
    }

    public RealizationStatus getStatus() {
        return this.status;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEarnerId(String earnerId) {
        this.earnerId = earnerId;
    }

    public void setEarnerType(IdentityType earnerType) {
        this.earnerType = earnerType;
    }

    public void setGlobalScore(long globalScore) {
        this.globalScore = globalScore;
    }

    public void setActionTitle(String actionTitle) {
        this.actionTitle = actionTitle;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setActionScore(long actionScore) {
        this.actionScore = actionScore;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setDomainEntity(ProgramEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public void setRuleEntity(RuleEntity ruleEntity) {
        this.ruleEntity = ruleEntity;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public void setStatus(RealizationStatus status) {
        this.status = status;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "RealizationEntity(id=" + this.getId() + ", earnerId=" + this.getEarnerId() + ", earnerType=" + this.getEarnerType() + ", globalScore=" + this.getGlobalScore() + ", actionTitle=" + this.getActionTitle() + ", domain=" + this.getDomain() + ", context=" + this.getContext() + ", actionScore=" + this.getActionScore() + ", receiver=" + this.getReceiver() + ", objectId=" + this.getObjectId() + ", objectType=" + this.getObjectType() + ", domainEntity=" + this.getDomainEntity() + ", ruleEntity=" + this.getRuleEntity() + ", activityId=" + this.getActivityId() + ", comment=" + this.getComment() + ", creator=" + this.getCreator() + ", status=" + this.getStatus() + ", type=" + this.getType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizationEntity)) {
            return false;
        }
        RealizationEntity other = (RealizationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getGlobalScore() != other.getGlobalScore()) {
            return false;
        }
        if (this.getActionScore() != other.getActionScore()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        Long this$creator = this.getCreator();
        Long other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !((Object)this$creator).equals(other$creator)) {
            return false;
        }
        String this$earnerId = this.getEarnerId();
        String other$earnerId = other.getEarnerId();
        if (this$earnerId == null ? other$earnerId != null : !this$earnerId.equals(other$earnerId)) {
            return false;
        }
        IdentityType this$earnerType = this.getEarnerType();
        IdentityType other$earnerType = other.getEarnerType();
        if (this$earnerType == null ? other$earnerType != null : !((Object)((Object)this$earnerType)).equals((Object)other$earnerType)) {
            return false;
        }
        String this$actionTitle = this.getActionTitle();
        String other$actionTitle = other.getActionTitle();
        if (this$actionTitle == null ? other$actionTitle != null : !this$actionTitle.equals(other$actionTitle)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        String this$receiver = this.getReceiver();
        String other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$objectType = this.getObjectType();
        String other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        ProgramEntity this$domainEntity = this.getDomainEntity();
        ProgramEntity other$domainEntity = other.getDomainEntity();
        if (this$domainEntity == null ? other$domainEntity != null : !((Object)this$domainEntity).equals(other$domainEntity)) {
            return false;
        }
        RuleEntity this$ruleEntity = this.getRuleEntity();
        RuleEntity other$ruleEntity = other.getRuleEntity();
        if (this$ruleEntity == null ? other$ruleEntity != null : !((Object)this$ruleEntity).equals(other$ruleEntity)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        RealizationStatus this$status = this.getStatus();
        RealizationStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RealizationEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $globalScore = this.getGlobalScore();
        result = result * 59 + (int)($globalScore >>> 32 ^ $globalScore);
        long $actionScore = this.getActionScore();
        result = result * 59 + (int)($actionScore >>> 32 ^ $actionScore);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        Long $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : ((Object)$creator).hashCode());
        String $earnerId = this.getEarnerId();
        result = result * 59 + ($earnerId == null ? 43 : $earnerId.hashCode());
        IdentityType $earnerType = this.getEarnerType();
        result = result * 59 + ($earnerType == null ? 43 : ((Object)((Object)$earnerType)).hashCode());
        String $actionTitle = this.getActionTitle();
        result = result * 59 + ($actionTitle == null ? 43 : $actionTitle.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        String $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        ProgramEntity $domainEntity = this.getDomainEntity();
        result = result * 59 + ($domainEntity == null ? 43 : ((Object)$domainEntity).hashCode());
        RuleEntity $ruleEntity = this.getRuleEntity();
        result = result * 59 + ($ruleEntity == null ? 43 : ((Object)$ruleEntity).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        RealizationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }
}

