/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.BadgeService;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import java.util.List;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ProgramDeletedListener
extends Listener<ProgramDTO, String> {
    private static final Log LOG = ExoLogger.getLogger(ProgramDeletedListener.class);
    protected ProgramService programService;
    protected RuleService ruleService;
    protected BadgeService badgeService;

    public ProgramDeletedListener(ProgramService programService, RuleService ruleService, BadgeService badgeService) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.badgeService = badgeService;
    }

    public void onEvent(Event<ProgramDTO, String> event) throws Exception {
        ProgramDTO program = (ProgramDTO)event.getSource();
        if (!program.isDeleted()) {
            LOG.warn("Program {} seems not deleted. Ignore marking Program rules as deleted as well.", new Object[]{program.getId()});
            return;
        }
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setProgramId(program.getId());
        List<RuleDTO> rules = this.ruleService.getRules(ruleFilter, 0, -1);
        List<BadgeDTO> badges = this.badgeService.findBadgesByProgramId(program.getId());
        for (RuleDTO rule : rules) {
            if (rule.isDeleted()) continue;
            this.ruleService.deleteRuleById(rule.getId());
        }
        for (BadgeDTO badge : badges) {
            badge.setEnabled(false);
            this.badgeService.updateBadge(badge);
        }
    }
}

