/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActionAnnouncedNotificationPlugin
extends BaseNotificationPlugin {
    private RuleService ruleService;
    private ActivityManager activityManager;

    public ActionAnnouncedNotificationPlugin(RuleService ruleService, ActivityManager activityManager, InitParams initParams) {
        super(initParams);
        this.ruleService = ruleService;
        this.activityManager = activityManager;
    }

    public String getId() {
        return "GamificationActionAnnouncedNotification";
    }

    public boolean isValid(NotificationContext ctx) {
        Announcement announcement = (Announcement)ctx.value(Utils.ANNOUNCEMENT_NOTIFICATION_PARAMETER);
        return announcement != null && announcement.getCreator() != null && announcement.getCreator() > 0L && announcement.getActivityId() > 0L;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Announcement announcement = (Announcement)ctx.value(Utils.ANNOUNCEMENT_NOTIFICATION_PARAMETER);
        if (announcement == null) {
            return null;
        }
        RuleDTO rule = this.ruleService.findRuleById(announcement.getChallengeId());
        if (rule == null) {
            return null;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(rule.getActivityId()));
        if (activity == null) {
            return null;
        }
        HashSet<String> receivers = new HashSet<String>();
        this.addReceivers(receivers, activity.getCommentedIds());
        this.addReceivers(receivers, activity.getPosterId());
        this.addReceivers(receivers, activity.getLikeIdentityIds());
        this.addReceivers(receivers, activity.getMentionedIds());
        receivers.remove(Utils.getUserRemoteId(String.valueOf(announcement.getCreator())));
        if (receivers.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(receivers.stream().toList()).with("ANNOUNCEMENT_ID", String.valueOf(announcement.getId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), String.valueOf(announcement.getActivityId())).key(this.getId()).end();
    }

    private void addReceivers(Set<String> receivers, String ... userIdentityIds) {
        if (userIdentityIds != null && userIdentityIds.length > 0) {
            Arrays.stream(userIdentityIds).map(Utils::getUserRemoteId).forEach(receivers::add);
        }
    }
}

