/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.service.ProgramService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ProgramTranslationPlugin
extends TranslationPlugin {
    public static final String PROGRAM_OBJECT_TYPE = "program";
    public static final String PROGRAM_DESCRIPTION_FIELD_NAME = "description";
    public static final String PROGRAM_TITLE_FIELD_NAME = "title";
    private ProgramService programService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public ProgramTranslationPlugin(ProgramService programService, SpaceService spaceService, IdentityManager identityManager) {
        this.programService = programService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public String getObjectType() {
        return PROGRAM_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(long programId, String username) throws ObjectNotFoundException {
        return this.programService.isProgramMember(programId, username);
    }

    public boolean hasEditPermission(long programId, String username) throws ObjectNotFoundException {
        ProgramDTO program = this.programService.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(String.format("Program with id %s wasn't found", programId));
        }
        return this.programService.isProgramOwner(programId, username);
    }

    public long getAudienceId(long programId) throws ObjectNotFoundException {
        long spaceId = this.getSpaceId(programId);
        if (spaceId == 0L) {
            return 0L;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s wasn't found", spaceId));
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        return Long.parseLong(spaceIdentity.getId());
    }

    public long getSpaceId(long programId) throws ObjectNotFoundException {
        ProgramDTO program = this.programService.getProgramById(programId);
        if (program == null) {
            throw new ObjectNotFoundException(String.format("Program with id %s wasn't found", programId));
        }
        return program.getSpaceId();
    }
}

