/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.rest.builder.ProgramBuilder;
import io.meeds.gamification.rest.builder.RuleBuilder;
import io.meeds.gamification.rest.model.RealizationRestEntity;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;

public class RealizationBuilder {
    private static final Log LOG = ExoLogger.getLogger(RealizationBuilder.class);

    private RealizationBuilder() {
    }

    public static RealizationRestEntity toRestEntity(RuleService ruleService, TranslationService translationService, IdentityManager identityManager, RealizationDTO realization, Locale locale) {
        try {
            RuleDTO rule;
            String spaceName = "";
            if (realization.getRuleId() != null && realization.getRuleId() != 0L) {
                Space space;
                long spaceId;
                rule = ruleService.findRuleById(realization.getRuleId());
                if (rule != null && (spaceId = rule.getSpaceId()) > 0L && (space = Utils.getSpaceById(String.valueOf(spaceId))) != null) {
                    spaceName = space.getDescription();
                }
            } else {
                spaceName = Utils.getSpaceFromObjectID(realization.getObjectId());
            }
            rule = realization.getRuleId() != null && realization.getRuleId() != 0L ? ruleService.findRuleById(realization.getRuleId()) : ruleService.findRuleByTitle(realization.getActionTitle());
            boolean actionLabelChanged = !StringUtils.equals((CharSequence)realization.getActionTitle(), (CharSequence)rule.getTitle());
            boolean programLabelChanged = !StringUtils.equals((CharSequence)realization.getProgramLabel(), (CharSequence)rule.getProgram().getTitle());
            RealizationBuilder.translatedLabels(translationService, realization, rule, locale);
            return new RealizationRestEntity(realization.getId(), Utils.getIdentityEntity(identityManager, Long.parseLong(realization.getEarnerId())), rule, realization.getProgram(), realization.getProgramLabel(), realization.getActionTitle() != null ? realization.getActionTitle() : Objects.requireNonNull(rule).getTitle(), realization.getActionScore(), Utils.getUserFullName(realization.getCreator() != null ? String.valueOf(realization.getCreator()) : realization.getReceiver()), realization.getCreatedDate(), realization.getStatus(), spaceName, realization.getObjectId(), realization.getObjectType(), realization.getActivityId(), actionLabelChanged, programLabelChanged);
        }
        catch (Exception e) {
            LOG.error("Error while mapping history with id {}", new Object[]{realization.getId(), e});
            return null;
        }
    }

    public static void translatedLabels(TranslationService translationService, RealizationDTO realization, RuleDTO rule, Locale locale) {
        RuleBuilder.translatedLabels(translationService, rule, locale);
        if (Objects.equals(realization.getProgram(), rule.getProgram())) {
            realization.setProgram(rule.getProgram());
        } else {
            ProgramBuilder.translatedLabels(translationService, realization.getProgram(), locale);
        }
    }

    public static List<RealizationRestEntity> toRestEntities(RuleService ruleService, TranslationService translationService, IdentityManager identityManager, List<RealizationDTO> realizations, Locale locale) {
        if (CollectionUtils.isEmpty(realizations)) {
            return new ArrayList<RealizationRestEntity>(Collections.emptyList());
        }
        return realizations.stream().map(realization -> RealizationBuilder.toRestEntity(ruleService, translationService, identityManager, realization, locale)).toList();
    }
}

