/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class ProgramStorage {
    private static final Log LOG = ExoLogger.getLogger(ProgramStorage.class);
    private static final String FILE_API_NAME_SPACE = "gamification";
    private final ProgramDAO programDAO;
    private final RuleDAO ruleDAO;
    private final FileService fileService;
    private final UploadService uploadService;

    public ProgramStorage(FileService fileService, UploadService uploadService, ProgramDAO programDAO, RuleDAO ruleDAO) {
        this.programDAO = programDAO;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.ruleDAO = ruleDAO;
    }

    public ProgramDTO saveProgram(ProgramDTO program) {
        ProgramEntity programEntity = ProgramMapper.toEntity(program);
        if (StringUtils.isNotBlank((CharSequence)program.getCoverUploadId())) {
            Long coverFileId = this.saveProgramImage(program.getCoverUploadId());
            programEntity.setCoverFileId(coverFileId);
        }
        if (StringUtils.isNotBlank((CharSequence)program.getAvatarUploadId())) {
            Long avatarFileId = this.saveProgramImage(program.getAvatarUploadId());
            programEntity.setAvatarFileId(avatarFileId);
        }
        if (CollectionUtils.isEmpty(programEntity.getOwners())) {
            programEntity.setOwners(new HashSet<Long>());
        } else {
            programEntity.setOwners(new HashSet<Long>(programEntity.getOwners()));
        }
        if (programEntity.getId() == null || programEntity.getId() == 0L) {
            programEntity.setId(null);
            programEntity.setCreatedDate(new Date());
            programEntity = (ProgramEntity)this.programDAO.create(programEntity);
        } else {
            programEntity.setLastModifiedDate(new Date());
            programEntity = (ProgramEntity)this.programDAO.update(programEntity);
        }
        return ProgramMapper.fromEntity(this.ruleDAO, programEntity);
    }

    public void updateProgramDate(long programId) {
        ProgramEntity programEntity = (ProgramEntity)this.programDAO.find(Long.valueOf(programId));
        if (programEntity != null) {
            programEntity.setLastModifiedDate(new Date());
            this.programDAO.update(programEntity);
        }
    }

    public ProgramDTO getProgramByTitle(String programTitle) {
        return ProgramMapper.fromEntity(this.ruleDAO, this.programDAO.getProgramByTitle(programTitle));
    }

    public List<Long> findHighestBudgetProgramIdsBySpacesIds(ProgramFilter programFilter, int offset, int limit) {
        if (CollectionUtils.isNotEmpty(programFilter.getSpacesIds())) {
            return this.ruleDAO.findHighestBudgetProgramIdsBySpacesIds(programFilter.getSpacesIds(), offset, limit);
        }
        if (programFilter.isAllSpaces()) {
            return this.ruleDAO.findHighestBudgetProgramIds(offset, limit);
        }
        return this.ruleDAO.findHighestBudgetOpenProgramIds(offset, limit);
    }

    public List<Long> getProgramIdsByFilter(ProgramFilter filter, int offset, int limit) {
        return this.programDAO.getProgramIdsByFilter(offset, limit, filter);
    }

    public int countPrograms(ProgramFilter programFilter) {
        return this.programDAO.countPrograms(programFilter);
    }

    public ProgramDTO getProgramById(Long id) {
        ProgramEntity programEntity = (ProgramEntity)this.programDAO.find(id);
        return ProgramMapper.fromEntity(this.ruleDAO, programEntity);
    }

    public boolean isProgramColorExists(String newColor) {
        return this.programDAO.countProgramColor(newColor) > 0;
    }

    public InputStream getImageAsStream(long fileId) {
        try {
            FileItem fileItem = this.fileService.getFile(fileId);
            return fileItem == null || fileItem.getFileInfo() == null ? null : fileItem.getAsStream();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving image with id {}", new Object[]{fileId, e});
            return null;
        }
    }

    public void deleteImage(long fileId) {
        try {
            FileItem fileItem = this.fileService.getFile(fileId);
            if (fileItem != null && fileItem.getFileInfo() != null && !fileItem.getFileInfo().isDeleted()) {
                this.fileService.deleteFile(fileId);
            }
        }
        catch (Exception e) {
            LOG.warn("Error deleting file image with id {}", new Object[]{fileId, e});
        }
    }

    public void clearCache() {
    }

    private Long saveProgramImage(String uploadId) {
        if (uploadId == null || uploadId.isBlank()) {
            throw new IllegalArgumentException("uploadId is mandatory");
        }
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            throw new IllegalStateException("Can't find uploaded resource with id : " + uploadId);
        }
        try {
            FileInputStream inputStream = new FileInputStream(uploadResource.getStoreLocation());
            FileItem fileItem = new FileItem(null, uploadResource.getFileName(), uploadResource.getMimeType(), FILE_API_NAME_SPACE, (long)uploadResource.getUploadedSize(), new Date(), IdentityConstants.SYSTEM, false, (InputStream)inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            Long l = fileItem != null && fileItem.getFileInfo() != null ? fileItem.getFileInfo().getId() : null;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving Program image file", e);
        }
        finally {
            this.uploadService.removeUploadResource(uploadResource.getUploadId());
        }
    }
}

