/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.mapper;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ProgramMapper {
    private ProgramMapper() {
    }

    public static List<ProgramDTO> fromEntities(RuleDAO ruleDAO, List<ProgramEntity> programs) {
        return programs.stream().filter(Objects::nonNull).map(entity -> ProgramMapper.fromEntity(ruleDAO, entity)).toList();
    }

    public static ProgramEntity toEntity(ProgramDTO program) {
        if (program == null) {
            return null;
        }
        ProgramEntity programEntity = new ProgramEntity();
        programEntity.setId(program.getId());
        programEntity.setTitle(program.getTitle());
        programEntity.setDescription(program.getDescription());
        programEntity.setColor(StringUtils.upperCase((String)program.getColor()));
        programEntity.setCreatedBy(program.getCreatedBy());
        programEntity.setLastModifiedBy(program.getLastModifiedBy());
        programEntity.setDeleted(program.isDeleted());
        programEntity.setEnabled(program.isEnabled());
        if (program.getSpaceId() > 0L && !program.isOpen()) {
            programEntity.setAudienceId(program.getSpaceId());
        } else {
            programEntity.setAudienceId(null);
        }
        if (program.getCreatedDate() != null) {
            programEntity.setCreatedDate(Utils.parseRFC3339Date(program.getCreatedDate()));
        }
        programEntity.setLastModifiedDate(Utils.parseRFC3339Date(program.getLastModifiedDate()));
        programEntity.setPriority(program.getPriority());
        programEntity.setBudget(program.getBudget());
        programEntity.setCoverFileId(program.getCoverFileId());
        programEntity.setAvatarFileId(program.getAvatarFileId());
        if (StringUtils.isBlank((CharSequence)program.getType())) {
            programEntity.setType(EntityType.AUTOMATIC);
        } else {
            programEntity.setType(EntityType.valueOf(program.getType()));
        }
        if (program.getOwnerIds() != null) {
            programEntity.setOwners(program.getOwnerIds());
        } else {
            programEntity.setOwners(Collections.emptySet());
        }
        return programEntity;
    }

    public static ProgramDTO fromEntity(RuleDAO ruleDAO, ProgramEntity programEntity) {
        if (programEntity == null) {
            return null;
        }
        long lastUpdateTime = programEntity.getLastModifiedDate() == null ? 0L : programEntity.getLastModifiedDate().getTime();
        String coverUrl = Utils.buildAttachmentUrl(String.valueOf(programEntity.getId()), lastUpdateTime, "cover", "default-cover", programEntity.getCoverFileId() == 0L);
        String avatarUrl = Utils.buildAttachmentUrl(String.valueOf(programEntity.getId()), lastUpdateTime, "avatar", "default-avatar", programEntity.getAvatarFileId() == 0L);
        ProgramDTO program = new ProgramDTO();
        program.setId(programEntity.getId());
        program.setTitle(programEntity.getTitle());
        program.setDescription(programEntity.getDescription());
        program.setColor(StringUtils.upperCase((String)programEntity.getColor()));
        if (programEntity.getAudienceId() != null) {
            program.setSpaceId(programEntity.getAudienceId());
        }
        program.setCreatedBy(programEntity.getCreatedBy());
        program.setCreatedDate(Utils.toRFC3339Date(programEntity.getCreatedDate()));
        program.setLastModifiedBy(programEntity.getLastModifiedBy());
        program.setLastModifiedDate(Utils.toRFC3339Date(programEntity.getLastModifiedDate()));
        program.setDeleted(programEntity.isDeleted());
        program.setEnabled(programEntity.isEnabled());
        program.setBudget(programEntity.getBudget());
        program.setType(programEntity.getType().name());
        program.setCoverFileId(programEntity.getCoverFileId());
        program.setAvatarFileId(programEntity.getAvatarFileId());
        program.setCoverUrl(coverUrl);
        program.setAvatarUrl(avatarUrl);
        program.setOwnerIds(programEntity.getOwners());
        program.setOpen(programEntity.getAudienceId() == null);
        program.setRulesTotalScore(programEntity.isDeleted() || !programEntity.isEnabled() ? 0L : ruleDAO.getRulesTotalScoreByProgramId(programEntity.getId()));
        return program;
    }
}

