/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;

public class PageKey
implements Serializable {
    private static final long serialVersionUID = -5005776237959733435L;
    final SiteKey site;
    final String name;
    private String ref;

    public static PageKey parse(String pageKey) {
        if (StringUtils.isBlank((CharSequence)pageKey)) {
            throw new IllegalArgumentException("No null string argument allowed");
        }
        String[] pageKeyParts = StringUtils.split((String)pageKey, (String)"::");
        if (pageKeyParts.length != 3) {
            throw new IllegalArgumentException("Format should be SITE_TYPE::SITE_NAME::PAGE_NAME");
        }
        return SiteType.valueOf(pageKeyParts[0].toUpperCase()).key(pageKeyParts[1]).page(pageKeyParts[2]);
    }

    public PageKey(String siteType, String siteName, String name) {
        this(SiteType.valueOf(siteType.toUpperCase()).key(siteName), name);
    }

    public PageKey(SiteType siteType, String siteName, String name) {
        this(siteType.key(siteName), name);
    }

    public PageKey(SiteKey site, String name) {
        this.site = site;
        this.name = name;
    }

    public PageKey sibling(String name) {
        return new PageKey(this.site, name);
    }

    public String format() {
        if (this.ref == null) {
            this.ref = String.format("%s::%s::%s", this.site.getType().getName(), this.site.getName(), this.name);
        }
        return this.ref;
    }

    public org.exoplatform.portal.pom.data.PageKey toPomPageKey() {
        return new org.exoplatform.portal.pom.data.PageKey(this.site.getType().getName(), this.site.getName(), this.name);
    }

    public String toString() {
        return this.format();
    }

    public SiteKey getSite() {
        return this.site;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageKey)) {
            return false;
        }
        PageKey other = (PageKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SiteKey this$site = this.getSite();
        SiteKey other$site = other.getSite();
        if (this$site == null ? other$site != null : !((Object)this$site).equals(other$site)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SiteKey $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : ((Object)$site).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        return result;
    }
}

