/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class DefaultRequestHandler
extends WebRequestHandler {
    private final UserPortalConfigService configService;
    private final URLFactoryService urlFactory;

    public DefaultRequestHandler(UserPortalConfigService configService, URLFactoryService urlFactory) {
        this.configService = configService;
        this.urlFactory = urlFactory;
    }

    public String getHandlerName() {
        return "default";
    }

    public boolean execute(ControllerContext context) throws Exception {
        String defaultUri = null;
        String currentUser = context.getRequest().getRemoteUser();
        if (StringUtils.isNotBlank((CharSequence)currentUser)) {
            defaultUri = this.configService.getUserHomePage(currentUser);
        }
        if (StringUtils.isBlank(defaultUri)) {
            boolean canAccessDefaultPortal;
            String defaultPortal = this.configService.getDefaultPortal();
            List portalNames = this.configService.getSiteNames(SiteType.PORTAL, 0, 10);
            boolean emptyPortalList = portalNames == null || portalNames.isEmpty();
            boolean bl = canAccessDefaultPortal = portalNames != null && portalNames.contains(defaultPortal);
            if (!emptyPortalList && !canAccessDefaultPortal) {
                defaultPortal = (String)portalNames.get(0);
            } else if (emptyPortalList) {
                HttpServletResponse resp = context.getResponse();
                String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
                resp.sendRedirect("/" + currentPortalContainerName + "/login");
                return true;
            }
            PortalURLContext urlContext = new PortalURLContext(context, SiteKey.portal((String)defaultPortal));
            NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
            defaultUri = url.setResource(new NavigationResource(SiteType.PORTAL, defaultPortal, "")).toString();
        }
        HttpServletResponse resp = context.getResponse();
        resp.sendRedirect(resp.encodeRedirectURL(defaultUri));
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

