/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.EventRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.portlet.filter.PortletResponseWrapper;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.impl.jsr168.Dispatch;
import org.gatein.pc.portlet.impl.jsr168.DispatchType;
import org.gatein.pc.portlet.impl.jsr168.DispatchedHttpServletRequest;
import org.gatein.pc.portlet.impl.jsr168.DispatchedHttpServletResponse;
import org.gatein.pc.portlet.impl.jsr168.api.MimeResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.StateAwareResponseImpl;

public class PortletRequestDispatcherImpl
implements PortletRequestDispatcher {
    private final RequestDispatcher dispatcher;
    private final String path;

    PortletRequestDispatcherImpl(RequestDispatcher dispatcher) {
        this(dispatcher, null);
    }

    PortletRequestDispatcherImpl(RequestDispatcher dispatcher, String path) {
        this.dispatcher = dispatcher;
        this.path = path;
    }

    public void include(RenderRequest req, RenderResponse resp) throws PortletException, IOException {
        this.dispatch(DispatchType.INCLUDE, (PortletRequest)req, (PortletResponse)resp);
    }

    public void include(PortletRequest req, PortletResponse resp) throws PortletException, IOException {
        this.dispatch(DispatchType.INCLUDE, req, resp);
    }

    public void forward(PortletRequest req, PortletResponse resp) throws PortletException, IOException, IllegalStateException {
        this.dispatch(DispatchType.FORWARD, req, resp);
    }

    private void dispatch(DispatchType type, PortletRequest wreq, PortletResponse wresp) throws PortletException, IOException {
        PortletRequestImpl req = this.unwrap(wreq);
        PortletResponseImpl resp = this.unwrap(wresp);
        Dispatch dispatch = new Dispatch(type, this.path);
        try {
            DispatchedHttpServletResponse diresp;
            DispatchedHttpServletRequest direq;
            PortletApplication application = req.container.getPortletApplication();
            PortletApplicationContext applicationContext = application.getContext();
            ServletContext servletContext = applicationContext.getServletContext();
            HttpServletRequestWrapper realReq = req.getRealRequest();
            HttpServletResponseWrapper realResp = resp.getRealResponse();
            if (req instanceof ActionRequest) {
                direq = new DispatchedHttpServletRequest.Action(dispatch, (ActionRequest)req, realReq, servletContext);
                diresp = new DispatchedHttpServletResponse.StateAware(direq, (StateAwareResponseImpl)resp, (HttpServletResponse)realResp);
            } else if (req instanceof EventRequest) {
                direq = new DispatchedHttpServletRequest.Event(dispatch, (EventRequest)req, realReq, servletContext);
                diresp = new DispatchedHttpServletResponse.StateAware(direq, (StateAwareResponseImpl)resp, (HttpServletResponse)realResp);
            } else if (req instanceof RenderRequest) {
                direq = new DispatchedHttpServletRequest.Render(dispatch, (RenderRequest)req, realReq, servletContext);
                diresp = new DispatchedHttpServletResponse.Mime(direq, (MimeResponseImpl)resp, (HttpServletResponse)realResp);
            } else {
                direq = new DispatchedHttpServletRequest.Resource(dispatch, (ResourceRequest)req, realReq, servletContext);
                diresp = new DispatchedHttpServletResponse.Mime(direq, (MimeResponseImpl)resp, (HttpServletResponse)realResp);
            }
            switch (type) {
                case INCLUDE: {
                    this.dispatcher.include((ServletRequest)direq, (ServletResponse)diresp);
                    break;
                }
                case FORWARD: {
                    if (resp instanceof MimeResponse) {
                        if (((MimeResponse)resp).isCommitted()) {
                            throw new IllegalStateException();
                        }
                        ((MimeResponse)resp).resetBuffer();
                    }
                    this.dispatcher.include((ServletRequest)direq, (ServletResponse)diresp);
                    if (!(resp instanceof MimeResponse)) break;
                    ((MimeResponse)resp).flushBuffer();
                }
            }
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private PortletRequestImpl unwrap(PortletRequest wrapped) {
        while (true) {
            if (wrapped instanceof PortletRequestImpl) {
                return (PortletRequestImpl)wrapped;
            }
            if (!(wrapped instanceof PortletRequestWrapper)) break;
            PortletRequestWrapper wrapper = (PortletRequestWrapper)wrapped;
            wrapped = wrapper.getRequest();
        }
        throw new IllegalArgumentException("Cannot unwrap request: " + wrapped.getClass().getName());
    }

    private PortletResponseImpl unwrap(PortletResponse wrapped) {
        while (!(wrapped instanceof PortletResponseImpl)) {
            if (wrapped instanceof PortletResponseWrapper) {
                PortletResponseWrapper wrapper = (PortletResponseWrapper)wrapped;
                wrapped = wrapper.getResponse();
                continue;
            }
            Class<?> wrappedClass = wrapped.getClass();
            try {
                Method getResponse = wrappedClass.getMethod("getResponse", new Class[0]);
                wrapped = (PortletResponse)getResponse.invoke((Object)wrapped, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot unwrap response: " + wrappedClass.getName());
            }
        }
        return (PortletResponseImpl)wrapped;
    }
}

