/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.integration.gamification;

import java.util.HashMap;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.listener.PageWikiListener;

@Asynchronous
public class GamificationWikiListener
extends PageWikiListener {
    public static final String GAMIFICATION_WIKI_ADD_PAGE = "addWikiPage";
    public static final String GAMIFICATION_WIKI_UPDATE_PAGE = "updateWikiPage";
    public static final String NOTES_OBJECT_TYPE = "notes";
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationWikiListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) {
        if ("Home".equals(pageId)) {
            return;
        }
        if (ConversationState.getCurrent() != null) {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_WIKI_ADD_PAGE, page.getId());
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postgetPagefromTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postgetPagefromBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) {
        if (page != null && wikiUpdateType != null && (wikiUpdateType.equals((Object)PageUpdateType.ADD_PAGE) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT) || wikiUpdateType.equals((Object)PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE)) && ConversationState.getCurrent() != null) {
            String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
            String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_WIKI_UPDATE_PAGE, page.getId());
        }
    }

    private void createGamificationRealization(String earnerIdentityId, String receiverId, String gamificationEventName, String pageId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", pageId);
            gam.put("objectType", NOTES_OBJECT_TYPE);
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error triggering Gamification Listener Event: " + gam, e);
        }
    }
}

