/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.rest.builder;

import java.util.Collection;
import java.util.List;
import org.exoplatform.gamification.github.model.RemoteOrganization;
import org.exoplatform.gamification.github.model.TokenStatus;
import org.exoplatform.gamification.github.model.WebHook;
import org.exoplatform.gamification.github.rest.model.WebHookRestEntity;
import org.exoplatform.gamification.github.services.GithubConsumerService;
import org.exoplatform.gamification.github.services.WebhookService;

public class WebHookBuilder {
    private WebHookBuilder() {
    }

    public static WebHookRestEntity toRestEntity(WebhookService webhookService, GithubConsumerService githubConsumerService, WebHook webHook) {
        if (webHook == null) {
            return null;
        }
        RemoteOrganization remoteOrganization = null;
        TokenStatus tokenStatus = githubConsumerService.checkGitHubTokenStatus(webHook.getToken());
        if (tokenStatus.isValid() && tokenStatus.getRemaining() > 0L) {
            remoteOrganization = githubConsumerService.retrieveRemoteOrganization(webHook.getOrganizationId(), webHook.getToken());
        }
        return new WebHookRestEntity(webHook.getId(), webHook.getWebhookId(), webHook.getOrganizationId(), webHook.getTriggers(), webHook.getEnabled(), webHook.getWatchedDate(), webHook.getWatchedBy(), webHook.getUpdatedDate(), webHook.getRefreshDate(), webHook.getOrganizationName(), remoteOrganization != null ? remoteOrganization.getTitle() : null, remoteOrganization != null ? remoteOrganization.getDescription() : null, remoteOrganization != null ? remoteOrganization.getAvatarUrl() : null, webhookService.isWebHookWatchLimitEnabled(webHook.getOrganizationId()), tokenStatus);
    }

    public static List<WebHookRestEntity> toRestEntities(WebhookService webhookService, GithubConsumerService githubConsumerService, Collection<WebHook> webHooks) {
        return webHooks.stream().map(webHook -> WebHookBuilder.toRestEntity(webhookService, githubConsumerService, webHook)).toList();
    }
}

