/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.util.concurrent.locks.DeadlockDetectingLockManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.concurrent.locks.impl.DefaultLockManager;
import org.infinispan.util.concurrent.locks.impl.DefaultPendingLockManager;
import org.infinispan.util.concurrent.locks.impl.NoOpPendingLockManager;

@DefaultFactoryFor(classes={LockManager.class, PendingLockManager.class})
public class LockManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (PendingLockManager.class.equals(componentType)) {
            return componentType.cast(this.configuration.clustering().cacheMode().isClustered() ? new DefaultPendingLockManager() : NoOpPendingLockManager.getInstance());
        }
        if (LockManager.class.equals(componentType)) {
            return componentType.cast(this.configuration.deadlockDetection().enabled() ? new DeadlockDetectingLockManager() : new DefaultLockManager());
        }
        throw new IllegalArgumentException("Unexpected component type " + componentType + ".");
    }
}

