/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/perkstore/api/order")
@Tag(name="/perkstore/api/order", description="Manages perk store product orders")
@RolesAllowed(value={"users"})
public class PerkStoreOrderREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreOrderREST.class);
    private static final List<ProductOrderModificationType> ALLOWED_ORDER_MODIFICATIONS = Arrays.asList(ProductOrderModificationType.DELIVERED_QUANTITY, ProductOrderModificationType.REFUNDED_QUANTITY, ProductOrderModificationType.STATUS);
    private PerkStoreService perkStoreService;

    public PerkStoreOrderREST(PerkStoreService perkStoreService) {
        this.perkStoreService = perkStoreService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of orders for current user using a filter", method="POST", description="Retrieves the list of orders for current user using a filter")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response listOrders(@Parameter(description="OrderFilter object with search conditions", required=true) OrderFilter filter) {
        if (filter == null) {
            LOG.warn((Object)"Bad request sent to server with empty filter");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            List<ProductOrder> orders = this.perkStoreService.getOrders(filter, currentUserId);
            return Response.ok(orders).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Listing orders", currentUserId, filter);
        }
        catch (Exception e) {
            LOG.error((Object)"Error listing orders", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save")
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a new order for current user on a selected product", method="POST", description="Creates a new order for current user on a selected product")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createOrder(@RequestBody(description="ProductOrder object", required=true) ProductOrder order) {
        if (order == null) {
            LOG.warn((Object)"Bad request sent to server with empty order to create");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            order = this.perkStoreService.createOrder(order, currentUserId);
            return Response.ok((Object)order).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Creating new order", currentUserId, order);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating order", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="saveSimulate")
    @RolesAllowed(value={"users"})
    @Operation(summary="Check that order can be saved with given attributes", method="POST", description="Check that order can be saved with given attributes")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveOrderSimulate(@RequestBody(description="ProductOrder object", required=true) ProductOrder order) {
        if (order == null) {
            LOG.warn((Object)"Bad request sent to server with empty order");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            order.setTransactionHash("0x0000000000000000000000000000000000000000000000000000000000000000");
            this.perkStoreService.checkCanCreateOrder(order, currentUserId);
            return Response.noContent().build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Simulating order creation", currentUserId, order);
        }
        catch (Exception e) {
            LOG.error((Object)"Error simulating order save", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="saveStatus")
    @RolesAllowed(value={"users"})
    @Operation(summary="Modifies an existing order by specifying the type of modification", method="POST", description="Modifies an existing order by specifying the type of modification (order attribute to change)")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveOrder(@RequestBody(description="ProductOrder object", required=true) ProductOrder order, @Parameter(description="ProductOrderModificationType enum name", required=true) @QueryParam(value="modificationType") String modificationType) {
        if (order == null) {
            LOG.warn((Object)"Bad request sent to server with empty order");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((CharSequence)modificationType)) {
            LOG.warn((Object)"Bad request sent to server with empty order modification type");
            return Response.status((int)400).build();
        }
        ProductOrderModificationType orderModificationType = ProductOrderModificationType.valueOf(modificationType.toUpperCase());
        if (!ALLOWED_ORDER_MODIFICATIONS.contains((Object)orderModificationType)) {
            LOG.warn((Object)"Bad request sent to server with denied order modification type");
            return Response.status((int)403).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            this.perkStoreService.saveOrder(order, orderModificationType, currentUserId, true);
            return Response.ok((Object)this.perkStoreService.getOrderById(order.getId())).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Saving order status", currentUserId, order);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving order status", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

