/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebNotificationServiceImpl
implements WebNotificationService {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationServiceImpl.class);
    private final PluginSettingService pluginSettingService;
    private final UserSettingService userSettingService;
    private final WebNotificationStorage storage;
    private final AbstractChannel webChannel;

    public WebNotificationServiceImpl(PluginSettingService pluginSettingService, UserSettingService userSettingService, WebNotificationStorage webStorage, ChannelManager channelManager) {
        this.storage = webStorage;
        this.pluginSettingService = pluginSettingService;
        this.userSettingService = userSettingService;
        this.webChannel = channelManager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
    }

    public void save(NotificationInfo notification) {
        this.storage.save(notification);
    }

    public NotificationInfo getNotificationInfo(String notificationId) {
        return this.storage.get(notificationId);
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
    }

    public void markAllRead(String userId) {
        this.storage.markAllRead(userId);
    }

    public void markAllRead(List<String> plugins, String username) {
        if (CollectionUtils.isEmpty(plugins)) {
            this.markAllRead(username);
        } else {
            this.storage.markAllRead(plugins, username);
        }
    }

    public List<NotificationInfo> getNotificationInfos(WebNotificationFilter filter, int offset, int limit) {
        ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
        boolean limitReached = true;
        do {
            List list = this.storage.get(filter, offset, limit);
            notifications.addAll(list);
            limitReached = list.size() < limit || notifications.size() >= limit;
            offset += limit;
        } while (!limitReached);
        return limit > 0 ? notifications.stream().limit(limit).map(this::buildSpaceMuteProperties).toList() : notifications;
    }

    @Deprecated(forRemoval=true, since="1.5.0")
    public String getNotificationMessage(NotificationInfo notification, boolean isOnPopover) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(POPUP_OVER, (Object)isOnPopover);
        return this.getNotificationMessage(ctx, notification);
    }

    public List<String> get(WebNotificationFilter filter, int offset, int limit) {
        List<NotificationInfo> notifications = this.getNotificationInfos(filter, offset, limit);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(POPUP_OVER, (Object)filter.isOnPopover());
        return notifications.stream().map(notification -> this.getNotificationMessage(ctx, (NotificationInfo)notification)).toList();
    }

    public boolean remove(String notificationId) {
        return this.storage.remove(notificationId);
    }

    public void hidePopover(String notificationId) {
        this.storage.hidePopover(notificationId);
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
        WebNotificationSender.sendJsonMessage(userId, new MessageInfo().setNumberOnBadge(0));
    }

    public void resetNumberOnBadge(List<String> plugins, String username) {
        if (CollectionUtils.isEmpty(plugins)) {
            this.resetNumberOnBadge(username);
        } else {
            this.storage.resetNumberOnBadge(plugins, username);
            WebNotificationSender.sendJsonMessage(username, new MessageInfo());
        }
    }

    public int getNumberOnBadge(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("User is mandatory");
        }
        return this.storage.getNumberOnBadge(userId);
    }

    public Map<String, Integer> countUnreadByPlugin(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("User is mandatory");
        }
        return this.storage.countUnreadByPlugin(userId);
    }

    private NotificationInfo buildSpaceMuteProperties(NotificationInfo notification) {
        if (notification.getSpaceId() > 0L) {
            UserSetting userSetting;
            PluginConfig pluginConfig = this.pluginSettingService.getPluginConfig(notification.getKey().getId());
            notification.setMutable(pluginConfig != null && pluginConfig.isMutable());
            if (notification.getTo() != null && (userSetting = this.userSettingService.get(notification.getTo())) != null) {
                notification.setSpaceMuted(userSetting.isSpaceMuted(notification.getSpaceId()));
            }
        }
        return notification;
    }

    private String getNotificationMessage(NotificationContext ctx, NotificationInfo notification) {
        AbstractTemplateBuilder builder = this.webChannel.getTemplateBuilder(notification.getKey());
        if (builder != null) {
            try {
                MessageInfo msg = builder.buildMessage(ctx.setNotificationInfo(notification));
                if (ctx.isFailed()) {
                    LOG.warn("Error while building message for notification with id '{}'", new Object[]{notification.getId(), ctx.getException()});
                } else if (msg != null && msg.getBody() != null && !msg.getBody().isEmpty()) {
                    return msg.getBody();
                }
            }
            catch (Exception e) {
                LOG.error("Error while building message for notification with id '{}'", new Object[]{notification.getId(), e});
            }
        }
        return null;
    }
}

