/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.listener;

import io.meeds.poll.model.Poll;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.PollUtils;
import java.util.Arrays;
import java.util.HashSet;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AnalyticsPollListener
extends Listener<String, Poll> {
    private static final String POLL_ID = "PollId";
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private PollService pollService;

    public void onEvent(Event<String, Poll> event) throws Exception {
        Poll poll = (Poll)event.getData();
        String operation = "";
        if (event.getEventName().equals("meeds.poll.createPoll")) {
            operation = "createPoll";
        } else if (event.getEventName().equals("meeds.poll.votePoll")) {
            operation = "votePoll";
        }
        String userName = (String)event.getSource();
        long userId = 0L;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", userName);
        if (identity != null) {
            userId = Long.parseLong(identity.getId());
        }
        StatisticData statisticData = new StatisticData();
        Space space = this.getSpaceService().getSpaceById(String.valueOf(poll.getSpaceId()));
        statisticData.setModule("Poll");
        statisticData.setSubModule("Poll");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter(POLL_ID, (Object)poll.getId());
        statisticData.addParameter("PollActivityId", (Object)poll.getActivityId());
        statisticData.addParameter("PollOptionsNumber", (Object)this.getPollService().getPollOptionsNumber(poll.getId(), new org.exoplatform.services.security.Identity(userName)));
        statisticData.addParameter("PollDuration", (Object)PollUtils.getPollDuration(poll));
        statisticData.addParameter("PollTotalVotes", (Object)this.getPollService().getPollTotalVotes(poll.getId(), new org.exoplatform.services.security.Identity(userName)));
        statisticData.addParameter("PollSpaceMembersCount", (Object)AnalyticsPollListener.getSize(space.getMembers()));
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    public PollService getPollService() {
        if (this.pollService == null) {
            this.pollService = (PollService)ExoContainerContext.getService(PollService.class);
        }
        return this.pollService;
    }

    private static int getSize(String[] array) {
        return array == null ? 0 : new HashSet<String>(Arrays.asList(array)).size();
    }
}

