/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.entity;

import io.meeds.social.link.entity.LinkSettingEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="SocLink")
@ExoEntity
@Table(name="SOC_LINKS")
@NamedQueries(value={@NamedQuery(name="LinkEntity.findByName", query="SELECT l from SocLink l INNER JOIN l.setting s ON s.name = :name ORDER BY l.order ASC"), @NamedQuery(name="LinkEntity.getLinkSettingByLinkId", query="SELECT l.setting.id from SocLink l WHERE l.id = :id")})
public class LinkEntity
implements Serializable {
    private static final long serialVersionUID = -8563536841046360579L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_LINK_ID", sequenceName="SEQ_SOC_LINK_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_LINK_ID")
    @Column(name="LINK_ID")
    private Long id;
    @Column(name="URL", nullable=false)
    private String url;
    @Column(name="SAME_TAB")
    private boolean sameTab;
    @Column(name="LINK_ORDER")
    private int order;
    @Column(name="ICON_FILE_ID")
    private long iconFileId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="LINK_SETTING_ID", nullable=false)
    private LinkSettingEntity setting;

    public Long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSameTab() {
        return this.sameTab;
    }

    public int getOrder() {
        return this.order;
    }

    public long getIconFileId() {
        return this.iconFileId;
    }

    public LinkSettingEntity getSetting() {
        return this.setting;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSameTab(boolean sameTab) {
        this.sameTab = sameTab;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setIconFileId(long iconFileId) {
        this.iconFileId = iconFileId;
    }

    public void setSetting(LinkSettingEntity setting) {
        this.setting = setting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkEntity)) {
            return false;
        }
        LinkEntity other = (LinkEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSameTab() != other.isSameTab()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.getIconFileId() != other.getIconFileId()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSameTab() ? 79 : 97);
        result = result * 59 + this.getOrder();
        long $iconFileId = this.getIconFileId();
        result = result * 59 + (int)($iconFileId >>> 32 ^ $iconFileId);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "LinkEntity(id=" + this.getId() + ", url=" + this.getUrl() + ", sameTab=" + this.isSameTab() + ", order=" + this.getOrder() + ", iconFileId=" + this.getIconFileId() + ")";
    }

    public LinkEntity() {
    }

    public LinkEntity(Long id, String url, boolean sameTab, int order, long iconFileId, LinkSettingEntity setting) {
        this.id = id;
        this.url = url;
        this.sameTab = sameTab;
        this.order = order;
        this.iconFileId = iconFileId;
        this.setting = setting;
    }
}

