/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.net.media;

import org.gatein.common.net.media.SubtypeDef;
import org.gatein.common.net.media.TypeDef;

public final class MediaType {
    public static final MediaType TEXT_HTML = new MediaType(TypeDef.TEXT, SubtypeDef.HTML);
    public static final MediaType TEXT_JAVASCRIPT = new MediaType(TypeDef.TEXT, SubtypeDef.JAVASCRIPT);
    public static final MediaType TEXT_CSS = new MediaType(TypeDef.TEXT, SubtypeDef.CSS);
    public static final MediaType APPLICATION_X_WWW_FORM_URLENCODED = new MediaType(TypeDef.APPLICATION, SubtypeDef.X_WWW_FORM_URLENCODED);
    public static final MediaType MULTIPART_FORM_DATA_MEDIA_TYPE = new MediaType(TypeDef.MULTIPART, SubtypeDef.FORM_DATA);
    private final TypeDef type;
    private final SubtypeDef subtype;
    private volatile Integer hashCode;
    private volatile String toString;
    private volatile String value;

    public static MediaType create(String mediaTypeName) throws IllegalArgumentException {
        if (mediaTypeName == null) {
            throw new IllegalArgumentException("No null media type value accepted");
        }
        int slashIndex = mediaTypeName.indexOf(47);
        if (slashIndex == -1) {
            throw new IllegalArgumentException("The media type " + mediaTypeName + " does not contain a /");
        }
        String typeName = mediaTypeName.substring(0, slashIndex);
        String subtypeName = mediaTypeName.substring(slashIndex + 1);
        return MediaType.create(typeName, subtypeName);
    }

    public static MediaType create(String typeName, String subtypeName) throws IllegalArgumentException {
        if (typeName == null) {
            throw new IllegalArgumentException("No null type name accepted");
        }
        if (subtypeName == null) {
            throw new IllegalArgumentException("No null subtype name accepted");
        }
        TypeDef type = TypeDef.create(typeName);
        if (type == null) {
            throw new IllegalArgumentException("Type not recognized in content type " + typeName + "/" + subtypeName);
        }
        SubtypeDef subtype = SubtypeDef.create(subtypeName);
        return new MediaType(type, subtype);
    }

    public static MediaType create(TypeDef type, SubtypeDef subtype) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        if (subtype == null) {
            throw new IllegalArgumentException("No null subtype accepted");
        }
        return new MediaType(type, subtype);
    }

    MediaType(TypeDef type, SubtypeDef subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public TypeDef getType() {
        return this.type;
    }

    public SubtypeDef getSubtype() {
        return this.subtype;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.type.getName() + "/" + this.subtype.getName();
        }
        return this.value;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.type.hashCode() + this.subtype.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype);
        }
        return false;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "MediaType[name=" + this.type + ",subtype=" + this.subtype + "]";
        }
        return this.toString;
    }
}

