/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;

public class DefaultRequestHandler
extends WebRequestHandler {
    private final UserPortalConfigService configService;

    public DefaultRequestHandler(UserPortalConfigService configService) {
        this.configService = configService;
    }

    public String getHandlerName() {
        return "default";
    }

    public boolean execute(ControllerContext context) throws Exception {
        String defaultUri = null;
        String currentUser = context.getRequest().getRemoteUser();
        if (StringUtils.isNotBlank((CharSequence)currentUser)) {
            defaultUri = this.configService.getUserHomePage(currentUser);
        }
        if (StringUtils.isBlank(defaultUri) && StringUtils.isBlank((CharSequence)(defaultUri = this.configService.computePortalPath(context.getRequest())))) {
            HttpServletResponse resp = context.getResponse();
            String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
            resp.sendRedirect("/" + currentPortalContainerName + "/login");
            return true;
        }
        HttpServletResponse resp = context.getResponse();
        resp.sendRedirect(resp.encodeRedirectURL(defaultUri));
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

