/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import liquibase.repackaged.org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.TaskUtil;

public class TaskCommentAttachmentPlugin
extends AttachmentPlugin {
    public static final String TASK_COMMENT_OBJECT_TYPE = "taskComment";
    public static final String TASK_COMMENT_NOT_FOUND_EXCEPTION_MESSAGE = "Task comment with id %s wasn't found";
    private TaskService taskService;
    private CommentService commentService;
    private ProjectService projectService;
    private SpaceService spaceService;

    public TaskCommentAttachmentPlugin(TaskService taskService, CommentService commentService, ProjectService projectService, SpaceService spaceService) {
        this.taskService = taskService;
        this.commentService = commentService;
        this.projectService = projectService;
        this.spaceService = spaceService;
    }

    public String getObjectType() {
        return TASK_COMMENT_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            CommentDto comment = this.commentService.getComment(Long.parseLong(entityId));
            return TaskUtil.hasViewPermission(this.taskService, comment.getTask(), userIdentity);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_COMMENT_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        try {
            CommentDto comment = this.commentService.getComment(Long.parseLong(entityId));
            return StringUtils.equals((CharSequence)comment.getAuthor(), (CharSequence)userIdentity.getUserId());
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_COMMENT_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
    }

    public long getAudienceId(String entityId) throws ObjectNotFoundException {
        return this.getSpaceId(entityId);
    }

    public long getSpaceId(String entityId) throws ObjectNotFoundException {
        long spaceId = 0L;
        try {
            Space space;
            CommentDto comment = this.commentService.getComment(Long.parseLong(entityId));
            Space space2 = space = comment == null || comment.getTask().getStatus() == null || comment.getTask().getStatus().getProject() == null ? null : this.getProjectSpace(comment.getTask().getStatus().getProject().getId());
            if (space != null) {
                spaceId = Long.parseLong(space.getId());
            }
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(String.format(TASK_COMMENT_NOT_FOUND_EXCEPTION_MESSAGE, entityId));
        }
        return spaceId;
    }

    private Space getProjectSpace(long projectId) {
        Space space = null;
        for (String permission : this.projectService.getManager(projectId)) {
            int index = permission.indexOf(58);
            if (index <= -1) continue;
            String groupId = permission.substring(index + 1);
            space = this.spaceService.getSpaceByGroupId(groupId);
        }
        return space;
    }
}

