/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gatein.portal.idm.impl.repository.ExoRepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.repository.AbstractIdentityStoreRepository;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class ExoFallbackIdentityStoreRepository
extends AbstractIdentityStoreRepository {
    private static final long serialVersionUID = -4857082329385386057L;
    private String id = null;
    private String externalStoreId = null;
    private IdentityStore externalIdentityStore = null;
    private AttributeStore externalAttributeStore = null;
    private IdentityStoreMappingMetaData externalIdentityStoreMappingMetaData = null;
    private ThreadLocal<Boolean> useExternalStore = new ThreadLocal();
    private FeaturesMetaData featuresMetaData = null;

    public ExoFallbackIdentityStoreRepository(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        IdentityRepositoryConfigurationMetaData configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String defaultStoreId = configurationMD.getDefaultIdentityStoreId();
        if (StringUtils.isBlank((String)defaultStoreId)) {
            throw new IllegalStateException("Default store is not configured");
        }
        Set<String> identityStores = bootstrappedIdentityStores.keySet();
        if (identityStores.contains(defaultStoreId) && identityStores.size() > 2 || !identityStores.contains(defaultStoreId) && identityStores.size() > 1) {
            throw new IllegalStateException("More than 2 store are configured, only two stores at most are supported.");
        }
        if (identityStores.contains(defaultStoreId) && identityStores.size() > 1 || !identityStores.contains(defaultStoreId) && identityStores.size() > 0) {
            for (String storeId : identityStores) {
                if (defaultStoreId.equals(storeId)) continue;
                this.externalStoreId = storeId;
                break;
            }
        }
        if (StringUtils.isNotBlank((String)this.externalStoreId)) {
            this.externalIdentityStore = bootstrappedIdentityStores.get(this.externalStoreId);
            this.externalAttributeStore = bootstrappedAttributeStores.get(this.externalStoreId);
            for (IdentityStoreMappingMetaData mappingMetaData : configurationMD.getIdentityStoreToIdentityObjectTypeMappings()) {
                if (defaultStoreId.equals(mappingMetaData.getIdentityStoreId())) continue;
                this.externalIdentityStoreMappingMetaData = mappingMetaData;
            }
        }
        this.featuresMetaData = new FeaturesMetaData(){

            public boolean isNamedRelationshipsSupported() {
                return ExoFallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported();
            }

            public boolean isRelationshipPropertiesSupported() {
                return ExoFallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipPropertiesSupported();
            }

            public boolean isRelationshipNameAddRemoveSupported() {
                return ExoFallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported();
            }

            public boolean isSearchCriteriaTypeSupported(IdentityObjectType identityObjectType, IdentityObjectSearchCriteriaType storeSearchConstraint) {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isSearchCriteriaTypeSupported(identityObjectType, storeSearchConstraint);
            }

            public Set<String> getSupportedIdentityObjectTypes() {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().getSupportedRelationshipTypes();
            }

            public boolean isIdentityObjectTypeSupported(IdentityObjectType identityObjectType) {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isIdentityObjectTypeSupported(identityObjectType);
            }

            public boolean isRelationshipTypeSupported(IdentityObjectType fromType, IdentityObjectType toType, IdentityObjectRelationshipType relationshipType) throws IdentityException {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
            }

            public Set<String> getSupportedRelationshipTypes() {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().getSupportedRelationshipTypes();
            }

            public boolean isCredentialSupported(IdentityObjectType identityObjectType, IdentityObjectCredentialType credentialType) {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isCredentialSupported(identityObjectType, credentialType);
            }

            public boolean isIdentityObjectAddRemoveSupported(IdentityObjectType objectType) {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
            }

            public boolean isRoleNameSearchCriteriaTypeSupported(IdentityObjectSearchCriteriaType constraint) {
                return ExoFallbackIdentityStoreRepository.this.getIdentityStore().getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
        };
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        sessions.put(this.getAttributeStore().getId(), this.getAttributeStore().createIdentityStoreSession());
        if (!sessions.containsKey(this.getIdentityStore().getId())) {
            sessions.put(this.getIdentityStore().getId(), this.getIdentityStore().createIdentityStoreSession());
        }
        return new ExoRepositoryIdentityStoreSessionImpl(sessions, null);
    }

    private AttributeStore getAttributeStore() {
        if (this.isUseExternalStore()) {
            return this.externalAttributeStore;
        }
        return this.defaultAttributeStore;
    }

    public IdentityStore getIdentityStore() {
        if (this.isUseExternalStore()) {
            return this.externalIdentityStore;
        }
        return this.defaultIdentityStore;
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        sessions.put(this.getAttributeStore().getId(), this.getAttributeStore().createIdentityStoreSession(sessionOptions));
        if (!sessions.containsKey(this.getIdentityStore().getId())) {
            sessions.put(this.getIdentityStore().getId(), this.getIdentityStore().createIdentityStoreSession(sessionOptions));
        }
        return new ExoRepositoryIdentityStoreSessionImpl(sessions, sessionOptions);
    }

    IdentityStoreInvocationContext resolveIdentityStoreInvocationContext(IdentityStoreInvocationContext invocationCtx) throws IdentityException {
        return this.resolveInvocationContext(this.getIdentityStore().getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveAttributeStoreInvocationContext(IdentityStoreInvocationContext invocationCtx) throws IdentityException {
        return this.resolveInvocationContext(this.getAttributeStore().getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) throws IdentityException {
        ExoRepositoryIdentityStoreSessionImpl repoSession = (ExoRepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        if (targetSession == null && this.isUseExternalStore()) {
            targetSession = this.getIdentityStore().createIdentityStoreSession(repoSession.getSessionOptions());
            repoSession.addIdentityStoreSessionMapping(this.getIdentityStore().getId(), targetSession);
        }
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId(), String.valueOf(((Object)((Object)this)).hashCode()));
    }

    public String getId() {
        return this.id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.featuresMetaData;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.getIdentityStore().createIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), name, identityObjectType);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        return this.getIdentityStore().createIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), name, identityObjectType, attributes);
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        this.getIdentityStore().removeIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity);
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        return this.getIdentityStore().getIdentityObjectsCount(this.resolveIdentityStoreInvocationContext(invocationCtx), identityType);
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.getIdentityStore().findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationContext), name, identityObjectType);
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        return this.getIdentityStore().findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationContext), id);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identityType, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().getIdentityObjectCount(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, parent, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().getIdentityObjectCount(this.resolveIdentityStoreInvocationContext(ctx), identity, relationshipType, excludes, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, excludes, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().findIdentityObject(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, parent, criteria);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        return this.getIdentityStore().createRelationship(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        this.getIdentityStore().removeRelationship(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType, relationshipName);
    }

    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        this.getIdentityStore().removeRelationships(this.resolveIdentityStoreInvocationContext(invocationCtx), identity1, identity2, named);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        return this.getIdentityStore().resolveRelationships(this.resolveIdentityStoreInvocationContext(invocationCxt), fromIdentity, toIdentity, relationshipType);
    }

    public int getRelationshipsCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        return this.getIdentityStore().getRelationshipsCount(this.resolveIdentityStoreInvocationContext(ctx), identity, type, parent, named, name, searchCriteria);
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityStore().resolveRelationships(this.resolveIdentityStoreInvocationContext(invocationCtx), identity, relationshipType, parent, named, name, criteria);
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().createRelationshipName(this.resolveIdentityStoreInvocationContext(ctx), name);
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().removeRelationshipName(this.resolveIdentityStoreInvocationContext(ctx), name);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().getRelationshipNames(this.resolveIdentityStoreInvocationContext(ctx), criteria);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().getRelationshipNames(this.resolveIdentityStoreInvocationContext(ctx), identity, criteria);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().getRelationshipNameProperties(this.resolveAttributeStoreInvocationContext(ctx), name);
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.getIdentityStore().setRelationshipNameProperties(this.resolveIdentityStoreInvocationContext(ctx), name, properties);
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.getIdentityStore().removeRelationshipNameProperties(this.resolveIdentityStoreInvocationContext(ctx), name, properties);
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        return this.getIdentityStore().getRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship);
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        this.getIdentityStore().setRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship, properties);
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        this.getIdentityStore().removeRelationshipProperties(this.resolveIdentityStoreInvocationContext(ctx), relationship, properties);
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        return this.getIdentityStore().validateCredential(this.resolveIdentityStoreInvocationContext(ctx), identityObject, credential);
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        this.getIdentityStore().updateCredential(this.resolveIdentityStoreInvocationContext(ctx), identityObject, credential);
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return this.getAttributeStore().getSupportedAttributeNames(this.resolveAttributeStoreInvocationContext(invocationContext), identityType);
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        try {
            return this.getAttributeStore().getAttributesMetaData(this.resolveAttributeStoreInvocationContext(invocationContext), identityType);
        }
        catch (IdentityException e) {
            throw new RuntimeException("Error while retrieving data from store", e);
        }
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        return this.getAttributeStore().getAttributes(this.resolveAttributeStoreInvocationContext(invocationContext), identity);
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        return this.getAttributeStore().getAttribute(this.resolveAttributeStoreInvocationContext(invocationContext), identity, name);
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.getAttributeStore().updateAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributes);
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.getAttributeStore().addAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributes);
    }

    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        this.getAttributeStore().removeAttributes(this.resolveAttributeStoreInvocationContext(invocationCtx), identity, attributeNames);
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        return this.getAttributeStore().findIdentityObjectByUniqueAttribute(this.resolveAttributeStoreInvocationContext(invocationCtx), identityObjectType, attribute);
    }

    public String getExternalStoreId() {
        return this.externalStoreId;
    }

    public IdentityStore getExternalIdentityStore() {
        return this.externalIdentityStore;
    }

    public IdentityStore getDefaultIdentityStore() {
        return this.defaultIdentityStore;
    }

    public AttributeStore getExternalAttributeStore() {
        return this.externalAttributeStore;
    }

    public IdentityStoreMappingMetaData getExternalIdentityStoreMappingMetaData() {
        return this.externalIdentityStoreMappingMetaData;
    }

    public void setUseExternalStore(Boolean useExternalStore) {
        this.useExternalStore.set(useExternalStore);
    }

    public boolean isUseExternalStore() {
        Boolean isUseExternalStore = this.useExternalStore.get();
        return isUseExternalStore != null && isUseExternalStore != false;
    }

    public boolean hasExternalStore() {
        return this.externalIdentityStore != null;
    }
}

