/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.registry;

import io.meeds.oauth.registry.OauthProviderTypeRegistryPlugin;
import io.meeds.oauth.spi.AccessTokenContext;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OAuthProviderTypeRegistryImpl
implements OAuthProviderTypeRegistry {
    private final Map<String, OAuthProviderType> oauthProviderTypes = new LinkedHashMap<String, OAuthProviderType>();
    private static final Log log = ExoLogger.getLogger(OAuthProviderTypeRegistryImpl.class);

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof OauthProviderTypeRegistryPlugin) {
            OauthProviderTypeRegistryPlugin oauthPlugin = (OauthProviderTypeRegistryPlugin)plugin;
            OAuthProviderType oauthPrType = oauthPlugin.getOAuthProviderType();
            if (oauthPrType != null && oauthPrType.isEnabled()) {
                this.oauthProviderTypes.put(oauthPrType.getKey(), oauthPrType);
                log.debug((Object)("Added new OAuthProviderType " + oauthPrType));
            } else {
                log.debug("Skip OAuthProviderType {} because it's disabled", new Object[]{oauthPlugin.getName()});
            }
        } else {
            throw new RuntimeException("Invalid plugin type: " + plugin.getClass() + ", plugin: " + plugin);
        }
    }

    @Override
    public <T extends AccessTokenContext> OAuthProviderType<T> getOAuthProvider(String key, Class<T> accessTokenContextClass) {
        return this.oauthProviderTypes.get(key);
    }

    @Override
    public Collection<OAuthProviderType> getEnabledOAuthProviders() {
        return Collections.unmodifiableCollection(this.oauthProviderTypes.values());
    }

    @Override
    public boolean isOAuthEnabled() {
        return !this.oauthProviderTypes.isEmpty();
    }
}

