/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.entity.ConnectorAccountEntity;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class ConnectorAccountDAO
extends GenericDAOJPAImpl<ConnectorAccountEntity, Long> {
    public static final String CONNECTOR_NAME = "connectorName";
    public static final String USER_IDENTITY_ID = "userId";
    public static final String REMOTE_ID = "remoteId";

    public ConnectorAccountEntity getConnectorAccountByNameAndUserId(String connectorName, long userIdentityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationConnectorAccount.getConnectorAccountByNameAndUserId", ConnectorAccountEntity.class);
        query.setParameter(CONNECTOR_NAME, (Object)connectorName);
        query.setParameter(USER_IDENTITY_ID, (Object)userIdentityId);
        query.setMaxResults(1);
        try {
            return (ConnectorAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ConnectorAccountEntity getConnectorAccountByNameAndRemoteId(String connectorName, String connectorRemoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationConnectorAccount.getConnectorAccountByNameAndRemoteId", ConnectorAccountEntity.class);
        query.setParameter(CONNECTOR_NAME, (Object)connectorName);
        query.setParameter(REMOTE_ID, (Object)connectorRemoteId);
        query.setMaxResults(1);
        try {
            return (ConnectorAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public String getConnectorRemoteId(String connectorName, long userIdentityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationConnectorAccount.getConnectorRemoteId", String.class);
        query.setParameter(CONNECTOR_NAME, (Object)connectorName);
        query.setParameter(USER_IDENTITY_ID, (Object)userIdentityId);
        query.setMaxResults(1);
        try {
            return (String)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public long getAssociatedUserIdentityId(String connectorName, String connectorRemoteId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationConnectorAccount.getAssociatedUserIdentityId", Long.class);
        query.setParameter(CONNECTOR_NAME, (Object)connectorName);
        query.setParameter(REMOTE_ID, (Object)connectorRemoteId);
        query.setMaxResults(1);
        try {
            Long result = (Long)query.getSingleResult();
            return result == null ? 0L : result;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }
}

