/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.MBeanServer;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreator;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreatorPlugin;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheFactoryConfigPlugin;
import org.exoplatform.services.cache.impl.infinispan.distributed.DistributedExoCache;
import org.exoplatform.services.cache.impl.infinispan.generic.GenericExoCacheCreator;
import org.exoplatform.services.ispn.DistributedCacheManager;
import org.exoplatform.services.ispn.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.picocontainer.Startable;

public class ExoCacheFactoryImpl
implements ExoCacheFactory,
Startable {
    private static final Log LOG = ExoLogger.getLogger(ExoCacheFactoryImpl.class);
    private static final String CACHE_CONFIG_TEMPLATE_KEY = "cache.config.template";
    private static final String CACHE_ASYNC_TEMPLATE_KEY = "cache.async.config.template";
    private final DistributedCacheManager distributedCacheManager;
    private final ExoContainerContext ctx;
    private final ConfigurationManager configManager;
    private final DefaultCacheManager cacheManager;
    private DefaultCacheManager asyncCacheManager = null;
    private final Map<Class<? extends ExoCacheConfig>, ExoCacheCreator> mappingConfigTypeCreators = new HashMap<Class<? extends ExoCacheConfig>, ExoCacheCreator>();
    private final Map<String, ExoCacheCreator> mappingImplCreators = new HashMap<String, ExoCacheCreator>();
    private final Map<String, String> mappingCacheNameConfig = new HashMap<String, String>();
    private final String asyncCacheTemplate;
    private final Map<String, DefaultCacheManager> mappingGlobalConfigCacheManager = new HashMap<String, DefaultCacheManager>();
    private final ExoCacheCreator defaultCreator = new GenericExoCacheCreator();
    private static final MBeanServerLookup MBEAN_SERVER_LOOKUP = new MBeanServerLookup(){

        public MBeanServer getMBeanServer(Properties properties) {
            return ExoContainerContext.getTopContainer().getMBeanServer();
        }
    };

    public ExoCacheFactoryImpl(ExoContainerContext ctx, InitParams params, ConfigurationManager configManager) throws ExoCacheInitException {
        this(ctx, ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY), ExoCacheFactoryImpl.getValueParam(params, CACHE_ASYNC_TEMPLATE_KEY), configManager, null);
    }

    public ExoCacheFactoryImpl(ExoContainerContext ctx, InitParams params, ConfigurationManager configManager, DistributedCacheManager dcm) throws ExoCacheInitException {
        this(ctx, ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY), ExoCacheFactoryImpl.getValueParam(params, CACHE_ASYNC_TEMPLATE_KEY), configManager, dcm);
    }

    public ExoCacheFactoryImpl(ExoContainerContext ctx, String cacheConfigTemplate, String cacheAsyncConfigTemplate, ConfigurationManager configManager, DistributedCacheManager dcm) throws ExoCacheInitException {
        this.distributedCacheManager = dcm;
        this.ctx = ctx;
        this.configManager = configManager;
        if (cacheConfigTemplate == null) {
            throw new IllegalArgumentException("The parameter 'cache.config.template' must be set");
        }
        this.cacheManager = this.initCacheManager(cacheConfigTemplate);
        this.asyncCacheTemplate = cacheAsyncConfigTemplate;
    }

    private DefaultCacheManager initCacheManager(final String cacheConfigTemplate) throws ExoCacheInitException {
        try {
            return (DefaultCacheManager)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<DefaultCacheManager>(){

                @Override
                public DefaultCacheManager run() throws Exception {
                    DefaultCacheManager cacheManager;
                    Configuration config;
                    GlobalConfigurationBuilder configBuilder;
                    InputStream is = null;
                    try {
                        is = ExoCacheFactoryImpl.this.configManager.getInputStream(cacheConfigTemplate);
                    }
                    catch (Exception e) {
                        throw new ExoCacheInitException("The configuration of the CacheManager cannot be loaded from '" + cacheConfigTemplate + "'", (Throwable)e);
                    }
                    if (is == null) {
                        throw new ExoCacheInitException("The configuration of the CacheManager cannot be found at '" + cacheConfigTemplate + "'");
                    }
                    try {
                        ParserRegistry parser = new ParserRegistry(Thread.currentThread().getContextClassLoader());
                        ConfigurationBuilderHolder holder = parser.parse(is);
                        configBuilder = holder.getGlobalConfigurationBuilder();
                        config = holder.getDefaultConfigurationBuilder().build();
                    }
                    catch (RuntimeException e) {
                        throw new ExoCacheInitException("Cannot parse the configuration '" + cacheConfigTemplate + "'", (Throwable)e);
                    }
                    ExoCacheFactoryImpl.this.configureCacheManager(configBuilder);
                    try {
                        cacheManager = new DefaultCacheManager(configBuilder.build(), config);
                    }
                    catch (RuntimeException e) {
                        throw new ExoCacheInitException("Cannot initialize the CacheManager corresponding to the configuration '" + cacheConfigTemplate + "'", (Throwable)e);
                    }
                    ExoCacheFactoryImpl.this.mappingGlobalConfigCacheManager.put(cacheManager.getCacheManagerConfiguration().transport().clusterName(), cacheManager);
                    return cacheManager;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExoCacheInitException) {
                throw (ExoCacheInitException)cause;
            }
            throw new ExoCacheInitException((Throwable)e);
        }
    }

    private void configureCacheManager(GlobalConfigurationBuilder configBuilder) throws ExoCacheInitException {
        GlobalConfiguration config = configBuilder.build();
        this.configureJGroups(config, configBuilder);
        configBuilder.globalJmxStatistics().enable().cacheManagerName(config.globalJmxStatistics().cacheManagerName() + "_" + this.ctx.getName()).mBeanServerLookup(MBEAN_SERVER_LOOKUP);
    }

    private void configureJGroups(GlobalConfiguration config, GlobalConfigurationBuilder configBuilder) throws ExoCacheInitException {
        if (this.loadJGroupsConfig(config, configBuilder)) {
            configBuilder.transport().clusterName(config.transport().clusterName() + "-" + this.ctx.getName());
        }
    }

    private boolean loadJGroupsConfig(GlobalConfiguration config, GlobalConfigurationBuilder configBuilder) throws ExoCacheInitException {
        return Utils.loadJGroupsConfig(this.configManager, config, configBuilder);
    }

    public ExoCache<Serializable, Object> createCache(ExoCacheConfig config) throws ExoCacheInitException {
        ExoCache<Serializable, Object> eXoCache;
        final String region = config.getName();
        String CacheConfig = this.mappingCacheNameConfig.get(region);
        if (CacheConfig == null && config.isAsync() && this.asyncCacheTemplate != null && this.asyncCacheManager == null) {
            this.asyncCacheManager = this.initCacheManager(this.asyncCacheTemplate);
        }
        final String customConfig = CacheConfig;
        try {
            DefaultCacheManager cacheManager;
            final ConfigurationBuilder confBuilder = new ConfigurationBuilder();
            if (customConfig != null) {
                try {
                    cacheManager = (DefaultCacheManager)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<DefaultCacheManager>(){

                        @Override
                        public DefaultCacheManager run() throws Exception {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("A custom configuration has been set for the cache '" + region + "'."));
                            }
                            ParserRegistry parser = new ParserRegistry(Thread.currentThread().getContextClassLoader());
                            ConfigurationBuilderHolder holder = parser.parse(ExoCacheFactoryImpl.this.configManager.getInputStream(customConfig));
                            GlobalConfigurationBuilder configBuilder = holder.getGlobalConfigurationBuilder();
                            ExoCacheFactoryImpl.this.configureCacheManager(configBuilder);
                            GlobalConfiguration gc = configBuilder.build();
                            DefaultCacheManager currentCacheManager = ExoCacheFactoryImpl.this.mappingGlobalConfigCacheManager.get(gc.transport().clusterName());
                            if (currentCacheManager == null) {
                                configBuilder.globalJmxStatistics().cacheManagerName(gc.globalJmxStatistics().cacheManagerName() + "_" + region + "_" + ExoCacheFactoryImpl.this.ctx.getName());
                                currentCacheManager = new DefaultCacheManager(configBuilder.build(), holder.getDefaultConfigurationBuilder().build(), false);
                                for (Map.Entry entry : holder.getNamedConfigurationBuilders().entrySet()) {
                                    currentCacheManager.defineConfiguration((String)entry.getKey(), ((ConfigurationBuilder)entry.getValue()).build());
                                }
                                currentCacheManager.start();
                                ExoCacheFactoryImpl.this.mappingGlobalConfigCacheManager.put(gc.transport().clusterName(), currentCacheManager);
                            }
                            return currentCacheManager;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw new Exception(e);
                }
                confBuilder.read(cacheManager.getDefaultCacheConfiguration());
            } else {
                if (config.isDistributed()) {
                    if (this.distributedCacheManager == null) {
                        throw new IllegalArgumentException("The DistributedCacheManager has not been defined in the configuration, please configure it at root container level if you want to use a distributed cache.");
                    }
                    return new DistributedExoCache<Serializable, Object>(this.ctx, config, this.distributedCacheManager.getCache("eXoCache"));
                }
                DefaultCacheManager defaultCacheManager = cacheManager = config.isAsync() && this.asyncCacheManager != null ? this.asyncCacheManager : this.cacheManager;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The configuration template will be used for the cache '" + region + "'."));
                }
                confBuilder.read(cacheManager.getDefaultCacheConfiguration());
                if (!config.isRepicated()) {
                    confBuilder.clustering().cacheMode(CacheMode.LOCAL);
                }
            }
            this.resetConfiguration(confBuilder);
            ExoCacheCreator creator = this.getExoCacheCreator(config);
            eXoCache = creator.create(config, confBuilder, new Callable<Cache<Serializable, Object>>(){

                @Override
                public Cache<Serializable, Object> call() throws Exception {
                    try {
                        return (Cache)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Cache<Serializable, Object>>(){

                            @Override
                            public Cache<Serializable, Object> run() throws Exception {
                                cacheManager.defineConfiguration(region, confBuilder.build());
                                return cacheManager.getCache(region);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)cause;
                        }
                        throw new Exception(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The cache '" + region + "' could not be initialized", (Throwable)e);
        }
        return eXoCache;
    }

    public void addCreator(ExoCacheCreatorPlugin plugin) {
        List<ExoCacheCreator> creators = plugin.getCreators();
        for (ExoCacheCreator creator : creators) {
            this.mappingConfigTypeCreators.put(creator.getExpectedConfigType(), creator);
            Set<String> implementations = creator.getExpectedImplementations();
            if (implementations == null) {
                throw new IllegalArgumentException("The set of implementations cannot be null");
            }
            for (String imp : implementations) {
                this.mappingImplCreators.put(imp, creator);
            }
        }
    }

    public void addConfig(ExoCacheFactoryConfigPlugin plugin) {
        Map<String, String> configs = plugin.getConfigs();
        this.mappingCacheNameConfig.putAll(configs);
    }

    public void start() {
    }

    public void stop() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    private static String getValueParam(InitParams params, String key) {
        String result;
        if (params == null) {
            return null;
        }
        ValueParam vp = params.getValueParam(key);
        if (vp == null || (result = vp.getValue()) == null || (result = result.trim()).length() == 0) {
            return null;
        }
        return result;
    }

    protected ExoCacheCreator getExoCacheCreator(ExoCacheConfig config) {
        ExoCacheCreator creator = this.mappingConfigTypeCreators.get(config.getClass());
        if (creator == null && (creator = this.mappingImplCreators.get(config.getImplementation())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No cache creator has been found for the cache '" + config.getName() + "', the default one will be used."));
            }
            return this.defaultCreator;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The cache '" + config.getName() + "' will be created with '" + String.valueOf(creator.getClass()) + "'."));
        }
        return creator;
    }

    protected void resetConfiguration(ConfigurationBuilder confBuilder) {
        confBuilder.eviction().strategy(EvictionStrategy.NONE).size(-1L).expiration().lifespan(-1L).maxIdle(-1L).wakeUpInterval(60000L);
    }
}

