/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.TopExoContainer;
import org.exoplatform.container.TopExoContainerListener;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="container", value="standalone")})
@RESTEndpoint(path="scontainer")
public class StandaloneContainer
extends ExoContainer
implements TopExoContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.StandaloneContainer");
    private static final long serialVersionUID = 12L;
    private static volatile StandaloneContainer container;
    private static volatile URL configurationURL;
    private static boolean useDefault;
    private final List<TopExoContainerListener> listeners = new CopyOnWriteArrayList<TopExoContainerListener>();
    private ConfigurationManagerImpl configurationManager;

    private StandaloneContainer(ClassLoader configClassLoader) {
        this.configurationManager = new ConfigurationManagerImpl(configClassLoader, ExoContainer.getProfilesFromProperty());
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                StandaloneContainer.this.registerComponentInstance(ConfigurationManager.class, StandaloneContainer.this.configurationManager);
                new PropertyConfigurator(StandaloneContainer.this.configurationManager);
                return null;
            }
        });
    }

    public static StandaloneContainer getInstance() throws Exception {
        return StandaloneContainer.getInstance(null, null);
    }

    public static StandaloneContainer getInstance(ClassLoader configClassLoader) throws Exception {
        return StandaloneContainer.getInstance(configClassLoader, null);
    }

    public static StandaloneContainer getInstance(Object[][] components) throws Exception {
        return StandaloneContainer.getInstance(null, components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandaloneContainer getInstance(ClassLoader configClassLoader, Object[][] components) throws Exception {
        if (container != null) return container;
        Class<StandaloneContainer> clazz = StandaloneContainer.class;
        synchronized (StandaloneContainer.class) {
            if (container != null) return container;
            container = StandaloneContainer.createNStartContainer(configClassLoader, components);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return container;
        }
    }

    private static StandaloneContainer createNStartContainer(ClassLoader configClassLoader, Object[][] components) throws Exception, MalformedURLException, ConfigurationException {
        final StandaloneContainer container = new StandaloneContainer(configClassLoader);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExoContainerContext.setTopContainer(container);
                return null;
            }
        });
        if (useDefault) {
            container.initDefaultConf();
        }
        StandaloneContainer.initConfigurationURL(configClassLoader);
        container.populate(configurationURL);
        if (components != null) {
            container.registerArray(components);
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                container.start(true);
                return null;
            }
        });
        PrivilegedSystemHelper.setProperty((String)"exo.standalone-container", (String)StandaloneContainer.class.getName());
        LOG.info((Object)("StandaloneContainer initialized using:  " + String.valueOf(configurationURL)));
        container.onStartupComplete();
        return container;
    }

    @Override
    protected void initContainerInternal() {
    }

    private void onStartupComplete() {
        if (!this.listeners.isEmpty()) {
            for (TopExoContainerListener listener : this.listeners) {
                listener.onStartupComplete();
            }
        }
    }

    protected void registerArray(Object[][] components) {
        for (Object[] comp : components) {
            if (comp.length != 2 || comp[0] == null || comp[1] == null || !comp[0].getClass().getName().equals(String.class.getName())) continue;
            String n = (String)comp[0];
            Object o = comp[1];
            container.registerComponentInstance(n, o);
            LOG.info((Object)("StandaloneContainer: injecting \"" + n + "\""));
        }
    }

    public static void addConfigurationURL(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            return;
        }
        URL confURL = new URL(url);
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public static void setConfigurationURL(String url) throws MalformedURLException {
        useDefault = false;
        StandaloneContainer.addConfigurationURL(url);
    }

    public static void addConfigurationPath(final String path) throws MalformedURLException {
        if (path == null || path.length() == 0) {
            return;
        }
        URL confURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws Exception {
                return new File(path).toURI().toURL();
            }
        });
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public static void setConfigurationPath(String path) throws MalformedURLException {
        useDefault = false;
        StandaloneContainer.addConfigurationPath(path);
    }

    public URL getConfigurationURL() {
        return configurationURL;
    }

    @Managed
    @ManagedDescription(value="The configuration of the container in XML format.")
    public String getConfigurationXML() {
        Configuration config = this.getConfiguration();
        if (config == null) {
            LOG.warn((Object)"The configuration of the StandaloneContainer could not be found");
            return null;
        }
        return config.toXML();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
        container = null;
    }

    private static boolean fileExists(final URL url) {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    url.openStream().close();
                    return null;
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initConfigurationURL(ClassLoader configClassLoader) throws MalformedURLException, ConfigurationException {
        if (configurationURL != null) return;
        Class<StandaloneContainer> clazz = StandaloneContainer.class;
        synchronized (StandaloneContainer.class) {
            if (configurationURL != null) return;
            configurationURL = StandaloneContainer.getConfigurationURL(configClassLoader);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static URL getConfigurationURL(ClassLoader configClassLoader) throws MalformedURLException {
        final J2EEServerInfo env = new J2EEServerInfo();
        URL configurationURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws Exception {
                return new File(env.getServerHome() + "/exo-configuration.xml").toURI().toURL();
            }
        });
        if (!StandaloneContainer.fileExists(configurationURL)) {
            configurationURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return new File(env.getExoConfigurationDirectory() + "/exo-configuration.xml").toURI().toURL();
                }
            });
        }
        if (!StandaloneContainer.fileExists(configurationURL) && configClassLoader != null) {
            configurationURL = configClassLoader.getResource("conf/exo-configuration.xml");
        }
        return configurationURL;
    }

    private void initDefaultConf() throws Exception {
        block2: {
            this.configurationManager.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
            this.configurationManager.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            try {
                this.configurationManager.addConfiguration("war:/conf/configuration.xml");
            }
            catch (Exception ex) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ex.getMessage()));
            }
        }
    }

    private void populate(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerUtil.addComponents(StandaloneContainer.this, StandaloneContainer.this.configurationManager);
                return null;
            }
        });
    }

    @Override
    public void addListener(TopExoContainerListener listener) {
        this.listeners.add(listener);
    }

    static {
        configurationURL = null;
        useDefault = true;
    }
}

