/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ar.Archive;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationUnmarshaller;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    public static final String WAR_CONF_LOCATION = "/WEB-INF";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ConfigurationManagerImpl");
    protected Configuration configurations_;
    private ServletContext scontext_;
    private ClassLoader scontextClassLoader_;
    private String contextPath;
    private boolean validateSchema = true;
    private boolean logEnabled = true;
    private final Set<String> profiles;
    private static final ThreadLocal<URL> currentURL = new ThreadLocal();

    public static URL getCurrentURL() {
        return currentURL.get();
    }

    public ConfigurationManagerImpl() {
        this.profiles = Collections.emptySet();
    }

    public ConfigurationManagerImpl(Set<String> profiles) {
        this.profiles = profiles;
    }

    public ConfigurationManagerImpl(Set<String> profiles, boolean logEnabled) {
        this(profiles);
        this.logEnabled = logEnabled;
    }

    public ConfigurationManagerImpl(ServletContext context, Set<String> profiles) {
        this.scontext_ = context;
        this.profiles = profiles;
    }

    public ConfigurationManagerImpl(ClassLoader loader, Set<String> profiles) {
        this.scontextClassLoader_ = loader;
        this.profiles = profiles;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurations_;
    }

    @Override
    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void addConfiguration(ServletContext context, String url) throws Exception {
        if (url == null) {
            return;
        }
        this.addConfiguration(context, this.getURL(context, url));
    }

    @Override
    public void addConfiguration(String url) throws Exception {
        if (url == null) {
            return;
        }
        this.addConfiguration(this.getURL(url));
    }

    @Override
    public void addConfiguration(Collection<URL> urls) {
        for (URL url : urls) {
            this.addConfiguration(url);
        }
    }

    @Override
    public void addConfiguration(URL url) {
        this.addConfiguration(this.scontext_, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfiguration(ServletContext context, URL url) {
        if (url == null) {
            return;
        }
        if (this.logEnabled && LOG_DEBUG) {
            LOG.info((Object)("Add configuration " + String.valueOf(url)));
        }
        try {
            this.contextPath = new File(url.toString()).getParent() + "/";
            this.contextPath = this.contextPath.replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            this.contextPath = null;
        }
        if (currentURL.get() != null) {
            throw new IllegalStateException("Would not expect that");
        }
        currentURL.set(url);
        try {
            ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller(this.profiles);
            Configuration conf = unmarshaller.unmarshall(url);
            if (this.configurations_ == null) {
                this.configurations_ = conf;
            } else {
                this.configurations_.mergeConfiguration(conf);
            }
            this.importConf(unmarshaller, conf);
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot process the configuration " + String.valueOf(currentURL.get())), (Throwable)ex);
        }
        finally {
            currentURL.set(null);
        }
    }

    private void importConf(ConfigurationUnmarshaller unmarshaller, Configuration conf) throws Exception {
        this.importConf(unmarshaller, conf, 1);
    }

    private void importConf(ConfigurationUnmarshaller unmarshaller, Configuration conf, int depth) throws Exception {
        List<String> urls = conf.getImports();
        if (urls != null) {
            int i;
            StringBuilder prefix = new StringBuilder(depth);
            for (i = 0; i < depth; ++i) {
                prefix.append('\t');
            }
            for (i = 0; i < urls.size(); ++i) {
                String uri = urls.get(i);
                URL urlObject = this.getURL(uri);
                if (urlObject != null) {
                    if (this.logEnabled && LOG_DEBUG) {
                        LOG.info((Object)(String.valueOf(prefix) + "import " + String.valueOf(urlObject)));
                    }
                    currentURL.set(urlObject);
                    conf = unmarshaller.unmarshall(urlObject);
                    this.configurations_.mergeConfiguration(conf);
                    this.importConf(unmarshaller, conf, depth + 1);
                    continue;
                }
                LOG.warn((Object)("Couldn't process the URL for " + uri + " configuration file ignored "));
            }
        }
    }

    public void processRemoveConfiguration() {
        if (this.configurations_ == null) {
            return;
        }
        List<String> list = this.configurations_.getRemoveConfiguration();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String type = list.get(i);
                this.configurations_.removeConfiguration(type);
            }
        }
    }

    @Override
    public Component getComponent(String service) {
        return this.configurations_.getComponent(service);
    }

    @Override
    public Component getComponent(Class<?> clazz) {
        return this.configurations_.getComponent(clazz.getName());
    }

    @Override
    public Collection<Component> getComponents() {
        if (this.configurations_ == null) {
            return null;
        }
        return this.configurations_.getComponents();
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    @Override
    public URL getResource(String url, String defaultURL) throws Exception {
        if (url == null) {
            url = defaultURL;
        }
        return this.getResource(url);
    }

    @Override
    public URL getResource(String uri) throws Exception {
        return this.getURL(uri);
    }

    @Override
    public InputStream getInputStream(String url, String defaultURL) throws Exception {
        if (url == null) {
            url = defaultURL;
        }
        return this.getInputStream(url);
    }

    @Override
    public InputStream getInputStream(String uri) throws Exception {
        final URL url = this.getURL(uri);
        if (url == null) {
            throw new IOException("Resource (" + uri + ") could not be found or the invoker doesn't have adequate privileges to get the resource");
        }
        return (InputStream)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws Exception {
                return url.openStream();
            }
        });
    }

    @Override
    public URL getURL(String url) throws Exception {
        return this.getURL(this.scontext_, url);
    }

    private URL getURL(final ServletContext context, String url) throws Exception {
        if (url == null) {
            return null;
        }
        if (url.startsWith("jar:")) {
            String path = this.removePrefix("jar:", url);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            final String finalPath = path;
            return (URL)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return cl.getResource(finalPath);
                }
            });
        }
        if (url.startsWith("classpath:")) {
            String path = this.removePrefix("classpath:", url);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            final ClassLoader cl = Thread.currentThread().getContextClassLoader();
            final String finalPath = path;
            return (URL)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return cl.getResource(finalPath);
                }
            });
        }
        if (url.startsWith("war:")) {
            String path = this.removePrefix("war:", url);
            if (context != null) {
                final String fPath = path;
                return (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws Exception {
                        return context.getResource(ConfigurationManagerImpl.WAR_CONF_LOCATION + fPath);
                    }
                });
            }
            if (this.scontextClassLoader_ != null) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                final String fPath = path;
                return (URL)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        return ConfigurationManagerImpl.this.scontextClassLoader_.getResource(fPath);
                    }
                });
            }
            throw new Exception("unsupport war uri in this configuration service");
        }
        if (url.startsWith("file:")) {
            url = this.resolveFileURL(url);
            return new URL(url);
        }
        if (Archive.isArchiveURL(url)) {
            return Archive.createArchiveURL(url);
        }
        if (url.indexOf(":") < 0 && this.contextPath != null) {
            if (Archive.isArchiveURL(this.contextPath)) {
                return Archive.createArchiveURL(this.contextPath + url.replace('\\', '/'));
            }
            return new URL(this.contextPath + url.replace('\\', '/'));
        }
        return null;
    }

    private String resolveFileURL(String url) {
        url = Deserializer.resolveVariables((String)url);
        if (!((String)(url = ((String)url).replace('\\', '/'))).startsWith("file:///")) {
            url = ((String)url).startsWith("file://") ? "file:///" + ((String)url).substring(7) : (((String)url).startsWith("file:/") ? "file:///" + ((String)url).substring(6) : "file:///" + ((String)url).substring(5));
        }
        return url;
    }

    protected String removePrefix(String prefix, String url) {
        return url.substring(prefix.length(), url.length());
    }
}

