/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.utils;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCUtils {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.JDBCUtils");
    public static final String SQL_DELIMITER = ";";
    public static final String SQL_DELIMITER_COMMENT_PREFIX = "/*$DELIMITER:";
    public static final String SQL_DELIMITER_COMMENT_SUFFIX = "*/";

    private JDBCUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String tableName, Connection con) {
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String dialect = DialectDetecter.detect(con.getMetaData());
            String query = dialect.startsWith("MYSQL") || dialect.startsWith("PGSQL") ? "SELECT count(*) from (SELECT 1 FROM " + tableName + " LIMIT 1) T" : (dialect.startsWith("ORACLE") ? "SELECT count(*) from (SELECT 1 FROM " + tableName + " WHERE ROWNUM = 1) T" : (dialect.startsWith("DB2") || dialect.startsWith("DERBY") || dialect.startsWith("INGRES") ? "SELECT count(*) from (SELECT 1 FROM " + tableName + " FETCH FIRST 1 ROWS ONLY) T" : (dialect.startsWith("MSSQL") ? "SELECT count(*) from (SELECT TOP (1) 1 as C FROM " + tableName + ") T" : (dialect.startsWith("SYBASE") ? "SELECT count(*) from (SELECT TOP 1 1 FROM " + tableName + ") T" : "SELECT count(*) FROM " + tableName))));
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            boolean bl = trs.next();
            JDBCUtils.freeResources(trs, stmt, null);
            return bl;
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SQLException occurs while checking the table " + tableName), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JDBCUtils.freeResources(trs, stmt, null);
        }
    }

    public static String getFullMessage(SQLException exception) {
        StringBuilder errorTrace = new StringBuilder(exception.getMessage());
        for (SQLException next = exception; next != null; next = next.getNextException()) {
            errorTrace.append("; ");
            errorTrace.append(next.getMessage());
        }
        Throwable cause = exception.getCause();
        return String.valueOf(errorTrace) + (String)(cause != null ? " (Cause: " + cause.getMessage() + ")" : "");
    }

    public static String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }

    public static String[] splitWithSQLDelimiter(String resource) {
        if (resource.startsWith(SQL_DELIMITER_COMMENT_PREFIX)) {
            try {
                String scripts = resource.substring(SQL_DELIMITER_COMMENT_PREFIX.length());
                int endOfDelimIndex = scripts.indexOf(SQL_DELIMITER_COMMENT_SUFFIX);
                String delim = scripts.substring(0, endOfDelimIndex).trim();
                scripts = scripts.substring(endOfDelimIndex + 2).trim();
                return scripts.split(delim);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.warn((Object)"Error of parse SQL-script file. Invalid DELIMITER configuration. Valid format is '/*$DELIMITER:XXX*/' at begin of the SQL-script file, where XXX - DELIMITER string. Spaces will be trimed. ", (Throwable)e);
                LOG.info((Object)"Using DELIMITER:[;]");
                return resource.split(SQL_DELIMITER);
            }
        }
        return resource.split(SQL_DELIMITER);
    }

    public static String getAppropriateBlobType(DataSource dataSource) throws SQLException {
        String dialect = JDBCUtils.resolveDialect(dataSource);
        if (dialect.startsWith("HSQLDB")) {
            return "VARBINARY(65535)";
        }
        if (dialect.startsWith("MYSQL")) {
            return "LONGBLOB";
        }
        if (dialect.startsWith("PGSQL")) {
            return "bytea";
        }
        if (dialect.startsWith("MSSQL")) {
            return "VARBINARY(MAX)";
        }
        if (dialect.startsWith("SYBASE")) {
            return "IMAGE";
        }
        if (dialect.startsWith("INGRES")) {
            return "long byte";
        }
        return "BLOB";
    }

    public static String getAppropriateTimestamp(DataSource dataSource) throws SQLException {
        String dialect = JDBCUtils.resolveDialect(dataSource);
        if (dialect.startsWith("ORACLE")) {
            return "NUMBER(19, 0)";
        }
        return "BIGINT";
    }

    public static String getAppropriateCharType(DataSource dataSource) throws SQLException {
        String dialect = JDBCUtils.resolveDialect(dataSource);
        if (dialect.startsWith("ORACLE")) {
            return "VARCHAR2(512)";
        }
        return "VARCHAR(512)";
    }

    public static String resolveDialect(final DataSource dataSource) throws SQLException {
        Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return dataSource.getConnection();
            }
        });
        try {
            String string = DialectDetecter.detect(jdbcConn.getMetaData());
            return string;
        }
        finally {
            JDBCUtils.freeResources(null, null, jdbcConn);
        }
    }

    public static void freeResources(ResultSet resultSet, Statement statement, Connection conn) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

