/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.management.ManageableContainer;
import org.exoplatform.container.management.MetaDataBuilder;
import org.exoplatform.container.spi.Container;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagedTypeMetaData;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ManagementContextImpl
implements ManagementContext,
ManagedResource {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ManagementContextImpl");
    private static final ThreadLocal<ExoContainer> previousContainer = new ThreadLocal();
    private final Map<Class<?>, Object> scopingDataList;
    private final Map<Object, ManagementContextImpl> registrations;
    final Map<ManagementProvider, Object> managedSet;
    final ManagementContextImpl parent;
    private final Object resource;
    private final ManagedTypeMetaData typeMD;
    final ManageableContainer container;

    public ManagementContextImpl(ManageableContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("The container cannot be null");
        }
        ExoContainer resource = null;
        ManagedTypeMetaData typeMD = null;
        MetaDataBuilder builder = new MetaDataBuilder(container.getHolder().getClass());
        if (builder.isBuildable()) {
            resource = container.getHolder();
            typeMD = builder.build();
        }
        this.managedSet = new ConcurrentHashMap<ManagementProvider, Object>();
        this.registrations = new ConcurrentHashMap<Object, ManagementContextImpl>();
        this.parent = null;
        this.scopingDataList = new ConcurrentHashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = container;
    }

    public ManagementContextImpl(ManagementContextImpl parent, ManageableContainer container) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent cannot be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("The container cannot be null");
        }
        ExoContainer resource = null;
        ManagedTypeMetaData typeMD = null;
        MetaDataBuilder builder = new MetaDataBuilder(container.getHolder().getClass());
        if (builder.isBuildable()) {
            resource = container.getHolder();
            typeMD = builder.build();
        }
        this.managedSet = new ConcurrentHashMap<ManagementProvider, Object>();
        this.registrations = new ConcurrentHashMap<Object, ManagementContextImpl>();
        this.parent = parent;
        this.scopingDataList = new ConcurrentHashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = container;
    }

    public ManagementContextImpl(ManagementContextImpl parent, Object resource, ManagedTypeMetaData typeMD) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent cannot be null");
        }
        if (resource != null && typeMD == null || resource == null && typeMD != null) {
            throw new IllegalArgumentException("Can't have resource null and meta data not null or the converse");
        }
        this.managedSet = new ConcurrentHashMap<ManagementProvider, Object>();
        this.registrations = new ConcurrentHashMap<Object, ManagementContextImpl>();
        this.parent = parent;
        this.scopingDataList = new ConcurrentHashMap();
        this.resource = resource;
        this.typeMD = typeMD;
        this.container = null;
    }

    public ManagementContext getParent() {
        return this.parent;
    }

    @Override
    public <S> void setScopingData(Class<S> scopeType, S scopingData) {
        this.scopingDataList.put(scopeType, scopingData);
    }

    @Override
    public void register(Object o) {
        MetaDataBuilder builder;
        Object resource = null;
        ManagedBy managedBy = o.getClass().getAnnotation(ManagedBy.class);
        if (managedBy != null) {
            try {
                Class managedByClass = managedBy.value();
                Constructor blah = managedByClass.getConstructor(o.getClass());
                resource = blah.newInstance(o);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            resource = o;
        }
        if (resource != null && (builder = new MetaDataBuilder(resource.getClass())).isBuildable()) {
            ManagedTypeMetaData metaData = builder.build();
            ManagementContextImpl managementContext = resource instanceof Container ? (ManagementContextImpl)((Container)resource).getManagementContext() : new ManagementContextImpl(this, resource, metaData);
            if (this.registrations.containsKey(resource)) {
                LOG.debug((Object)("The component " + String.valueOf(resource) + " has already been registered"));
                return;
            }
            this.registrations.put(resource, managementContext);
            ManageableContainer container = this.findContainer();
            for (ManagementProvider provider : container.getProviders()) {
                Object name = provider.manage(managementContext);
                if (name == null) continue;
                managementContext.managedSet.put(provider, name);
            }
            if (resource instanceof ManagementAware) {
                ((ManagementAware)resource).setContext(managementContext);
            }
        }
    }

    @Override
    public void unregister(Object o) {
        ManagementContextImpl context = this.registrations.remove(o);
        if (context != null) {
            if (!(o instanceof ManageableContainer)) {
                context.unregisterAll();
            }
            for (Map.Entry<ManagementProvider, Object> entry : context.managedSet.entrySet()) {
                try {
                    entry.getKey().unmanage(entry.getValue());
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Could not unmanage " + String.valueOf(o) + " for the provider " + String.valueOf(entry.getKey())), (Throwable)e);
                }
            }
        }
    }

    public void unregisterAll() {
        Iterator<Map.Entry<Object, ManagementContextImpl>> iterator = this.registrations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, ManagementContextImpl> contextEntry = iterator.next();
            iterator.remove();
            if (contextEntry.getValue() == null) continue;
            if (!(contextEntry.getKey() instanceof ManageableContainer)) {
                contextEntry.getValue().unregisterAll();
            }
            for (Map.Entry<ManagementProvider, Object> provider : contextEntry.getValue().managedSet.entrySet()) {
                try {
                    provider.getKey().unmanage(provider.getValue());
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Could not unmanage " + String.valueOf(contextEntry.getKey()) + " for the provider " + String.valueOf(provider.getKey())), (Throwable)e);
                }
            }
        }
    }

    @Override
    public <S> List<S> getScopingData(Class<S> scopeType) {
        ArrayList<Object> list = new ArrayList<Object>();
        ManagementContextImpl current = this;
        while (current != null) {
            Object scopedData = current.scopingDataList.get(scopeType);
            if (scopedData != null) {
                list.add(scopedData);
            }
            current = current.parent;
        }
        return list;
    }

    public ManageableContainer findContainer() {
        ManagementContextImpl current = this;
        while (!(current.container instanceof ManageableContainer)) {
            if (current.parent == null) {
                return null;
            }
            current = current.parent;
        }
        return current.container;
    }

    @Override
    public void beforeInvoke(Object managedResource) {
        final ManageableContainer container = this.findContainer();
        if (container != null && container.getHolder() != null) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExoContainer oldContainer = ExoContainerContext.getCurrentContainerIfPresent();
                    if (!(oldContainer instanceof RootContainer)) {
                        previousContainer.set(oldContainer);
                    }
                    ExoContainerContext.setCurrentContainer(container.getHolder());
                    return null;
                }
            });
            RequestLifeCycle.begin(container.getHolder());
        }
    }

    @Override
    public void afterInvoke(Object managedResource) {
        try {
            RequestLifeCycle.end();
        }
        catch (Throwable throwable) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExoContainer oldContainer = previousContainer.get();
                    if (oldContainer != null) {
                        previousContainer.set(null);
                    }
                    ExoContainerContext.setCurrentContainer(oldContainer);
                    return null;
                }
            });
            throw throwable;
        }
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
    }

    public String toString() {
        return "ManagementContextImpl[container=" + String.valueOf(this.container) + "]";
    }

    @Override
    public Object getResource() {
        return this.resource;
    }

    @Override
    public ManagedTypeMetaData getMetaData() {
        return this.typeMD;
    }

    void install(ManagementProvider provider) {
        Object name;
        if (this.resource != null && this.typeMD != null && (name = provider.manage(this)) != null) {
            this.managedSet.put(provider, name);
        }
        for (ManagementContextImpl registration : this.registrations.values()) {
            registration.install(provider);
        }
    }
}

