/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.webapi;

import io.meeds.oauth.webapi.OAuthFilterIntegrator;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.integration.SSODelegateFilter;

public class OAuthDelegateFilter
extends SSODelegateFilter {
    private volatile Map<SSOInterceptor, String> oauthInterceptors;
    private static final Log log = ExoLogger.getLogger(OAuthDelegateFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<SSOInterceptor, String> oauthInterceptors = this.getInterceptors();
        if (!oauthInterceptors.isEmpty()) {
            OAuthFilterChain oauthChain = new OAuthFilterChain(chain, this.getInterceptors(), this);
            oauthChain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SSOInterceptor, String> getInterceptors() {
        if (this.oauthInterceptors == null) {
            OAuthDelegateFilter oAuthDelegateFilter = this;
            synchronized (oAuthDelegateFilter) {
                if (this.oauthInterceptors == null) {
                    OAuthFilterIntegrator oauthFilterIntegrator = (OAuthFilterIntegrator)this.getContainer().getComponentInstanceOfType(OAuthFilterIntegrator.class);
                    this.oauthInterceptors = oauthFilterIntegrator.getOAuthInterceptors();
                    if (!this.oauthInterceptors.isEmpty()) {
                        log.info((Object)("Initialized OAuth integrator with interceptors: " + String.valueOf(this.oauthInterceptors)));
                    }
                }
            }
        }
        return this.oauthInterceptors;
    }

    private static class OAuthFilterChain
    extends SSODelegateFilter.SSOFilterChain {
        private OAuthFilterChain(FilterChain containerChain, Map<SSOInterceptor, String> interceptors, OAuthDelegateFilter oauthDelegateFilter) {
            super(containerChain, interceptors, (SSODelegateFilter)oauthDelegateFilter);
        }
    }
}

