/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.transaction;

import java.io.Serializable;
import java.math.BigInteger;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.utils.WalletUtils;

public class TransactionDetail
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 658273092293607458L;
    private long id;
    private Wallet issuer;
    private long issuerId;
    private long networkId;
    private String hash;
    private String contractAddress;
    private String contractMethodName;
    private boolean pending;
    private boolean succeeded;
    private boolean dropped;
    private boolean isAdminOperation;
    private String from;
    private Wallet fromWallet;
    private String to;
    private Wallet toWallet;
    private String by;
    private Wallet byWallet;
    private String label;
    private String message;
    private double value;
    private double contractAmount;
    private int gasUsed;
    private double gasPrice;
    private double tokenFee;
    private double etherFee;
    private boolean noContractFunds;
    private long timestamp;
    private long nonce;
    private boolean boost;
    private String rawTransaction;
    private long sentTimestamp;
    private long sendingAttemptCount;

    public TransactionDetail clone() {
        return new TransactionDetail(this.id, this.issuer, this.issuerId, this.networkId, this.hash, this.contractAddress, this.contractMethodName, this.pending, this.succeeded, this.dropped, this.isAdminOperation, this.from, this.fromWallet, this.to, this.toWallet, this.by, this.byWallet, this.label, this.message, this.value, this.contractAmount, this.gasUsed, this.gasPrice, this.tokenFee, this.etherFee, this.noContractFunds, this.timestamp, this.nonce, this.boost, this.rawTransaction, this.sentTimestamp, this.sendingAttemptCount);
    }

    public BigInteger getContractAmountDecimal(int decimals) {
        if (this.contractAmount == 0.0) {
            return BigInteger.ZERO;
        }
        return WalletUtils.convertToDecimals(this.contractAmount, decimals);
    }

    public BigInteger getValueDecimal(int decimals) {
        if (this.value == 0.0) {
            return BigInteger.ZERO;
        }
        return WalletUtils.convertToDecimals(this.value, decimals);
    }

    public void setContractAmountDecimal(BigInteger amount, int decimals) {
        if (amount == null) {
            this.contractAmount = 0.0;
            return;
        }
        this.contractAmount = WalletUtils.convertFromDecimals(amount, decimals);
    }

    public void setValueDecimal(BigInteger amount, int decimals) {
        this.value = amount == null ? 0.0 : WalletUtils.convertFromDecimals(amount, decimals);
    }

    public void increaseSendingAttemptCount() {
        this.setSendingAttemptCount(this.sendingAttemptCount + 1L);
    }

    public long getId() {
        return this.id;
    }

    public Wallet getIssuer() {
        return this.issuer;
    }

    public long getIssuerId() {
        return this.issuerId;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public String getHash() {
        return this.hash;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getContractMethodName() {
        return this.contractMethodName;
    }

    public boolean isPending() {
        return this.pending;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public boolean isAdminOperation() {
        return this.isAdminOperation;
    }

    public String getFrom() {
        return this.from;
    }

    public Wallet getFromWallet() {
        return this.fromWallet;
    }

    public String getTo() {
        return this.to;
    }

    public Wallet getToWallet() {
        return this.toWallet;
    }

    public String getBy() {
        return this.by;
    }

    public Wallet getByWallet() {
        return this.byWallet;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public double getValue() {
        return this.value;
    }

    public double getContractAmount() {
        return this.contractAmount;
    }

    public int getGasUsed() {
        return this.gasUsed;
    }

    public double getGasPrice() {
        return this.gasPrice;
    }

    public double getTokenFee() {
        return this.tokenFee;
    }

    public double getEtherFee() {
        return this.etherFee;
    }

    public boolean isNoContractFunds() {
        return this.noContractFunds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getNonce() {
        return this.nonce;
    }

    public boolean isBoost() {
        return this.boost;
    }

    public String getRawTransaction() {
        return this.rawTransaction;
    }

    public long getSentTimestamp() {
        return this.sentTimestamp;
    }

    public long getSendingAttemptCount() {
        return this.sendingAttemptCount;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIssuer(Wallet issuer) {
        this.issuer = issuer;
    }

    public void setIssuerId(long issuerId) {
        this.issuerId = issuerId;
    }

    public void setNetworkId(long networkId) {
        this.networkId = networkId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setContractMethodName(String contractMethodName) {
        this.contractMethodName = contractMethodName;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public void setDropped(boolean dropped) {
        this.dropped = dropped;
    }

    public void setAdminOperation(boolean isAdminOperation) {
        this.isAdminOperation = isAdminOperation;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setFromWallet(Wallet fromWallet) {
        this.fromWallet = fromWallet;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setToWallet(Wallet toWallet) {
        this.toWallet = toWallet;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public void setByWallet(Wallet byWallet) {
        this.byWallet = byWallet;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setContractAmount(double contractAmount) {
        this.contractAmount = contractAmount;
    }

    public void setGasUsed(int gasUsed) {
        this.gasUsed = gasUsed;
    }

    public void setGasPrice(double gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setTokenFee(double tokenFee) {
        this.tokenFee = tokenFee;
    }

    public void setEtherFee(double etherFee) {
        this.etherFee = etherFee;
    }

    public void setNoContractFunds(boolean noContractFunds) {
        this.noContractFunds = noContractFunds;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public void setBoost(boolean boost) {
        this.boost = boost;
    }

    public void setRawTransaction(String rawTransaction) {
        this.rawTransaction = rawTransaction;
    }

    public void setSentTimestamp(long sentTimestamp) {
        this.sentTimestamp = sentTimestamp;
    }

    public void setSendingAttemptCount(long sendingAttemptCount) {
        this.sendingAttemptCount = sendingAttemptCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDetail)) {
            return false;
        }
        TransactionDetail other = (TransactionDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIssuerId() != other.getIssuerId()) {
            return false;
        }
        if (this.getNetworkId() != other.getNetworkId()) {
            return false;
        }
        if (this.isPending() != other.isPending()) {
            return false;
        }
        if (this.isSucceeded() != other.isSucceeded()) {
            return false;
        }
        if (this.isDropped() != other.isDropped()) {
            return false;
        }
        if (this.isAdminOperation() != other.isAdminOperation()) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getContractAmount(), other.getContractAmount()) != 0) {
            return false;
        }
        if (this.getGasUsed() != other.getGasUsed()) {
            return false;
        }
        if (Double.compare(this.getGasPrice(), other.getGasPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getTokenFee(), other.getTokenFee()) != 0) {
            return false;
        }
        if (Double.compare(this.getEtherFee(), other.getEtherFee()) != 0) {
            return false;
        }
        if (this.isNoContractFunds() != other.isNoContractFunds()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        if (this.isBoost() != other.isBoost()) {
            return false;
        }
        if (this.getSentTimestamp() != other.getSentTimestamp()) {
            return false;
        }
        if (this.getSendingAttemptCount() != other.getSendingAttemptCount()) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$contractMethodName = this.getContractMethodName();
        String other$contractMethodName = other.getContractMethodName();
        if (this$contractMethodName == null ? other$contractMethodName != null : !this$contractMethodName.equals(other$contractMethodName)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$by = this.getBy();
        String other$by = other.getBy();
        if (this$by == null ? other$by != null : !this$by.equals(other$by)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$rawTransaction = this.getRawTransaction();
        String other$rawTransaction = other.getRawTransaction();
        return !(this$rawTransaction == null ? other$rawTransaction != null : !this$rawTransaction.equals(other$rawTransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $issuerId = this.getIssuerId();
        result = result * 59 + (int)($issuerId >>> 32 ^ $issuerId);
        long $networkId = this.getNetworkId();
        result = result * 59 + (int)($networkId >>> 32 ^ $networkId);
        result = result * 59 + (this.isPending() ? 79 : 97);
        result = result * 59 + (this.isSucceeded() ? 79 : 97);
        result = result * 59 + (this.isDropped() ? 79 : 97);
        result = result * 59 + (this.isAdminOperation() ? 79 : 97);
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $contractAmount = Double.doubleToLongBits(this.getContractAmount());
        result = result * 59 + (int)($contractAmount >>> 32 ^ $contractAmount);
        result = result * 59 + this.getGasUsed();
        long $gasPrice = Double.doubleToLongBits(this.getGasPrice());
        result = result * 59 + (int)($gasPrice >>> 32 ^ $gasPrice);
        long $tokenFee = Double.doubleToLongBits(this.getTokenFee());
        result = result * 59 + (int)($tokenFee >>> 32 ^ $tokenFee);
        long $etherFee = Double.doubleToLongBits(this.getEtherFee());
        result = result * 59 + (int)($etherFee >>> 32 ^ $etherFee);
        result = result * 59 + (this.isNoContractFunds() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $nonce = this.getNonce();
        result = result * 59 + (int)($nonce >>> 32 ^ $nonce);
        result = result * 59 + (this.isBoost() ? 79 : 97);
        long $sentTimestamp = this.getSentTimestamp();
        result = result * 59 + (int)($sentTimestamp >>> 32 ^ $sentTimestamp);
        long $sendingAttemptCount = this.getSendingAttemptCount();
        result = result * 59 + (int)($sendingAttemptCount >>> 32 ^ $sendingAttemptCount);
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $contractMethodName = this.getContractMethodName();
        result = result * 59 + ($contractMethodName == null ? 43 : $contractMethodName.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $by = this.getBy();
        result = result * 59 + ($by == null ? 43 : $by.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $rawTransaction = this.getRawTransaction();
        result = result * 59 + ($rawTransaction == null ? 43 : $rawTransaction.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionDetail(id=" + this.getId() + ", issuer=" + String.valueOf(this.getIssuer()) + ", issuerId=" + this.getIssuerId() + ", networkId=" + this.getNetworkId() + ", hash=" + this.getHash() + ", contractAddress=" + this.getContractAddress() + ", contractMethodName=" + this.getContractMethodName() + ", pending=" + this.isPending() + ", succeeded=" + this.isSucceeded() + ", dropped=" + this.isDropped() + ", isAdminOperation=" + this.isAdminOperation() + ", from=" + this.getFrom() + ", fromWallet=" + String.valueOf(this.getFromWallet()) + ", to=" + this.getTo() + ", toWallet=" + String.valueOf(this.getToWallet()) + ", by=" + this.getBy() + ", byWallet=" + String.valueOf(this.getByWallet()) + ", value=" + this.getValue() + ", contractAmount=" + this.getContractAmount() + ", gasUsed=" + this.getGasUsed() + ", gasPrice=" + this.getGasPrice() + ", tokenFee=" + this.getTokenFee() + ", etherFee=" + this.getEtherFee() + ", noContractFunds=" + this.isNoContractFunds() + ", timestamp=" + this.getTimestamp() + ", nonce=" + this.getNonce() + ", boost=" + this.isBoost() + ", rawTransaction=" + this.getRawTransaction() + ", sentTimestamp=" + this.getSentTimestamp() + ", sendingAttemptCount=" + this.getSendingAttemptCount() + ")";
    }

    public TransactionDetail(long id, Wallet issuer, long issuerId, long networkId, String hash, String contractAddress, String contractMethodName, boolean pending, boolean succeeded, boolean dropped, boolean isAdminOperation, String from, Wallet fromWallet, String to, Wallet toWallet, String by, Wallet byWallet, String label, String message, double value, double contractAmount, int gasUsed, double gasPrice, double tokenFee, double etherFee, boolean noContractFunds, long timestamp, long nonce, boolean boost, String rawTransaction, long sentTimestamp, long sendingAttemptCount) {
        this.id = id;
        this.issuer = issuer;
        this.issuerId = issuerId;
        this.networkId = networkId;
        this.hash = hash;
        this.contractAddress = contractAddress;
        this.contractMethodName = contractMethodName;
        this.pending = pending;
        this.succeeded = succeeded;
        this.dropped = dropped;
        this.isAdminOperation = isAdminOperation;
        this.from = from;
        this.fromWallet = fromWallet;
        this.to = to;
        this.toWallet = toWallet;
        this.by = by;
        this.byWallet = byWallet;
        this.label = label;
        this.message = message;
        this.value = value;
        this.contractAmount = contractAmount;
        this.gasUsed = gasUsed;
        this.gasPrice = gasPrice;
        this.tokenFee = tokenFee;
        this.etherFee = etherFee;
        this.noContractFunds = noContractFunds;
        this.timestamp = timestamp;
        this.nonce = nonce;
        this.boost = boost;
        this.rawTransaction = rawTransaction;
        this.sentTimestamp = sentTimestamp;
        this.sendingAttemptCount = sendingAttemptCount;
    }

    public TransactionDetail() {
    }
}

