/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.localization;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class LocaleContextInfoUtils {
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String PREV_LOCALE_SESSION_ATTR = "org.gatein.LAST_LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";
    private static final Log LOG = ExoLogger.getLogger(LocaleContextInfoUtils.class);
    private static final Set<Locale> SUPPORTED_LOCALES = new HashSet<Locale>();

    public static Locale computeLocale(HttpServletRequest request) {
        Locale locale;
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getService(LocalePolicy.class);
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo(request);
        Set<Locale> supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        boolean supported = supportedLocales.contains(locale = localePolicy.determineLocale(localeCtx));
        if (!supported && StringUtils.isNotBlank((CharSequence)locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            LocaleConfigService localeConfigService = (LocaleConfigService)ExoContainerContext.getService(LocaleConfigService.class);
            Locale defaultLocale = localeConfigService.getDefaultLocaleConfig().getLocale();
            LOG.warn("Unsupported locale returned by LocalePolicy: {}. Falling back to default configured local '{}'.", new Object[]{locale, defaultLocale});
            locale = defaultLocale;
        }
        return locale;
    }

    public static LocaleContextInfo buildLocaleContextInfo(HttpServletRequest request) {
        LocaleContextInfo localeCtx = new LocaleContextInfo();
        localeCtx.setSupportedLocales(LocaleContextInfoUtils.getSupportedLocales());
        if (request == null) {
            return localeCtx;
        }
        String username = request.getRemoteUser();
        Locale previousLocale = LocaleContextInfoUtils.getPreviousLocale(request);
        Locale sessionLocale = previousLocale == null ? LocaleContextInfoUtils.getSessionLocale(request) : previousLocale;
        localeCtx.setSessionLocale(sessionLocale);
        localeCtx.setUserProfileLocale(LocaleContextInfoUtils.getUserLocale(username));
        localeCtx.setBrowserLocales(Collections.list(request.getLocales()));
        localeCtx.setCookieLocales(LocaleContextInfoUtils.getCookieLocales(request));
        localeCtx.setRemoteUser(username);
        return localeCtx;
    }

    public static LocaleContextInfo buildLocaleContextInfo(String userId) {
        LocaleContextInfo localeCtx = new LocaleContextInfo();
        localeCtx.setSupportedLocales(LocaleContextInfoUtils.getSupportedLocales());
        localeCtx.setUserProfileLocale(LocaleContextInfoUtils.getUserLocale(userId));
        localeCtx.setRemoteUser(userId);
        return localeCtx;
    }

    public static List<Locale> getCookieLocales(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!LOCALE_COOKIE.equals(cookie.getName())) continue;
                ArrayList<Locale> locales = new ArrayList<Locale>();
                locales.add(LocaleContextInfo.getLocale(cookie.getValue()));
                return locales;
            }
        }
        return Collections.emptyList();
    }

    private static Locale getSessionLocale(HttpServletRequest request) {
        return LocaleContextInfoUtils.getLocaleFromSession(request, LOCALE_SESSION_ATTR);
    }

    private static Locale getPreviousLocale(HttpServletRequest request) {
        return LocaleContextInfoUtils.getLocaleFromSession(request, PREV_LOCALE_SESSION_ATTR);
    }

    public static Set<Locale> getSupportedLocales() {
        LocaleConfigService localeConfigService;
        if (SUPPORTED_LOCALES.isEmpty() && (localeConfigService = (LocaleConfigService)ExoContainerContext.getService(LocaleConfigService.class)) != null) {
            for (LocaleConfig lc : localeConfigService.getLocalConfigs()) {
                SUPPORTED_LOCALES.add(lc.getLocale());
            }
        }
        return SUPPORTED_LOCALES;
    }

    private static Locale getLocaleFromSession(HttpServletRequest request, String attrName) {
        String lang = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            lang = (String)session.getAttribute(attrName);
        }
        return lang != null ? LocaleContextInfo.getLocale(lang) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale getUserLocale(String userId) {
        String lang = "";
        UserProfile profile = null;
        if (userId != null) {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            LocaleContextInfoUtils.beginContext(organizationService);
            try {
                profile = organizationService.getUserProfileHandler().findUserProfileByName(userId);
            }
            catch (Exception e) {
                LOG.debug((Object)(userId + " profile not found "), (Throwable)e);
            }
            finally {
                LocaleContextInfoUtils.endContext(organizationService);
            }
            if (profile != null) {
                lang = profile.getAttribute("user.language");
            }
            if (lang != null && lang.trim().length() > 0) {
                return LocaleUtils.toLocale((String)lang);
            }
        }
        return null;
    }

    private static void beginContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    private static void endContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

