/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;

public class SpaceLifecycle
extends AbstractLifeCycle<SpaceLifeCycleListener, SpaceLifeCycleEvent> {
    private ThreadLocal<SpaceLifeCycleEvent.Type> currentEventThreadLocal = new ThreadLocal();

    public void setCurrentEvent(SpaceLifeCycleEvent.Type type) {
        if (this.currentEventThreadLocal.get() == null) {
            this.currentEventThreadLocal.set(type);
        }
    }

    public SpaceLifeCycleEvent.Type getCurrentEvent() {
        return this.currentEventThreadLocal.get();
    }

    public void resetCurrentEvent(SpaceLifeCycleEvent.Type type) {
        if (this.currentEventThreadLocal.get() == type) {
            this.currentEventThreadLocal.remove();
        }
    }

    @Override
    protected void dispatchEvent(SpaceLifeCycleListener listener, SpaceLifeCycleEvent event) {
        switch (event.getType()) {
            case SPACE_CREATED: {
                listener.spaceCreated(event);
                break;
            }
            case SPACE_REMOVED: {
                listener.spaceRemoved(event);
                break;
            }
            case APP_ACTIVATED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.applicationActivated(event);
                break;
            }
            case APP_DEACTIVATED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.applicationDeactivated(event);
                break;
            }
            case APP_ADDED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.applicationAdded(event);
                break;
            }
            case APP_REMOVED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.applicationRemoved(event);
                break;
            }
            case JOINED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.joined(event);
                break;
            }
            case LEFT: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.left(event);
                break;
            }
            case GRANTED_LEAD: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.grantedLead(event);
                break;
            }
            case REVOKED_LEAD: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.revokedLead(event);
                break;
            }
            case SPACE_RENAMED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceRenamed(event);
                break;
            }
            case SPACE_DESCRIPTION_EDITED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceDescriptionEdited(event);
                break;
            }
            case SPACE_AVATAR_EDITED: {
                listener.spaceAvatarEdited(event);
                break;
            }
            case SPACE_BANNER_EDITED: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceBannerEdited(event);
                break;
            }
            case SPACE_HIDDEN: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceAccessEdited(event);
                break;
            }
            case SPACE_REGISTRATION: {
                if (!this.isSpaceProperEvent(event)) break;
                listener.spaceRegistrationEdited(event);
                break;
            }
            case ADD_INVITED_USER: {
                listener.addInvitedUser(event);
                break;
            }
            case DENY_INVITED_USER: {
                listener.removeInvitedUser(event);
                break;
            }
            case ADD_PENDING_USER: {
                listener.addPendingUser(event);
                break;
            }
            case REMOVE_PENDING_USER: {
                listener.removePendingUser(event);
                break;
            }
        }
    }

    public void spaceCreated(Space space, String creator) {
        this.broadcast(new SpaceLifeCycleEvent(space, creator, SpaceLifeCycleEvent.Type.SPACE_CREATED));
    }

    public void spaceRemoved(Space space, String remover) {
        this.broadcast(new SpaceLifeCycleEvent(space, remover, SpaceLifeCycleEvent.Type.SPACE_REMOVED));
    }

    public void addApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_ADDED);
        event.getSource();
        this.broadcast(event);
    }

    public void deactivateApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_DEACTIVATED);
        this.broadcast(event);
    }

    public void activateApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_ACTIVATED);
        this.broadcast(event);
    }

    public void removeApplication(Space space, String appId) {
        SpaceLifeCycleEvent event = new SpaceLifeCycleEvent(space, appId, SpaceLifeCycleEvent.Type.APP_REMOVED);
        this.broadcast(event);
    }

    public void memberJoined(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.JOINED));
    }

    public void memberLeft(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.LEFT));
    }

    public void grantedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.GRANTED_LEAD));
    }

    public void revokedLead(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REVOKED_LEAD));
    }

    public void spaceRenamed(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_RENAMED));
    }

    public void spaceDescriptionEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_DESCRIPTION_EDITED));
    }

    public void spaceAvatarEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_AVATAR_EDITED));
    }

    public void spaceBannerEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_BANNER_EDITED));
    }

    public void spaceAccessEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_HIDDEN));
    }

    public void spaceRegistrationEdited(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.SPACE_REGISTRATION));
    }

    public void addInvitedUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_INVITED_USER));
    }

    public void removeInvitedUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.DENY_INVITED_USER));
    }

    public void addPendingUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.ADD_PENDING_USER));
    }

    public void removePendingUser(Space space, String userId) {
        this.broadcast(new SpaceLifeCycleEvent(space, userId, SpaceLifeCycleEvent.Type.REMOVE_PENDING_USER));
    }

    private boolean isSpaceProperEvent(SpaceLifeCycleEvent event) {
        SpaceLifeCycleEvent.Type currentEvent = this.getCurrentEvent();
        return currentEvent == null || currentEvent == event.getType();
    }
}

