/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.listeners.SocialUserEventListenerImpl$AjcClosure1;
import org.exoplatform.social.core.listeners.SocialUserEventListenerImpl$AjcClosure3;
import org.exoplatform.social.core.listeners.SocialUserEventListenerImpl$AjcClosure5;
import org.exoplatform.social.core.listeners.SocialUserEventListenerImpl$AjcClosure7;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CachedSpaceStorage;

public class SocialUserEventListenerImpl
extends UserEventListener {
    private static final Log LOG;
    private ExoContainer container;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public SocialUserEventListenerImpl(ExoContainer container) {
        this.container = container;
    }

    @ExoTransactional
    public void preSave(User user, boolean isNew) throws Exception {
        User user2 = user;
        boolean bl = isNew;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)user2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, user2, Conversions.booleanObject((boolean)bl), joinPoint};
        SocialUserEventListenerImpl$AjcClosure1 socialUserEventListenerImpl$AjcClosure1 = new SocialUserEventListenerImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(socialUserEventListenerImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void postSave(User user, boolean isNew) throws Exception {
        User user2 = user;
        boolean bl = isNew;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)user2, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, user2, Conversions.booleanObject((boolean)bl), joinPoint};
        SocialUserEventListenerImpl$AjcClosure3 socialUserEventListenerImpl$AjcClosure3 = new SocialUserEventListenerImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(socialUserEventListenerImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void postDelete(User user) throws Exception {
        User user2 = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)user2);
        Object[] objectArray = new Object[]{this, user2, joinPoint};
        SocialUserEventListenerImpl$AjcClosure5 socialUserEventListenerImpl$AjcClosure5 = new SocialUserEventListenerImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(socialUserEventListenerImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void postSetEnabled(User user) throws Exception {
        User user2 = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)user2);
        Object[] objectArray = new Object[]{this, user2, joinPoint};
        SocialUserEventListenerImpl$AjcClosure7 socialUserEventListenerImpl$AjcClosure7 = new SocialUserEventListenerImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(socialUserEventListenerImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    static {
        SocialUserEventListenerImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(SocialUserEventListenerImpl.class);
    }

    static /* synthetic */ void preSave_aroundBody0(SocialUserEventListenerImpl ajc$this, User user, boolean isNew, JoinPoint joinPoint) {
        IdentityStorage ids = (IdentityStorage)ajc$this.container.getComponentInstanceOfType(IdentityStorage.class);
        Identity identity = ids.findIdentity("organization", user.getUserName());
        if (isNew && identity != null && identity.isDeleted()) {
            throw new ObjectAlreadyExistsException((Object)identity, "Unable to create a previously deleted user : " + user.getUserName());
        }
    }

    static /* synthetic */ void postSave_aroundBody2(SocialUserEventListenerImpl ajc$this, User user, boolean isNew, JoinPoint joinPoint) {
        if (user == null) {
            throw new IllegalArgumentException("User parameter is mandatory");
        }
        IdentityManager identityManager = (IdentityManager)ajc$this.container.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = identityManager.getOrCreateUserIdentity(user.getUserName());
        if (identity == null) {
            IdentityStorage storage = (IdentityStorage)ajc$this.container.getComponentInstanceOfType(IdentityStorage.class);
            identity = storage.findIdentity("organization", user.getUserName());
        }
        if (identity == null) {
            LOG.debug("Can't find identity for user {}, ignore updating profile", new Object[]{user.getUserName()});
            return;
        }
        Profile profile = identity.getProfile();
        boolean hasUpdated = false;
        if (!isNew) {
            String uFirstName = user.getFirstName();
            String uLastName = user.getLastName();
            Object uDisplayName = user.getDisplayName();
            String uEmail = user.getEmail();
            String pFirstName = (String)profile.getProperty("firstName");
            String pLastName = (String)profile.getProperty("lastName");
            String pFullName = (String)profile.getProperty("fullName");
            String pEmail = (String)profile.getProperty("email");
            if (pFirstName == null || !pFirstName.equals(uFirstName)) {
                profile.setProperty("firstName", (Object)uFirstName);
                hasUpdated = true;
            }
            if (pLastName == null || !pLastName.equals(uLastName)) {
                profile.setProperty("lastName", (Object)uLastName);
                hasUpdated = true;
            }
            if (uDisplayName == null || StringUtils.isEmpty((CharSequence)uDisplayName)) {
                uDisplayName = uFirstName + " " + uLastName;
            }
            if (!((String)uDisplayName).equals(pFullName)) {
                profile.setProperty("fullName", uDisplayName);
            }
            if (pEmail == null || !pEmail.equals(uEmail)) {
                profile.setProperty("email", (Object)uEmail);
                hasUpdated = true;
            }
        }
        if (hasUpdated) {
            profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.CONTACT));
        } else {
            profile.setListUpdateTypes(Collections.emptyList());
        }
        identityManager.updateProfile(profile);
    }

    static /* synthetic */ void postDelete_aroundBody4(SocialUserEventListenerImpl ajc$this, User user, JoinPoint joinPoint) {
        IdentityStorage storage = (IdentityStorage)ajc$this.container.getComponentInstanceOfType(IdentityStorage.class);
        Identity identity = storage.findIdentity("organization", user.getUserName());
        try {
            if (identity != null) {
                storage.hardDeleteIdentity(identity);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Problem occurred when deleting user named " + identity.getRemoteId()), (Throwable)e);
        }
    }

    static /* synthetic */ void postSetEnabled_aroundBody6(SocialUserEventListenerImpl ajc$this, User user, JoinPoint joinPoint) {
        IdentityStorage storage = (IdentityStorage)ajc$this.container.getComponentInstanceOfType(IdentityStorage.class);
        Identity identity = storage.findIdentity("organization", user.getUserName());
        if (identity != null) {
            Space[] memberSpacesArray;
            IdentityManager idm = (IdentityManager)ajc$this.container.getComponentInstanceOfType(IdentityManager.class);
            idm.processEnabledIdentity(user.getUserName(), user.isEnabled());
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            CachedSpaceStorage cachedSpaceStorage = (CachedSpaceStorage)CommonsUtils.getService(CachedSpaceStorage.class);
            ListAccess memberSpaces = spaceService.getMemberSpaces(user.getUserName());
            for (Space space : memberSpacesArray = (Space[])memberSpaces.load(0, memberSpaces.getSize())) {
                cachedSpaceStorage.clearSpaceCached(space.getId());
            }
        } else {
            LOG.warn((Object)String.format("Social's Identity(%s) not found!", user.getUserName()));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SocialUserEventListenerImpl.java", SocialUserEventListenerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preSave", "org.exoplatform.social.core.listeners.SocialUserEventListenerImpl", "org.exoplatform.services.organization.User:boolean", "user:isNew", "java.lang.Exception", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postSave", "org.exoplatform.social.core.listeners.SocialUserEventListenerImpl", "org.exoplatform.services.organization.User:boolean", "user:isNew", "java.lang.Exception", "void"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postDelete", "org.exoplatform.social.core.listeners.SocialUserEventListenerImpl", "org.exoplatform.services.organization.User", "user", "java.lang.Exception", "void"), 138);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postSetEnabled", "org.exoplatform.social.core.listeners.SocialUserEventListenerImpl", "org.exoplatform.services.organization.User", "user", "java.lang.Exception", "void"), 154);
    }
}

