/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Selectable;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardIndexExporter
implements Exporter<Index> {
    private final Dialect dialect;

    public StandardIndexExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String[] getSqlCreateStrings(Index index, Metadata metadata, SqlStringGenerationContext context) {
        StringBuilder createIndex = new StringBuilder().append(this.dialect.getCreateIndexString(index.isUnique())).append(" ").append(this.indexName(index, context, metadata)).append(" on ").append(context.format(index.getTable().getQualifiedTableName())).append(" (");
        this.appendColumnList(index, createIndex);
        createIndex.append(")");
        return new String[]{createIndex.toString()};
    }

    private String indexName(Index index, SqlStringGenerationContext context, Metadata metadata) {
        if (this.dialect.qualifyIndexName()) {
            QualifiedTableName qualifiedTableName = index.getTable().getQualifiedTableName();
            return context.format(new QualifiedNameImpl(qualifiedTableName.getCatalogName(), qualifiedTableName.getSchemaName(), metadata.getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(index.getQuotedName(this.dialect))));
        }
        return index.getName();
    }

    private void appendColumnList(Index index, StringBuilder createIndex) {
        boolean first = true;
        Map<Selectable, String> columnOrderMap = index.getSelectableOrderMap();
        for (Selectable column : index.getSelectables()) {
            if (first) {
                first = false;
            } else {
                createIndex.append(", ");
            }
            createIndex.append(column.getText(this.dialect));
            if (!columnOrderMap.containsKey(column)) continue;
            createIndex.append(" ").append(columnOrderMap.get(column));
        }
    }

    @Override
    public String[] getSqlDropStrings(Index index, Metadata metadata, SqlStringGenerationContext context) {
        if (!this.dialect.dropConstraints()) {
            return NO_COMMANDS;
        }
        String tableName = context.format(index.getTable().getQualifiedTableName());
        String indexNameForCreation = this.dialect.qualifyIndexName() ? StringHelper.qualify(tableName, index.getName()) : index.getName();
        return new String[]{"drop index " + indexNameForCreation};
    }
}

