/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.mapper.RuleMapper;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class RuleStorage {
    private ProgramStorage programStorage;
    private EventStorage eventStorage;
    private ProgramDAO programDAO;
    private RuleDAO ruleDAO;

    public RuleStorage(ProgramStorage programStorage, EventStorage eventStorage, ProgramDAO programDAO, RuleDAO ruleDAO) {
        this.programStorage = programStorage;
        this.eventStorage = eventStorage;
        this.ruleDAO = ruleDAO;
        this.programDAO = programDAO;
    }

    public RuleDTO saveRule(RuleDTO ruleDTO) {
        RuleEntity ruleEntity = RuleMapper.toEntity(ruleDTO);
        ruleEntity.setLastModifiedDate(new Date());
        ProgramDTO program = ruleDTO.getProgram();
        if (program != null) {
            ProgramEntity programEntity = (ProgramEntity)this.programDAO.find(Long.valueOf(program.getId()));
            ruleEntity.setDomainEntity(programEntity);
        }
        if (ruleEntity.getId() == null) {
            ruleEntity.setCreatedDate(new Date());
            ruleEntity = (RuleEntity)this.ruleDAO.create(ruleEntity);
        } else {
            ruleEntity = (RuleEntity)this.ruleDAO.update(ruleEntity);
        }
        return RuleMapper.fromEntity(this.programStorage, this.eventStorage, ruleEntity);
    }

    public RuleDTO findRuleById(Long id) {
        return RuleMapper.fromEntity(this.programStorage, this.eventStorage, (RuleEntity)this.ruleDAO.find(id));
    }

    public RuleDTO findRuleByTitle(String ruleTitle) {
        return RuleMapper.fromEntity(this.programStorage, this.eventStorage, this.ruleDAO.findRuleByTitle(ruleTitle));
    }

    public RuleDTO findActiveRuleByEventAndProgramId(String event, long programId) {
        return RuleMapper.fromEntity(this.programStorage, this.eventStorage, this.ruleDAO.findActiveRuleByEventAndProgramId(event, programId));
    }

    public List<Long> findRuleIdsByFilter(RuleFilter ruleFilter, int offset, int limit) {
        return this.ruleDAO.findRulesIdsByFilter(ruleFilter, offset, limit);
    }

    public int countRulesByFilter(RuleFilter ruleFilter) {
        if (ruleFilter != null) {
            return this.ruleDAO.countRulesByFilter(ruleFilter);
        }
        return this.ruleDAO.count().intValue();
    }

    public List<Long> findAllRulesIds(int offset, int limit) {
        return this.ruleDAO.findRulesIdsByFilter(new RuleFilter(true), offset, limit);
    }

    public RuleDTO deleteRuleById(long ruleId, String userId) throws ObjectNotFoundException {
        RuleEntity ruleEntity = (RuleEntity)this.ruleDAO.find(Long.valueOf(ruleId));
        if (ruleEntity == null) {
            throw new ObjectNotFoundException("Rule with id " + ruleId + " does not exist");
        }
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            ruleEntity.setLastModifiedBy(userId);
            ruleEntity.setLastModifiedDate(new Date());
        }
        ruleEntity.setDeleted(true);
        this.ruleDAO.update(ruleEntity);
        return RuleMapper.fromEntity(this.programStorage, this.eventStorage, ruleEntity);
    }

    public void clearCache() {
    }

    public void clearCache(RuleDTO rule) {
    }
}

