/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;

public class SimpleSkin
implements SkinConfig {
    public static final String ORIENTATION_QUERY_PARAM = "orientation";
    public static final String MINIFY_QUERY_PARAM = "minify";
    public static final String HASH_QUERY_PARAM = "hash";
    private static final Log LOG = ExoLogger.getLogger(SimpleSkin.class);
    private static boolean developing = PropertyManager.isDevelopping();
    private String module;
    private String name;
    private String cssPath;
    private String id;
    private int priority;
    private boolean filtered;
    private List<String> additionalModules;
    private String type;
    private int fileContentHash;
    private Map<Integer, String> urls = new ConcurrentHashMap<Integer, String>();

    public SimpleSkin(String module, String name, String cssPath) {
        this(module, name, cssPath, Integer.MAX_VALUE, false, null);
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority) {
        this(module, name, cssPath, cssPriority, false, null);
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority, List<String> additionalModules) {
        this(module, name, cssPath, cssPriority, false, additionalModules);
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority, boolean filtered) {
        this(module, name, cssPath, cssPriority, filtered, null);
    }

    public SimpleSkin(String module, String name, String cssPath, int cssPriority, boolean filtered, List<String> additionalModules) {
        this.module = module;
        this.name = name;
        this.cssPath = cssPath;
        this.id = module.replace('/', '_');
        this.priority = cssPriority;
        this.additionalModules = additionalModules == null ? new ArrayList() : additionalModules;
        this.filtered = filtered;
    }

    @Override
    public String getCSSPath() {
        return this.cssPath;
    }

    @Override
    public void setCSSPath(String cssPath) {
        this.cssPath = cssPath;
    }

    @Override
    public int getCSSPriority() {
        return this.getPriority();
    }

    @Override
    public int getFileContentHash() {
        if (developing) {
            return 0;
        }
        if (this.fileContentHash == 0) {
            String absolutePath = ("/" + this.cssPath).replace("//", "/");
            SkinService skinService = (SkinService)ExoContainerContext.getService(SkinService.class);
            try {
                String fileContent = skinService.getSkinModuleFileContent(absolutePath);
                this.fileContentHash = fileContent.hashCode();
            }
            catch (Exception e) {
                LOG.error("Error while processing CSS file {}", new Object[]{absolutePath, e});
            }
        }
        return this.fileContentHash;
    }

    @Override
    public SkinURL createURL() {
        if (StringUtils.isBlank((CharSequence)this.cssPath)) {
            return null;
        }
        return new SkinURL(){
            private Orientation orientation;

            @Override
            public String toString() {
                return this.toString(this.orientation);
            }

            @Override
            public String toString(Orientation orientation) {
                Orientation cssOrientation = orientation == null ? Orientation.LT : orientation;
                return SimpleSkin.this.urls.computeIfAbsent(Objects.hash(cssOrientation), k -> {
                    String absolutePath = ("/" + SimpleSkin.this.cssPath).replace("//", "/");
                    return absolutePath + "?orientation=" + cssOrientation.name() + "&minify=" + !developing + "&hash=" + SimpleSkin.this.getFileContentHash();
                });
            }

            @Override
            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }
        };
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setAdditionalModules(List<String> additionalModules) {
        this.additionalModules = additionalModules;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public void setFileContentHash(int fileContentHash) {
        this.fileContentHash = fileContentHash;
    }

    public void setUrls(Map<Integer, String> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleSkin)) {
            return false;
        }
        SimpleSkin other = (SimpleSkin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isFiltered() != other.isFiltered()) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cssPath = this.getCSSPath();
        String other$cssPath = other.getCSSPath();
        if (this$cssPath == null ? other$cssPath != null : !this$cssPath.equals(other$cssPath)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$additionalModules = this.getAdditionalModules();
        List<String> other$additionalModules = other.getAdditionalModules();
        if (this$additionalModules == null ? other$additionalModules != null : !((Object)this$additionalModules).equals(other$additionalModules)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<Integer, String> this$urls = this.getUrls();
        Map<Integer, String> other$urls = other.getUrls();
        return !(this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleSkin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isFiltered() ? 79 : 97);
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cssPath = this.getCSSPath();
        result = result * 59 + ($cssPath == null ? 43 : $cssPath.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $additionalModules = this.getAdditionalModules();
        result = result * 59 + ($additionalModules == null ? 43 : ((Object)$additionalModules).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<Integer, String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        return result;
    }

    public String toString() {
        return "SimpleSkin(module=" + this.getModule() + ", name=" + this.getName() + ", cssPath=" + this.getCSSPath() + ", id=" + this.getId() + ", priority=" + this.getPriority() + ", filtered=" + this.isFiltered() + ", additionalModules=" + String.valueOf(this.getAdditionalModules()) + ", type=" + this.getType() + ", fileContentHash=" + this.getFileContentHash() + ", urls=" + String.valueOf(this.getUrls()) + ")";
    }

    public static void setDeveloping(boolean developing) {
        SimpleSkin.developing = developing;
    }

    public Map<Integer, String> getUrls() {
        return this.urls;
    }
}

