/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.module.ModuleRegistry;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.Application;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.webui.application.WebuiRequestContext;

public class DefaultSpaceApplicationHandler
implements SpaceApplicationHandler {
    protected static final Log LOG = ExoLogger.getLogger(DefaultSpaceApplicationHandler.class);
    public static final String NAME = "classic";
    protected static final String TEMPLATE_NAME_PARAM = "templateName";
    public static final String SPACE_TEMPLATE_PAGE_ID = "portal::classic::spacetemplate";
    public static final String APPLICATION_CONTAINER = "Application";
    protected static final String GROUP_ID_PREFERENCE = "{groupId}";
    protected static final String MODIFIED_GROUP_ID_PREFERENCE = "{modifiedGroupId}";
    protected static final String PAGE_NAME_PREFERENCE = "{pageName}";
    protected static final String PAGE_URL_PREFERENCE = "{pageUrl}";
    protected LayoutService layoutService;
    protected NavigationService navigationService;
    protected PageStorage pageStorage;
    protected SpaceService spaceService;
    protected ModuleRegistry moduleRegistry;
    protected SpaceTemplateService spaceTemplateService;
    protected String templateName;

    public DefaultSpaceApplicationHandler(InitParams params, LayoutService layoutService, NavigationService navigationService, PageStorage pageService, SpaceTemplateService spaceTemplateService) {
        this.layoutService = layoutService;
        this.navigationService = navigationService;
        this.pageStorage = pageService;
        this.spaceTemplateService = spaceTemplateService;
        this.templateName = params == null ? NAME : params.getValueParam(TEMPLATE_NAME_PARAM).getValue();
    }

    public void initApps(Space space, SpaceTemplate spaceTemplate) throws SpaceException {
        try {
            NavigationContext navContext = SpaceUtils.createGroupNavigation(space.getGroupId());
            NodeContext parentNodeCtx = this.navigationService.loadNode(NodeModel.SELF_MODEL, navContext, Scope.CHILDREN, null);
            SpaceApplication homeApplication = spaceTemplate.getSpaceHomeApplication();
            if (homeApplication == null) {
                throw new IllegalStateException(String.format("Could not find space home application for template %s. Could not init space apps", spaceTemplate.getName()));
            }
            NodeContext<NodeContext<?>> homeNodeCtx = this.createPageNodeFromApplication(navContext, parentNodeCtx, space, homeApplication, null, true);
            List spaceApplications = spaceTemplate.getSpaceApplicationList();
            if (spaceApplications != null) {
                for (SpaceApplication spaceApplication : spaceApplications) {
                    try {
                        this.createPageNodeFromApplication(navContext, homeNodeCtx, space, spaceApplication, null, false);
                        this.getSpaceService().installApplication(space, spaceApplication.getPortletName());
                    }
                    catch (Exception e) {
                        LOG.warn("Can't install application {} for space {}, ignore adding dedicated page", new Object[]{spaceApplication.getPortletName(), space.getDisplayName()});
                    }
                }
            }
            this.navigationService.saveNode(parentNodeCtx, null);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_INIT_APP, (Throwable)e);
        }
    }

    public void deInitApp(Space space) throws SpaceException {
        try {
            String groupId = space.getGroupId();
            NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(groupId);
            if (spaceNavCtx == null) {
                return;
            }
            NodeContext<NodeContext<?>> homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(spaceNavCtx, groupId);
            Iterator iterator = homeNodeCtx.getNodes().iterator();
            while (iterator.hasNext()) {
                NodeContext child;
                NodeContext childNode = child = (NodeContext)iterator.next();
                Page page = this.layoutService.getPage(childNode.getState().getPageRef().format());
                this.layoutService.remove(page);
            }
            SpaceUtils.removeGroupNavigation(groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_DEINIT_APP, (Throwable)e);
        }
    }

    public void activateApplication(Space space, String appId, String appName) throws SpaceException {
        NavigationContext navContext;
        NavigationService navService = (NavigationService)ExoContainerContext.getService(NavigationService.class);
        NodeContext homeNodeCtx = null;
        try {
            navContext = SpaceUtils.getGroupNavigationContext(space.getGroupId());
            homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(navContext, null);
            homeNodeCtx = (NodeContext)homeNodeCtx.get(0);
        }
        catch (Exception e) {
            LOG.warn((Object)"space navigation not found.", (Throwable)e);
            return;
        }
        SpaceApplication spaceApplication = null;
        block2: for (SpaceTemplate spaceTemplate : this.spaceTemplateService.getSpaceTemplates()) {
            for (SpaceApplication application : spaceTemplate.getSpaceApplicationList()) {
                if (!appId.equals(application.getPortletName()) || SpaceUtils.isInstalledApp(space, appId)) continue;
                spaceApplication = application;
                continue block2;
            }
        }
        if (spaceApplication == null) {
            spaceApplication = new SpaceApplication();
            spaceApplication.setPortletName(appId);
        }
        this.createPageNodeFromApplication(navContext, homeNodeCtx, space, spaceApplication, appName, false);
        navService.saveNode(homeNodeCtx, null);
    }

    public void deactiveApplication(Space space, String appId) throws SpaceException {
        this.deactivateApplicationClassic(space, appId);
    }

    public void installApplication(Space space, String appId) throws SpaceException {
    }

    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        this.removeApplicationClassic(space, appId, appName);
    }

    public void removeApplications(Space space) throws SpaceException {
        try {
            String[] apps = space.getApp().split(",");
            String[] appPart = null;
            for (int i = 0; i < apps.length; ++i) {
                appPart = apps[i].split(":");
                this.removeApplication(space, appPart[0], appPart[1]);
            }
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATIONS, (Throwable)e);
        }
    }

    public void moveApplication(Space space, String appId, int transition) throws Exception {
        String apps = space.getApp();
        if (transition == 0 || apps == null || !StringUtils.contains((CharSequence)apps, (CharSequence)appId)) {
            return;
        }
        ArrayList<String> appPartsList = new ArrayList<String>(Arrays.asList(apps.split(",")));
        String appPartToChange = appPartsList.stream().filter(appPart -> appPart != null && StringUtils.startsWith((CharSequence)appPart, (CharSequence)(appId + ":"))).findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)appPartToChange)) {
            return;
        }
        String[] appParts = appPartToChange.split(":");
        NodeContext spaceUserNode = (NodeContext)this.getSpaceUserNode(space).get(0);
        NodeContext toMoveNode = null;
        Iterator nodes = spaceUserNode.getNodes().iterator();
        int nodeIndex = 0;
        while (toMoveNode == null && nodes.hasNext()) {
            NodeContext userNode = (NodeContext)nodes.next();
            String appName = appParts[1];
            if (StringUtils.equals((CharSequence)userNode.getName(), (CharSequence)appId) || StringUtils.equals((CharSequence)userNode.getName(), (CharSequence)appName) || userNode.getState().getPageRef() != null && (StringUtils.equals((CharSequence)userNode.getState().getPageRef().getName(), (CharSequence)appId) || StringUtils.equals((CharSequence)userNode.getState().getPageRef().getName(), (CharSequence)appName))) {
                toMoveNode = userNode;
                break;
            }
            ++nodeIndex;
        }
        if (toMoveNode != null) {
            int newIndex;
            if (transition < 0) {
                if (nodeIndex > 0) {
                    NodeContext previousNode = (NodeContext)spaceUserNode.get(nodeIndex - 1);
                    spaceUserNode.removeNode(previousNode.getName());
                    spaceUserNode.add(Integer.valueOf(nodeIndex), previousNode);
                }
            } else if (transition > 0 && (newIndex = nodeIndex + 1) < spaceUserNode.getNodeCount()) {
                spaceUserNode.removeNode(toMoveNode.getName());
                spaceUserNode.add(Integer.valueOf(newIndex), toMoveNode);
            }
        }
        ((NavigationService)ExoContainerContext.getService(NavigationService.class)).saveNode(spaceUserNode, null);
    }

    public void restoreApplicationLayout(Space space, String appId) throws Exception {
        NavigationService navService = (NavigationService)ExoContainerContext.getService(NavigationService.class);
        NavigationContext navContext = SpaceUtils.getGroupNavigationContext(space.getGroupId());
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, navContext, Scope.CHILDREN, null);
        String spaceTemplateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
        if (spaceTemplate == null) {
            throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)appId, (CharSequence)"home")) {
            SpaceApplication homeApplication = spaceTemplate.getSpaceHomeApplication();
            if (homeApplication == null) {
                throw new IllegalStateException("Could not find space home application for template " + spaceTemplate.getName() + ". Could not init space apps");
            }
            String originalHomePageName = ((NodeContext)parentNodeCtx.get(0)).getState().getPageRef().getName();
            this.createPageNodeFromApplication(navContext, parentNodeCtx, space, homeApplication, originalHomePageName, true);
        } else {
            SpaceApplication spaceApplication = this.getSpaceApplication(spaceTemplate, appId);
            NodeContext homeNodeCtx = (NodeContext)parentNodeCtx.get(0);
            this.createPageNodeFromApplication(navContext, homeNodeCtx, space, spaceApplication, null, false);
        }
    }

    public String getName() {
        return this.templateName;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String s) {
    }

    protected void deactivateApplicationClassic(Space space, String appId) {
    }

    protected void removeApplicationClassic(Space space, String appId, String appName) throws SpaceException {
        try {
            PageKey pageRef;
            UserNode spaceUserNode = SpaceUtils.getSpaceUserNode(space);
            UserNode removedNode = spaceUserNode.getChild(appName);
            if (removedNode == null) {
                for (UserNode node : spaceUserNode.getChildren()) {
                    if (!appId.equals(node.getPageRef().getName())) continue;
                    removedNode = spaceUserNode.getChild(node.getName());
                    break;
                }
            }
            if (removedNode == null) {
                String spaceTemplateName = space.getTemplate();
                SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
                if (spaceTemplate == null) {
                    throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
                }
                List spaceApplications = spaceTemplate.getSpaceApplicationList();
                for (SpaceApplication spaceApplication : spaceApplications) {
                    if (!appId.equals(spaceApplication.getPortletName())) continue;
                    removedNode = spaceUserNode.getChild(spaceApplication.getUri());
                }
            }
            if (removedNode == null) {
                return;
            }
            spaceUserNode.removeChild(removedNode.getName());
            if (removedNode != null && (pageRef = removedNode.getPageRef()).format() != null && pageRef.format().length() > 0) {
                if (WebuiRequestContext.getCurrentInstance() != null) {
                    UIPortal uiPortal = Util.getUIPortal();
                    uiPortal.setUIPage(pageRef.format(), null);
                }
                this.layoutService.remove(pageRef);
            }
            SpaceUtils.getUserPortal().saveNode(spaceUserNode, null);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_APPLICATION, (Throwable)e);
        }
    }

    protected NodeContext<NodeContext<?>> createPageNodeFromApplication(NavigationContext navContext, NodeContext<NodeContext<?>> nodeCtx, Space space, SpaceApplication spaceApplication, String appName, boolean isRoot) throws SpaceException {
        Application app;
        String appId = spaceApplication.getPortletName();
        String potletFullId = spaceApplication.getPortletApp() + "/" + spaceApplication.getPortletName();
        if (!this.isPortletActive(potletFullId)) {
            return null;
        }
        try {
            app = this.getApplication(appId);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)spaceApplication.getPortletApp())) {
                throw new IllegalStateException("An error occurred while getting application " + appId + " from registry. In fact, the application isn't configured with its application name (WAR webapp name). This may be the cause of the problem", e);
            }
            throw new IllegalStateException("An error occurred while getting application " + appId + " from registry.", e);
        }
        String contentId = app.getContentId();
        String appInstanceId = PortalConfig.GROUP_TYPE + "#" + space.getGroupId() + ":/" + contentId + "/" + app.getApplicationName() + System.currentTimeMillis();
        org.exoplatform.portal.config.model.Application<Portlet> portletApplication = this.createPortletApplication(appInstanceId, space, isRoot);
        portletApplication.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
        portletApplication.setShowInfoBar(false);
        String pageTitle = space.getDisplayName() + " - " + app.getDisplayName();
        String pageName = app.getApplicationName();
        if (SpaceUtils.isInstalledApp(space, appId) && appName != null) {
            pageName = appName;
        }
        UserPortalConfigService userPortalConfigService = this.getUserPortalConfigService();
        Page page = null;
        try {
            page = this.createSpacePage(userPortalConfigService, space, app, portletApplication, isRoot);
            page.setName(pageName);
            page.setTitle(pageTitle);
            String visibility = space.getVisibility();
            if (CollectionUtils.isNotEmpty((Collection)spaceApplication.getRoles())) {
                page.setAccessPermissions((String[])spaceApplication.getRoles().stream().map(r -> r + ":" + space.getGroupId()).toArray(String[]::new));
            } else if (StringUtils.equals((CharSequence)visibility, (CharSequence)"public")) {
                page.setAccessPermissions(new String[]{"Everyone"});
            } else {
                page.setAccessPermissions(new String[]{"*:" + space.getGroupId()});
            }
            page.setEditPermission("manager:" + space.getGroupId());
            page.setProfiles(spaceApplication.getProfiles());
            SiteKey siteKey = navContext.getKey();
            PageKey pageKey = new PageKey(siteKey, page.getName());
            PageState pageState = new PageState(page.getTitle(), page.getDescription(), page.isShowMaxWindow(), page.isHideSharedLayout(), page.getFactoryId(), page.getProfiles(), Arrays.asList(page.getAccessPermissions()), page.getEditPermission(), Arrays.asList(page.getMoveAppsPermissions()), Arrays.asList(page.getMoveContainersPermissions()), PageType.PAGE.name(), null);
            this.pageStorage.savePage(new PageContext(pageKey, pageState));
            this.layoutService.save(page);
        }
        catch (Exception e) {
            LOG.warn("Error while creating the Page '{}' for space '{}'", new Object[]{pageTitle, space.getDisplayName(), e});
        }
        if (isRoot) {
            pageName = space.getUrl();
        } else if (spaceApplication.getUri() != null && !spaceApplication.getUri().isEmpty()) {
            pageName = spaceApplication.getUri();
        }
        NodeContext childNodeCtx = null;
        try {
            childNodeCtx = nodeCtx.add(null, pageName);
        }
        catch (Exception e) {
            LOG.debug("Tree t={} already in the map", new Object[]{pageName});
            childNodeCtx = nodeCtx.get(pageName);
        }
        NodeState.Builder nodeStateBuilder = new NodeState.Builder().icon(spaceApplication.getIcon()).pageRef(PageKey.parse((String)page.getPageId()));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context != null && !context.getApplicationResourceBundle().containsKey(appId + ".label.name")) {
            nodeStateBuilder.label(app.getDisplayName());
        } else {
            nodeStateBuilder.label("#{" + appId + ".label.name}");
        }
        childNodeCtx.setState(nodeStateBuilder.build());
        return childNodeCtx;
    }

    protected Page createSpacePage(UserPortalConfigService userPortalConfigService, Space space, Application app, org.exoplatform.portal.config.model.Application<Portlet> portletApplication, boolean isRoot) throws Exception {
        Page page;
        if (isRoot) {
            page = userPortalConfigService.createPageTemplate("spaceHomePage", PortalConfig.GROUP_TYPE, space.getGroupId());
        } else {
            page = userPortalConfigService.createPageTemplate("space", PortalConfig.GROUP_TYPE, space.getGroupId());
            this.setPage(space, app, portletApplication, page);
        }
        return page;
    }

    protected Application getApplication(String appId) throws SpaceException {
        Application application = SpaceUtils.getApplication(appId);
        if (application == null && appId.contains("/")) {
            application = SpaceUtils.getApplication(appId.split("/")[1]);
        }
        if (application == null) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_LIST_AVAILABLE_APPLICATIONS);
        }
        return application;
    }

    protected void setPage(Space space, Application app, org.exoplatform.portal.config.model.Application<Portlet> portletApplication, Page page) {
        ArrayList<ModelObject> pageChilds = page.getChildren();
        Container container = SpaceUtils.findContainerById(pageChilds, APPLICATION_CONTAINER);
        ArrayList children = container.getChildren();
        children.add(portletApplication);
        container.setChildren(children);
        pageChilds = this.setContainerById(pageChilds, container);
        page.setChildren(pageChilds);
        this.setPermissionForPage(page.getChildren(), "*:" + space.getGroupId());
    }

    protected void setPermissionForPage(ArrayList<ModelObject> children, String perm) {
        for (ModelObject modelObject : children) {
            if (modelObject instanceof org.exoplatform.portal.config.model.Application) {
                ((org.exoplatform.portal.config.model.Application)modelObject).setAccessPermissions(new String[]{perm});
                continue;
            }
            if (!(modelObject instanceof Container)) continue;
            ((Container)modelObject).setAccessPermissions(new String[]{perm});
            this.setPermissionForPage(((Container)modelObject).getChildren(), perm);
        }
    }

    protected ArrayList<ModelObject> setContainerById(ArrayList<ModelObject> childs, Container container) {
        ArrayList<ModelObject> result = childs;
        int index = result.indexOf(container);
        if (index != -1) {
            result.set(index, (ModelObject)container);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ModelObject obj = result.get(i);
                if (org.exoplatform.portal.config.model.Application.class.isInstance(obj)) continue;
                Container objContainer = (Container)obj;
                ArrayList<ModelObject> tmp = this.setContainerById(objContainer.getChildren(), container);
                objContainer.setChildren(tmp);
                result.set(i, (ModelObject)objContainer);
            }
        }
        return result;
    }

    protected org.exoplatform.portal.config.model.Application<Portlet> createPortletApplication(String instanceId, Space space, boolean isRoot) {
        int i0 = instanceId.indexOf("#");
        int i1 = instanceId.indexOf(":/", i0 + 1);
        String ownerType = instanceId.substring(0, i0);
        String ownerId = instanceId.substring(i0 + 1, i1);
        String persistenceid = instanceId.substring(i1 + 2);
        String[] persistenceChunks = Utils.split((String)"/", (String)persistenceid);
        PortletBuilder pb = new PortletBuilder();
        String spaceTemplateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(spaceTemplateName);
        if (spaceTemplate == null) {
            throw new IllegalStateException("Space template with name " + spaceTemplateName + " wasn't found");
        }
        List spaceApplicationList = spaceTemplate.getSpaceApplicationList();
        SpaceApplication spaceApplication = null;
        Iterator iterator = spaceApplicationList.iterator();
        while (iterator.hasNext() && spaceApplication == null) {
            SpaceApplication tmpSpaceApplication = (SpaceApplication)iterator.next();
            if (!instanceId.contains(tmpSpaceApplication.getPortletName())) continue;
            spaceApplication = tmpSpaceApplication;
        }
        if (spaceApplication != null && spaceApplication.getPreferences() != null) {
            Set entrySet = spaceApplication.getPreferences().entrySet();
            try {
                for (Map.Entry entry : entrySet) {
                    pb.add((String)entry.getKey(), this.getSubstituteValueFromPattern(space, spaceApplication, (String)entry.getValue()));
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        TransientApplicationState portletState = new TransientApplicationState(persistenceChunks[0] + "/" + persistenceChunks[1], (Object)pb.build(), ownerType, ownerId);
        org.exoplatform.portal.config.model.Application portletApp = org.exoplatform.portal.config.model.Application.createPortletApplication();
        portletApp.setState((ApplicationState)portletState);
        return portletApp;
    }

    protected String getSubstituteValueFromPattern(Space space, SpaceApplication spaceApplication, String pattern) {
        if (!pattern.contains("{") || !pattern.contains("}")) {
            return pattern;
        }
        if (pattern.contains(GROUP_ID_PREFERENCE)) {
            pattern = pattern.replace(GROUP_ID_PREFERENCE, space.getGroupId());
        } else if (pattern.contains(MODIFIED_GROUP_ID_PREFERENCE)) {
            String modifiedGroupId = space.getGroupId().replace("/", ".");
            pattern = pattern.replace(MODIFIED_GROUP_ID_PREFERENCE, modifiedGroupId);
        } else if (pattern.contains(PAGE_NAME_PREFERENCE)) {
            pattern = pattern.replace(PAGE_NAME_PREFERENCE, spaceApplication.getAppTitle());
        } else if (pattern.contains(PAGE_URL_PREFERENCE)) {
            pattern = pattern.replace(PAGE_URL_PREFERENCE, spaceApplication.getUri());
        }
        return pattern;
    }

    protected UserPortalConfigService getUserPortalConfigService() {
        return (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
    }

    protected SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    protected boolean isPortletActive(String potletFullId) {
        ModuleRegistry moduleRegistry = this.getModuleRegistry();
        if (moduleRegistry == null) {
            return true;
        }
        return moduleRegistry.isPortletActive(potletFullId);
    }

    protected ModuleRegistry getModuleRegistry() {
        if (this.moduleRegistry == null) {
            this.moduleRegistry = (ModuleRegistry)CommonsUtils.getService(ModuleRegistry.class);
        }
        return this.moduleRegistry;
    }

    protected NodeContext<NodeContext<?>> getSpaceUserNode(Space space) throws Exception {
        NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(space.getGroupId());
        return ((NavigationService)ExoContainerContext.getService(NavigationService.class)).loadNode(NodeModel.SELF_MODEL, spaceNavCtx, Scope.ALL, null);
    }

    protected SpaceApplication getSpaceApplication(SpaceTemplate spaceTemplate, String appId) throws SpaceException {
        Application application;
        try {
            application = this.getApplication(appId);
        }
        catch (SpaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.APPLICATION_NOT_FOUND);
        }
        SpaceApplication spaceApplication = spaceTemplate.getSpaceApplicationList().stream().filter(app -> StringUtils.equalsIgnoreCase((CharSequence)application.getApplicationName(), (CharSequence)app.getPortletName())).findFirst().orElse(null);
        if (spaceApplication == null) {
            throw new SpaceException(SpaceException.Code.APPLICATION_NOT_FOUND_IN_TEMPLATE);
        }
        return spaceApplication;
    }
}

