/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.portal.jdbc.entity.DescriptionEntity;
import org.exoplatform.portal.jdbc.entity.DescriptionState;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.dao.DescriptionDAO;
import org.exoplatform.portal.mop.storage.DescriptionStorage;

public class DescriptionStorageImpl
implements DescriptionStorage {
    private static final String DESCRIPTION_IDENTIFIER_IS_MANDATORY = "Description identifier is mandatory";
    private static final String NO_VARIANT_CAB_BE_SET_ON_LOCALE = "No variant cab be set on locale";
    private static final String NO_LANGUAGE_SET_ON_LOCALE = "No language set on locale";
    private static final String NO_NULL_LOCALE_ACCEPTED = "No null locale accepted";
    private static final String NO_NULL_ID_ACCEPTED = "No null id accepted";
    private DescriptionDAO descriptionDAO;

    public DescriptionStorageImpl(DescriptionDAO descriptionDAO) {
        this.descriptionDAO = descriptionDAO;
    }

    public State resolveDescription(String id, Locale defaultLocale, Locale locale) throws NullPointerException {
        State state = this.resolveDescription(id, locale);
        if (state == null && defaultLocale != null) {
            state = this.resolveDescription(id, defaultLocale);
        }
        return state;
    }

    public State resolveDescription(String id, Locale locale) throws NullPointerException {
        return this.getDescription(id, locale, true);
    }

    public State getDescription(String id, Locale locale) {
        return this.getDescription(id, locale, false);
    }

    public State getDescription(String id) {
        return this.getDescription(id, null, false);
    }

    public Map<Locale, State> getDescriptions(String id) {
        Map<String, DescriptionState> localized;
        if (id == null) {
            throw new NullPointerException(NO_NULL_ID_ACCEPTED);
        }
        HashMap<Locale, State> names = null;
        DescriptionEntity desc = this.descriptionDAO.getByRefId(id);
        if (desc != null && (localized = desc.getLocalized()) != null) {
            names = new HashMap<Locale, State>(localized.size());
            for (Map.Entry<String, DescriptionState> entry : localized.entrySet()) {
                DescriptionState state = entry.getValue();
                names.put(I18N.parseTagIdentifier((String)entry.getKey()), new State(state.getName(), state.getDescription()));
            }
        }
        return names;
    }

    public void setDescription(String id, Locale locale, State description) {
        if (id == null) {
            throw new NullPointerException(NO_NULL_ID_ACCEPTED);
        }
        if (locale == null) {
            throw new NullPointerException(NO_NULL_LOCALE_ACCEPTED);
        }
        if (locale.getLanguage().length() == 0) {
            throw new IllegalArgumentException(NO_LANGUAGE_SET_ON_LOCALE);
        }
        if (locale.getVariant().length() > 0) {
            throw new IllegalArgumentException(NO_VARIANT_CAB_BE_SET_ON_LOCALE);
        }
        HashMap<String, DescriptionState> state = new HashMap<String, DescriptionState>();
        DescriptionEntity entity = this.descriptionDAO.getByRefId(id);
        if (entity != null) {
            state.putAll(entity.getLocalized());
        }
        if (description != null) {
            state.put(I18N.toTagIdentifier((Locale)locale), new DescriptionState(description.getName(), description.getDescription()));
        } else {
            state.remove(I18N.toTagIdentifier((Locale)locale));
        }
        this.descriptionDAO.saveDescriptions(id, state);
    }

    public void setDescription(String id, State description) {
        if (id == null) {
            throw new NullPointerException(NO_NULL_ID_ACCEPTED);
        }
        if (description != null) {
            this.descriptionDAO.saveDescription(id, new DescriptionState(description.getName(), description.getDescription()));
        } else {
            this.descriptionDAO.deleteByRefId(id);
        }
    }

    public void setDescriptions(String id, Map<Locale, State> descriptions) {
        if (id == null) {
            throw new NullPointerException(NO_NULL_ID_ACCEPTED);
        }
        if (descriptions != null) {
            HashMap<String, DescriptionState> localized = new HashMap<String, DescriptionState>(descriptions.size());
            for (Map.Entry<Locale, State> entry : descriptions.entrySet()) {
                Locale locale = entry.getKey();
                State state = entry.getValue();
                if (locale.getLanguage().length() == 0) {
                    throw new IllegalArgumentException(NO_LANGUAGE_SET_ON_LOCALE);
                }
                if (locale.getVariant().length() > 0) {
                    throw new IllegalArgumentException(NO_VARIANT_CAB_BE_SET_ON_LOCALE);
                }
                localized.put(I18N.toTagIdentifier((Locale)locale), new DescriptionState(state.getName(), state.getDescription()));
            }
            this.descriptionDAO.saveDescriptions(id, localized);
        } else {
            this.descriptionDAO.deleteByRefId(id);
        }
    }

    public State getDescription(String id, Locale locale, boolean checkParent) {
        if (id == null) {
            throw new IllegalArgumentException(DESCRIPTION_IDENTIFIER_IS_MANDATORY);
        }
        DescriptionEntity desc = this.descriptionDAO.getByRefId(id);
        if (desc != null) {
            if (locale == null) {
                DescriptionState state = desc.getState();
                if (state != null) {
                    return new State(state.getName(), state.getDescription());
                }
            } else {
                do {
                    DescriptionState state;
                    if ((state = desc.getLocalized().get(I18N.toTagIdentifier((Locale)locale))) != null) {
                        return new State(state.getName(), state.getDescription());
                    }
                    locale = this.parent(locale);
                } while (checkParent && locale != null);
            }
        }
        return null;
    }

    private Locale parent(Locale locale) {
        if (locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        return null;
    }
}

