/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.SpaceTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiHomeTreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.utils.Utils;

public class TreeUtils {
    public static TreeNode getTreeNode(WikiPageParams params) throws Exception {
        Object wikiObject = Utils.getObjectFromParams(params);
        if (wikiObject instanceof Page) {
            Page page = (Page)wikiObject;
            if (params.getPageName().equals("Home")) {
                WikiHomeTreeNode wikiHomeNode = new WikiHomeTreeNode(page);
                return wikiHomeNode;
            }
            PageTreeNode pageNode = new PageTreeNode(page);
            return pageNode;
        }
        if (wikiObject instanceof Wiki) {
            Wiki wiki = (Wiki)wikiObject;
            WikiTreeNode wikiNode = new WikiTreeNode(wiki);
            return wikiNode;
        }
        if (wikiObject instanceof String) {
            SpaceTreeNode spaceNode = new SpaceTreeNode((String)wikiObject);
            return spaceNode;
        }
        return new TreeNode();
    }

    public static TreeNode getDescendants(WikiPageParams params, HashMap<String, Object> context, String userId) throws Exception {
        TreeNode treeNode = TreeUtils.getTreeNode(params);
        treeNode.pushDescendants(context, userId);
        return treeNode;
    }

    public static List<JsonNodeData> tranformToJson(TreeNode treeNode, HashMap<String, Object> context) throws Exception {
        NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
        int counter = 1;
        Boolean showExcerpt = false;
        Page currentPage = null;
        String currentPath = null;
        Boolean canEdit = false;
        if (context != null) {
            currentPath = (String)context.get("page");
            currentPage = (Page)context.get("currentPage");
            showExcerpt = (Boolean)context.get("excerpt");
            canEdit = (Boolean)context.get("canEdit");
        }
        ArrayList<JsonNodeData> children = new ArrayList<JsonNodeData>();
        for (TreeNode child : treeNode.getChildren()) {
            boolean isLastNode;
            boolean isSelectable = true;
            boolean bl = isLastNode = counter >= treeNode.getChildren().size();
            if (child.getNodeType().equals((Object)TreeNodeType.WIKI)) {
                isSelectable = false;
            } else if (child.getNodeType().equals((Object)TreeNodeType.PAGE)) {
                page = ((PageTreeNode)child).getPage();
                if (currentPage != null && (currentPage.equals(page) || Utils.isDescendantPage(page, currentPage))) {
                    isSelectable = false;
                }
                if (!noteService.hasPermissionOnPage(page, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity())) {
                    isSelectable = false;
                    child.setRetricted(true);
                }
                if (BooleanUtils.isTrue((Boolean)canEdit) && !noteService.hasPermissionOnPage(page, PermissionType.EDITPAGE, ConversationState.getCurrent().getIdentity())) {
                    isSelectable = false;
                    child.setRetricted(true);
                }
            } else if (child.getNodeType().equals((Object)TreeNodeType.WIKIHOME)) {
                page = ((WikiHomeTreeNode)child).getWikiHome();
                if (!noteService.hasPermissionOnPage(page, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity())) {
                    isSelectable = false;
                    child.setRetricted(true);
                }
                if (BooleanUtils.isTrue((Boolean)canEdit) && !noteService.hasPermissionOnPage(page, PermissionType.EDITPAGE, ConversationState.getCurrent().getIdentity())) {
                    isSelectable = false;
                    child.setRetricted(true);
                }
            }
            String excerpt = null;
            if (showExcerpt != null && showExcerpt.booleanValue()) {
                WikiPageParams params = TreeUtils.getPageParamsFromPath(child.getPath());
                excerpt = "";
            }
            children.add(new JsonNodeData(child, isLastNode, isSelectable, currentPath, excerpt, context));
            ++counter;
        }
        return children;
    }

    public static WikiPageParams getPageParamsFromPath(String path) throws Exception {
        if (path == null) {
            return null;
        }
        WikiPageParams result = new WikiPageParams();
        if ((path = path.trim()).indexOf("/") < 0) {
            result.setType(path);
        } else {
            String[] array = path.split("/");
            result.setType(array[0]);
            if (array.length < 3) {
                result.setOwner(array[1]);
            } else if (array.length >= 3) {
                if (array[0].equals(PortalConfig.GROUP_TYPE)) {
                    OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                    String groupId = path.substring(path.indexOf("/"));
                    if (oService.getGroupHandler().findGroupById(groupId) != null) {
                        result.setOwner(groupId);
                    } else {
                        String pageName = path.substring(path.lastIndexOf("/") + 1);
                        if (StringUtils.isBlank((CharSequence)pageName)) {
                            pageName = "Home";
                        }
                        result.setPageName(pageName);
                        String owner = path.substring(path.indexOf("/"), path.lastIndexOf("/"));
                        while (oService.getGroupHandler().findGroupById(owner) == null) {
                            owner = owner.substring(0, owner.lastIndexOf("/"));
                        }
                        result.setOwner(owner);
                    }
                } else {
                    result.setOwner(array[1]);
                    result.setPageName(array[array.length - 1]);
                }
            }
        }
        return result;
    }

    public static String getPathFromPageParams(WikiPageParams param) {
        StringBuilder sb = new StringBuilder();
        if (param.getType() != null) {
            sb.append(param.getType());
        }
        if (param.getOwner() != null) {
            sb.append("/").append(Utils.validateWikiOwner(param.getType(), param.getOwner()));
        }
        if (param.getPageName() != null) {
            sb.append("/").append(param.getPageName());
        }
        return sb.toString();
    }

    public static List<JsonNodeData> cleanDraftChildren(List<JsonNodeData> children, Locale locale) {
        ArrayList<Locale> localesList = new ArrayList<Locale>(LocaleContextInfoUtils.getSupportedLocales());
        List targetList = children.stream().map(JsonNodeData::getTargetPageId).distinct().collect(Collectors.toList());
        List<JsonNodeData> cleanedChildren = children.stream().filter(jsonNodeData -> !jsonNodeData.isDraftPage() || StringUtils.isEmpty((CharSequence)jsonNodeData.getTargetPageId())).collect(Collectors.toList());
        for (String target : targetList) {
            if (!StringUtils.isNotEmpty((CharSequence)target)) continue;
            List subJsonNodeDataList = children.stream().filter(jsonNodeData -> StringUtils.equals((CharSequence)jsonNodeData.getTargetPageId(), (CharSequence)target)).collect(Collectors.toList());
            if (subJsonNodeDataList.size() > 1) {
                JsonNodeData currentLangDraft = null;
                JsonNodeData originalLangDraft = null;
                JsonNodeData anyLangDraft = null;
                ArrayList<JsonNodeData> subCleanedChildren = new ArrayList<JsonNodeData>();
                for (JsonNodeData nodeData : subJsonNodeDataList) {
                    if (StringUtils.isEmpty((CharSequence)nodeData.getLang())) {
                        originalLangDraft = nodeData;
                        continue;
                    }
                    if (nodeData.getLang().equals(locale.getLanguage())) {
                        currentLangDraft = nodeData;
                        continue;
                    }
                    if (anyLangDraft != null && TreeUtils.getLocatedLangDisplayName(localesList, locale, nodeData.getLang()).compareToIgnoreCase(TreeUtils.getLocatedLangDisplayName(localesList, locale, anyLangDraft.getLang())) >= 0) continue;
                    anyLangDraft = nodeData;
                }
                if (currentLangDraft != null) {
                    subCleanedChildren.add(currentLangDraft);
                } else if (originalLangDraft != null) {
                    subCleanedChildren.add(originalLangDraft);
                } else {
                    subCleanedChildren.add(anyLangDraft);
                }
                cleanedChildren.addAll(subCleanedChildren);
                continue;
            }
            cleanedChildren.addAll(subJsonNodeDataList);
        }
        return cleanedChildren;
    }

    public static String getLocatedLangDisplayName(List<Locale> localesList, Locale currentLocale, String lang) {
        Optional<Locale> opLocal = localesList.stream().filter(local -> local.getLanguage().equals(lang)).findAny();
        if (opLocal.isPresent()) {
            return opLocal.get().getDisplayName(currentLocale);
        }
        return lang;
    }
}

