/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.jdbc.mutation.internal.StandardMutationExecutorService;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class MutationExecutorServiceInitiator
implements StandardServiceInitiator<MutationExecutorService> {
    public static final MutationExecutorServiceInitiator INSTANCE = new MutationExecutorServiceInitiator();
    public static final String EXECUTOR_KEY = "hibernate.jdbc.mutation.executor";

    @Override
    public Class<MutationExecutorService> getServiceInitiated() {
        return MutationExecutorService.class;
    }

    @Override
    public MutationExecutorService initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        Class customImplClass;
        Object custom = configurationValues.get(EXECUTOR_KEY);
        if (custom == null) {
            return this.createStandardService(configurationValues, registry);
        }
        if (custom instanceof MutationExecutorService) {
            return (MutationExecutorService)custom;
        }
        if (custom instanceof Class) {
            customImplClass = (Class)custom;
        } else {
            ClassLoaderService classLoaderService = registry.requireService(ClassLoaderService.class);
            customImplClass = classLoaderService.classForName(custom.toString());
        }
        try {
            return (MutationExecutorService)customImplClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Could not locate appropriate MutationExecutorService constructor : " + customImplClass.getName(), e);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instantiate custom MutationExecutorService : " + customImplClass.getName(), e);
        }
    }

    private MutationExecutorService createStandardService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        return new StandardMutationExecutorService(configurationValues);
    }
}

