/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacesadministration;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.MembershipEntityWrapper;
import org.exoplatform.social.rest.entity.SpacesAdministrationMembershipsEntity;

@Path(value="v1/social/spacesAdministration")
@Tag(name="v1/social/spacesAdministration", description="Managing Spaces Administration settings")
public class SpacesAdministrationRest
implements ResourceContainer {
    private SpacesAdministrationService spacesAdministrationService;

    public SpacesAdministrationRest(SpacesAdministrationService spacesAdministrationService) {
        this.spacesAdministrationService = spacesAdministrationService;
    }

    @GET
    @Path(value="permissions")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets all spaces administrators permissions settings", method="GET", description="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User unauthorized"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getAllSettings(@Context UriInfo uriInfo) {
        List<SpacesAdministrationMembershipsEntity> settings = Arrays.asList(new SpacesAdministrationMembershipsEntity("spacesAdministrators", this.spacesAdministrationService.getSpacesAdministratorsMemberships()), new SpacesAdministrationMembershipsEntity("spacesCreators", this.spacesAdministrationService.getSpacesCreatorsMemberships()));
        return EntityBuilder.getResponse(settings, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="permissions/spacesAdministrators")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets spaces administrators memberships", method="GET", description="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpacesAdministrators(@Context UriInfo uriInfo) {
        List memberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        return EntityBuilder.getResponse(new SpacesAdministrationMembershipsEntity("spacesAdministrators", memberships), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="permissions/spacesCreators")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets spaces creators memberships", method="GET", description="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpacesCreators(@Context UriInfo uriInfo) {
        List memberships = this.spacesAdministrationService.getSpacesCreatorsMemberships();
        return EntityBuilder.getResponse(new SpacesAdministrationMembershipsEntity("spacesCreators", memberships), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="permissions/canCreatespaces/{username}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Check if members can create spaces", method="GET", description="This returns if members can add spaces")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response canCreatespaces(@Context UriInfo uriInfo, @Parameter(description="Username", required=true) @PathParam(value="username") String username) {
        Boolean canCreateSpaces = this.spacesAdministrationService.canCreateSpace(username);
        return EntityBuilder.getResponse(canCreateSpaces.toString(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="permissions/spacesAdministrators")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Updates spaces creators memberships", method="PUT", description="This updates the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user  but he cannot update his own membership to \"approved\" for a space with a \"validation\" subscription</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSpacesAdministrators(@Context UriInfo uriInfo, @RequestBody(description="Space membership object to be updated", required=true) List<MembershipEntityWrapper> model) {
        List memberships = model.stream().map(m -> new MembershipEntry(m.getGroup(), m.getMembershipType())).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(memberships);
        return EntityBuilder.getResponse("", uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="permissions/spacesCreators")
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Updates spaces creators memberships", method="PUT", description="This updates the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user  but he cannot update his own membership to \"approved\" for a space with a \"validation\" subscription</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSpacesCreators(@Context UriInfo uriInfo, @RequestBody(description="Space membership object to be updated", required=true) List<MembershipEntityWrapper> model) {
        List memberships = model.stream().map(m -> new MembershipEntry(m.getGroup(), m.getMembershipType())).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(memberships);
        return EntityBuilder.getResponse("", uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

